/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.kernel.internal.ds;

import java.util.HashSet;
import java.util.Set;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.rule.common.exception.RuleConfigurationException;
import org.wso2.carbon.rule.kernel.config.RuleEngineConfigService;
import org.wso2.carbon.rule.kernel.config.RuleEngineProvider;

public class RuleValueHolder {
    private static RuleValueHolder ruleValueHolder = new RuleValueHolder();
    private RuleEngineConfigService ruleEngineConfigService;
    private EventBroker eventBroker;
    private Set<Subscription> pendingSubscriptions = new HashSet<Subscription>();

    public static RuleValueHolder getInstance() {
        return ruleValueHolder;
    }

    public void registerRuleEngineConfigService(RuleEngineConfigService ruleEngineConfigService) {
        this.ruleEngineConfigService = ruleEngineConfigService;
    }

    public RuleEngineConfigService getRuleEngineConfigService() {
        return this.ruleEngineConfigService;
    }

    public RuleEngineProvider getRuleEngineProvider() {
        RuleEngineProvider ruleEngineProvider = null;
        if (this.ruleEngineConfigService != null) {
            ruleEngineProvider = this.ruleEngineConfigService.getRuleConfig().getRuleEngineProvider();
        }
        return ruleEngineProvider;
    }

    public synchronized void registerEventBroker(EventBroker eventBroker) throws RuleConfigurationException {
        this.eventBroker = eventBroker;
        this.subscribePendingSubscriptions();
        this.pendingSubscriptions.clear();
    }

    private void subscribePendingSubscriptions() throws RuleConfigurationException {
        for (Subscription subscription : this.pendingSubscriptions) {
            try {
                this.eventBroker.subscribe(subscription);
            }
            catch (EventBrokerException e) {
                throw new RuleConfigurationException("Can not subscribe to topic " + subscription.getTopicName(), (Throwable)e);
            }
        }
    }

    public EventBroker getEventBroker() {
        return this.eventBroker;
    }

    public synchronized void addSubscription(Subscription subscription) throws RuleConfigurationException {
        if (this.eventBroker != null) {
            try {
                this.eventBroker.subscribe(subscription);
            }
            catch (EventBrokerException e) {
                throw new RuleConfigurationException("Can not subscribe to topic " + subscription.getTopicName(), (Throwable)e);
            }
        } else {
            this.pendingSubscriptions.add(subscription);
        }
    }
}

