/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.File;
import java.util.UUID;

public class FileManager {
    private File root;

    public void setUp() {
        this.root = this.getRootDirectory();
    }

    public void tearDown() {
        boolean result = false;
        for (int i = 0; i < 5 && !result; ++i) {
            System.gc();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("This should never happen");
            }
            result = this.deleteDir(this.root);
        }
    }

    public File newFile(String name) {
        File file = new File(this.getRootDirectory(), name);
        return file;
    }

    public File newFile(File dir, String name) {
        File file = new File(dir, name);
        return file;
    }

    public File getRootDirectory() {
        if (this.root != null) {
            return this.root;
        }
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        File f = new File(tmp, "__drools__" + UUID.randomUUID().toString());
        if (f.exists()) {
            if (f.isFile()) {
                throw new IllegalStateException("The temp directory exists as a file. Nuke it now !");
            }
            this.deleteDir(f);
            f.mkdir();
        } else {
            f.mkdir();
        }
        this.root = f;
        return this.root;
    }

    public boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            for (String child : children = dir.list()) {
                File file = new File(dir, child);
                boolean success = this.deleteDir(file);
                if (success) continue;
                System.gc();
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("This should never happen");
                }
                success = this.deleteDir(file);
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

