/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.ws.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.utils.CarbonUtils;

public class RuleServiceFileUploadAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(RuleServiceFileUploadAdmin.class);

    public String uploadService(String fileName, DataHandler dataHandler) throws Exception {
        try {
            AxisConfiguration axisConfig = this.getAxisConfig();
            String repo = axisConfig.getRepository().getPath();
            if (CarbonUtils.isURL((String)repo)) {
                throw new AxisFault("Uploading services to URL repo is not supported ");
            }
            String servicesDir = repo + File.separator + "ruleservices";
            this.writeToFileSystem(servicesDir, fileName, dataHandler);
        }
        catch (Exception e) {
            String msg = "Error occurred while uploading the service " + fileName;
            log.error((Object)msg, (Throwable)e);
            throw new Exception("Failed to upload the service archive " + fileName, e);
        }
        return "successful";
    }

    private void writeToFileSystem(String path, String fileName, DataHandler dataHandler) throws Exception {
        File destFile;
        File directory = new File(path);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        if (!(destFile = new File(path, fileName)).exists()) {
            destFile.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(destFile);
        dataHandler.writeTo((OutputStream)fos);
        fos.flush();
        fos.close();
    }
}

