/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.ws.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.rule.common.RuleService;
import org.wso2.carbon.rule.common.config.RuleServiceHelper;
import org.wso2.carbon.rule.common.exception.RuleConfigurationException;
import org.wso2.carbon.rule.ws.admin.RuleServiceAdminHandler;
import org.wso2.carbon.rule.ws.admin.RuleServiceArchiveAdminHandler;
import org.wso2.carbon.rule.ws.admin.RuleServiceFileAdminHandler;
import org.wso2.carbon.rule.ws.admin.exception.RuleServiceAdminException;

public class RuleServiceAdmin
extends AbstractAdmin {
    private static final RuleServiceAdminHandler RULE_FILE_HANDLER = new RuleServiceFileAdminHandler();
    private static final RuleServiceAdminHandler RULE_ARCHIVE_HANDLER = new RuleServiceArchiveAdminHandler();
    private static final Log log = LogFactory.getLog(RuleServiceAdmin.class);
    private static final OMFactory OM_FACTORY = OMAbstractFactory.getOMFactory();
    private static final OMNamespace NULL_NS = OM_FACTORY.createOMNamespace("", "");

    public void addRuleService(String fileExtension, String name, OMElement ruleServiceXML) throws RuleServiceAdminException {
        RuleServiceAdmin.validateName(name);
        RuleServiceAdmin.validateElement(ruleServiceXML);
        try {
            RuleService ruleService = RuleServiceHelper.getRuleService((OMElement)ruleServiceXML);
            RuleServiceAdmin.validateRuleServiceDescription(ruleService, ruleServiceXML);
            AxisConfiguration axisConfig = this.getAxisConfig();
            AxisService axisService = axisConfig.getService(name);
            if (axisService != null) {
                throw new RuleServiceAdminException("There is already a service with the given name : ");
            }
            RuleServiceAdminHandler adminHandler = this.getRuleServiceAdminHandler(fileExtension);
            adminHandler.saveRuleService(this.getAxisConfig(), axisService, ruleService);
        }
        catch (AxisFault axisFault) {
            throw new RuleServiceAdminException("Error while accessing the service with the name : " + name, axisFault);
        }
        catch (RuleConfigurationException e) {
            throw new RuleServiceAdminException("Can not parse the received xml");
        }
    }

    public void editRuleService(String fileExtension, String name, OMElement ruleServiceXML) throws RuleServiceAdminException {
        RuleServiceAdmin.validateName(name);
        RuleServiceAdmin.validateElement(ruleServiceXML);
        try {
            RuleService ruleService = RuleServiceHelper.getRuleService((OMElement)ruleServiceXML);
            RuleServiceAdmin.validateRuleServiceDescription(ruleService, ruleServiceXML);
            AxisConfiguration axisConfig = this.getAxisConfig();
            AxisService axisService = axisConfig.getService(name);
            if (axisService == null) {
                this.addRuleService(fileExtension, name, ruleServiceXML);
                return;
            }
            axisService.addParameter("keepServiceHistory", (Object)"true");
            AxisServiceGroup axisServiceGroup = axisService.getAxisServiceGroup();
            axisServiceGroup.addParameter("keepServiceHistory", (Object)"true");
            axisServiceGroup.addParameter("preserveServiceHistory", (Object)"true");
            RuleServiceAdminHandler adminHandler = this.getRuleServiceAdminHandler(fileExtension);
            adminHandler.saveRuleService(this.getAxisConfig(), axisService, ruleService);
        }
        catch (AxisFault axisFault) {
            throw new RuleServiceAdminException("Error while accessing the service with the name : " + name, axisFault);
        }
        catch (RuleConfigurationException e) {
            throw new RuleServiceAdminException("Error when parsing the rule xml");
        }
    }

    public String[] getAllRuleServices() throws RuleServiceAdminException {
        ArrayList<String> serviceList = new ArrayList<String>();
        HashMap map = this.getAxisConfig().getServices();
        Set set = map.keySet();
        for (String serviceName : set) {
            try {
                AxisService axisService = this.getAxisConfig().getService(serviceName);
                Parameter parameter = axisService.getParameter("serviceType");
                if (parameter == null || !"rule_service".equals(parameter.getValue().toString())) continue;
                serviceList.add(serviceName);
            }
            catch (AxisFault axisFault) {
                throw new RuleServiceAdminException("Error while accessing the service with the name : " + serviceName, axisFault);
            }
        }
        return serviceList.toArray(new String[serviceList.size()]);
    }

    public String[] uploadFacts(String serviceName, String fileName, DataHandler dataHandler) throws RuleServiceAdminException {
        RuleServiceAdminHandler adminHandler = this.getRuleServiceAdminHandler("aar");
        return adminHandler.uploadFacts(this.getAxisConfig(), serviceName, fileName, dataHandler);
    }

    public void uploadRuleFile(String serviceName, String fileName, DataHandler dataHandler) throws RuleServiceAdminException {
        RuleServiceAdminHandler adminHandler = this.getRuleServiceAdminHandler("aar");
        adminHandler.uploadRuleFile(this.getAxisConfig(), serviceName, fileName, dataHandler);
    }

    public String[] getAllFacts(String fileExtension, String serviceName) throws RuleServiceAdminException {
        RuleServiceAdminHandler adminHandler = this.getRuleServiceAdminHandler(fileExtension);
        return adminHandler.getAllFacts(this.getAxisConfig(), serviceName);
    }

    public OMElement getRuleService(String serviceName) throws RuleServiceAdminException {
        RuleServiceAdmin.validateName(serviceName);
        AxisConfiguration axisConfig = this.getAxisConfig();
        try {
            AxisService axisService = axisConfig.getService(serviceName);
            if (axisService == null) {
                ConfigurationContext configurationContext = MessageContext.getCurrentMessageContext().getConfigurationContext();
                Map faultyServicesMap = (Map)configurationContext.getPropertyNonReplicable("local_carbon.faulty.services.map");
                if (faultyServicesMap != null) {
                    for (String key : faultyServicesMap.keySet()) {
                        axisService = (AxisService)faultyServicesMap.get(key);
                        if (!axisService.getName().equals(serviceName)) continue;
                        axisService.addParameter("rule_service_path", (Object)key);
                        break;
                    }
                }
                if (axisService == null) {
                    throw new RuleServiceAdminException("There is no a service with the given name : " + serviceName);
                }
            }
            String path = (String)axisService.getParameterValue("rule_service_path");
            String fileExtension = path.substring(path.lastIndexOf(".") + 1);
            RuleServiceAdminHandler adminHandler = this.getRuleServiceAdminHandler(fileExtension);
            OMElement omElement = adminHandler.getRuleService(this.getAxisConfig(), serviceName);
            omElement.addAttribute(OM_FACTORY.createOMAttribute("extension", NULL_NS, fileExtension));
            return omElement;
        }
        catch (AxisFault axisFault) {
            throw new RuleServiceAdminException("Error while accessing the service with the name : " + serviceName, axisFault);
        }
    }

    private static void validateElement(OMElement element) throws RuleServiceAdminException {
        if (element == null) {
            throw new RuleServiceAdminException("Rule ServiceDescription OMElement can not be found.");
        }
    }

    private static void validateName(String name) throws RuleServiceAdminException {
        if (name == null || "".equals(name)) {
            throw new RuleServiceAdminException("Name is null or empty");
        }
    }

    private static void validateRuleServiceDescription(RuleService ruleService, OMElement xml) throws RuleServiceAdminException {
        if (ruleService == null) {
            throw new RuleServiceAdminException("RuleService Description can not be created from : " + xml);
        }
    }

    private RuleServiceAdminHandler getRuleServiceAdminHandler(String fileExtension) throws RuleServiceAdminException {
        if ("rsl".equals(fileExtension)) {
            return RULE_FILE_HANDLER;
        }
        if ("aar".equals(fileExtension)) {
            return RULE_ARCHIVE_HANDLER;
        }
        throw new RuleServiceAdminException("Invalid file extension : " + fileExtension);
    }

    public String[] getFactArchiveList(String serviceName) throws RuleServiceAdminException {
        AxisConfiguration axisConfig = this.getAxisConfig();
        RuleServiceAdminHandler adminHandler = this.getRuleServiceAdminHandler("aar");
        return adminHandler.getFactArchiveList(axisConfig, serviceName);
    }

    public void deleteFactArchive(String serviceName, String fileName) throws RuleServiceAdminException {
        AxisConfiguration axisConfig = this.getAxisConfig();
        RuleServiceAdminHandler adminHandler = this.getRuleServiceAdminHandler("aar");
        adminHandler.deleteFactArchive(axisConfig, serviceName, fileName);
    }

    public String[] getRuleFileList(String serviceName, String fileName) throws RuleServiceAdminException {
        AxisConfiguration axisConfig = this.getAxisConfig();
        RuleServiceAdminHandler adminHandler = this.getRuleServiceAdminHandler("aar");
        return adminHandler.getRuleFileList(axisConfig, serviceName, fileName);
    }

    public void deleteRuleFile(String serviceName, String fileName) throws RuleServiceAdminException {
        AxisConfiguration axisConfig = this.getAxisConfig();
        RuleServiceAdminHandler adminHandler = this.getRuleServiceAdminHandler("aar");
        adminHandler.deleteRuleFile(axisConfig, serviceName, fileName);
    }
}

