/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.ws.admin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.rule.ws.admin.Paths;
import org.wso2.carbon.rule.ws.admin.RuleServiceAdminHandler;
import org.wso2.carbon.rule.ws.admin.exception.RuleServiceAdminException;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileManipulator;

public abstract class AbstractRuleServiceAdminHandler
implements RuleServiceAdminHandler {
    protected Log log = LogFactory.getLog(this.getClass());
    protected static final OMFactory OM_FACTORY = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace NULL_NS = OM_FACTORY.createOMNamespace("", "");

    protected AbstractRuleServiceAdminHandler() {
    }

    protected String getTempDir() {
        String workDir = (String)MessageContext.getCurrentMessageContext().getProperty("WORK_DIR");
        String tempDir = workDir + File.separator + "ruleservices_temp";
        File file = new File(tempDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        return tempDir;
    }

    protected String createServiceRepository(AxisConfiguration axisConfig) throws RuleServiceAdminException {
        String repository = axisConfig.getRepository().getPath();
        if (CarbonUtils.isURL((String)repository)) {
            throw new RuleServiceAdminException("Uploading services to URL repo is not supported ");
        }
        String servicesDir = repository + File.separator + "ruleservices";
        File serviceDir = new File(servicesDir);
        if (!serviceDir.exists()) {
            serviceDir.mkdirs();
        }
        return servicesDir;
    }

    protected String getServicePath(AxisConfiguration axisConfig, String serviceName) throws RuleServiceAdminException {
        String value;
        Parameter servicePathParameter;
        AxisService axisService;
        try {
            axisService = axisConfig.getService(serviceName);
        }
        catch (AxisFault axisFault) {
            throw new RuleServiceAdminException("Error accessing rule service with name " + serviceName);
        }
        String servicePath = null;
        if (axisService != null && (servicePathParameter = axisService.getParameter("rule_service_path")) != null && (value = (String)servicePathParameter.getValue()) != null && !"".equals(value.trim())) {
            servicePath = value.trim();
        }
        return servicePath;
    }

    protected OMElement createXML(String serviceName, File ruleFile) throws RuleServiceAdminException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(ruleFile);
            StAXOMBuilder stAXOMBuilder = new StAXOMBuilder((InputStream)inputStream);
            OMElement omElement = stAXOMBuilder.getDocumentElement();
            if (omElement == null) {
                throw new RuleServiceAdminException("Cannot create an XML representation for the file in the service : " + serviceName + ". File was :" + ruleFile);
            }
            omElement.detach();
            OMElement oMElement = omElement;
            return oMElement;
        }
        catch (FileNotFoundException e) {
            throw new RuleServiceAdminException("Cannot find the file : " + ruleFile + " ," + " belongs to rule service with name : " + serviceName);
        }
        catch (XMLStreamException e) {
            throw new RuleServiceAdminException("Can not parse the file content");
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    protected void cleanUp(Paths paths) {
        FileManipulator.deleteDir((File)new File(paths.getWorkingDirPath()));
    }
}

