/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.ws.ui.ns;

import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.rule.ws.ui.ns.NameSpacesInformation;
import org.wso2.carbon.rule.ws.ui.ns.NameSpacesInformationRepository;

public class NameSpacesRegistrar {
    private static final Log log = LogFactory.getLog(NameSpacesRegistrar.class);
    private static final NameSpacesRegistrar ourInstance = new NameSpacesRegistrar();

    public static NameSpacesRegistrar getInstance() {
        return ourInstance;
    }

    private NameSpacesRegistrar() {
    }

    public void registerNameSpaces(AXIOMXPath xPath, String id, String owner, HttpSession httpSession) {
        if (id == null || "".equals(id)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Provided id is empty or null , to register NameSpace there must be a id ");
            }
            return;
        }
        if (xPath == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Provided XPath for id ' " + id + " ' is null "));
            }
            return;
        }
        NameSpacesInformationRepository repository = this.getNameSpacesInformationRepository(httpSession);
        NameSpacesInformation information = this.getNameSpacesInformation(owner, id, repository);
        for (Object prefixObject : xPath.getNamespaces().keySet()) {
            if (prefixObject == null) continue;
            String prefix = (String)prefixObject;
            String uri = xPath.getNamespaceContext().translateNamespacePrefixToUri(prefix);
            this.addNameSpace(prefix, uri, information);
        }
        this.logOnSuccess(information, id);
    }

    public void registerNameSpaces(QName qName, String id, String owner, HttpSession httpSession) {
        if (qName == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Provide QName is null. returning without registering NameSpaces");
            }
            return;
        }
        NameSpacesInformationRepository repository = this.getNameSpacesInformationRepository(httpSession);
        NameSpacesInformation information = this.getNameSpacesInformation(owner, id, repository);
        this.addNameSpace(qName.getPrefix(), qName.getNamespaceURI(), information);
        this.logOnSuccess(information, id);
    }

    public void unRegisterNameSpaces(HttpSession httpSession, String owner) {
        NameSpacesInformationRepository repository = (NameSpacesInformationRepository)httpSession.getAttribute("NameSpacesInformationRepository");
        if (repository != null) {
            repository.removeAllNameSpacesInformation(owner);
        }
    }

    private NameSpacesInformationRepository getNameSpacesInformationRepository(HttpSession httpSession) {
        NameSpacesInformationRepository repository = (NameSpacesInformationRepository)httpSession.getAttribute("NameSpacesInformationRepository");
        if (repository == null) {
            repository = new NameSpacesInformationRepository();
            httpSession.setAttribute("NameSpacesInformationRepository", (Object)repository);
        }
        return repository;
    }

    private NameSpacesInformation getNameSpacesInformation(String ownerID, String id, NameSpacesInformationRepository repository) {
        NameSpacesInformation information = repository.getNameSpacesInformation(ownerID, id);
        if (information != null) {
            information.removeAllNameSpaces();
        }
        if (information == null) {
            information = new NameSpacesInformation();
            repository.addNameSpacesInformation(ownerID, id, information);
        }
        return information;
    }

    private void addNameSpace(String prefix, String uri, NameSpacesInformation information) {
        if (uri == null || "".equals(uri) || prefix == null || "".equals(prefix)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Provided uri or prefix is empty or null , to register NameSpace there must be a valid uri and a prefix ");
            }
            return;
        }
        information.addNameSpace(prefix, uri);
    }

    private boolean assertIDNotEmpty(String id) {
        if (id == null || "".equals(id)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Provided id is empty or null , to register NameSpacethere must be a id ");
            }
            return false;
        }
        return true;
    }

    private void logOnSuccess(NameSpacesInformation information, String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered NameSpaces :" + information + " with id :" + id));
        }
    }
}

