/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.Iterator;
import org.drools.core.util.LeftTupleList;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.RightTuple;

public class LeftTupleIndexHashTable
extends AbstractHashTable
implements LeftTupleMemory {
    private static final long serialVersionUID = 510L;
    public static final int PRIME = 31;
    private int startResult;
    private transient FieldIndexHashTableFullIterator tupleValueFullIterator;
    private int factSize;
    private AbstractHashTable.Index index;

    public LeftTupleIndexHashTable() {
    }

    public LeftTupleIndexHashTable(AbstractHashTable.FieldIndex[] index) {
        this(128, 0.75f, index);
    }

    public LeftTupleIndexHashTable(int capacity, float loadFactor, AbstractHashTable.FieldIndex[] index) {
        super(capacity, loadFactor);
        this.startResult = 31;
        int length = index.length;
        for (int i = 0; i < length; ++i) {
            this.startResult += 31 * this.startResult + index[i].getExtractor().getIndex();
        }
        switch (index.length) {
            case 0: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  0");
            }
            case 1: {
                this.index = new AbstractHashTable.SingleIndex(index, this.startResult);
                break;
            }
            case 2: {
                this.index = new AbstractHashTable.DoubleCompositeIndex(index, this.startResult);
                break;
            }
            case 3: {
                this.index = new AbstractHashTable.TripleCompositeIndex(index, this.startResult);
                break;
            }
            default: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  great than 3");
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.startResult = in.readInt();
        this.factSize = in.readInt();
        this.index = (AbstractHashTable.Index)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.startResult);
        out.writeInt(this.factSize);
        out.writeObject(this.index);
    }

    public Iterator iterator() {
        if (this.tupleValueFullIterator == null) {
            this.tupleValueFullIterator = new FieldIndexHashTableFullIterator(this);
        } else {
            this.tupleValueFullIterator.reset();
        }
        return this.tupleValueFullIterator;
    }

    public LeftTuple getFirst(RightTuple rightTuple) {
        LeftTupleList bucket = this.get(rightTuple);
        if (bucket != null) {
            return bucket.getFirst((LeftTuple)null);
        }
        return null;
    }

    public LeftTuple getFirst(LeftTuple leftTuple) {
        LeftTupleList bucket = this.get(leftTuple);
        if (bucket != null) {
            return bucket.getFirst((LeftTuple)null);
        }
        return null;
    }

    public boolean isIndexed() {
        return true;
    }

    public AbstractHashTable.Index getIndex() {
        return this.index;
    }

    public Entry getBucket(Object object) {
        int hashCode = this.index.hashCodeOf(object);
        int index = this.indexOf(hashCode, this.table.length);
        return this.table[index];
    }

    public LeftTuple[] toArray() {
        LeftTuple[] result = new LeftTuple[this.factSize];
        int index = 0;
        for (int i = 0; i < this.table.length; ++i) {
            for (LeftTupleList bucket = (LeftTupleList)this.table[i]; bucket != null; bucket = (LeftTupleList)bucket.getNext()) {
                for (LeftTuple entry = bucket.getFirst((LeftTuple)null); entry != null; entry = (LeftTuple)entry.getNext()) {
                    result[index++] = entry;
                }
            }
        }
        return result;
    }

    public void add(LeftTuple tuple) {
        LeftTupleList entry = this.getOrCreate(tuple);
        tuple.setMemory(entry);
        entry.add(tuple);
        ++this.factSize;
    }

    public void remove(LeftTuple leftTuple) {
        if (leftTuple.getMemory() != null) {
            LeftTupleList memory = leftTuple.getMemory();
            memory.remove(leftTuple);
            --this.factSize;
            if (memory.first == null) {
                LeftTupleList current;
                int index = this.indexOf(memory.hashCode(), this.table.length);
                LeftTupleList previous = null;
                for (current = (LeftTupleList)this.table[index]; current != memory; current = (LeftTupleList)current.getNext()) {
                    previous = current;
                }
                if (previous != null) {
                    previous.next = current.next;
                } else {
                    this.table[index] = current.next;
                }
                --this.size;
            }
            return;
        }
        int hashCode = this.index.hashCodeOf(leftTuple);
        int index = this.indexOf(hashCode, this.table.length);
        LeftTupleList previous = null;
        LeftTupleList current = (LeftTupleList)this.table[index];
        while (current != null) {
            if (current.matches(leftTuple, hashCode)) {
                current.remove(leftTuple);
                --this.factSize;
                if (current.first != null) break;
                if (previous != null) {
                    previous.next = current.next;
                } else {
                    this.table[index] = current.next;
                }
                --this.size;
                break;
            }
            previous = current;
            current = (LeftTupleList)current.next;
        }
        leftTuple.setNext(null);
        leftTuple.setPrevious(null);
    }

    public boolean contains(LeftTuple tuple) {
        int hashCode = this.index.hashCodeOf(tuple);
        int index = this.indexOf(hashCode, this.table.length);
        LeftTupleList current = (LeftTupleList)this.table[index];
        while (current != null) {
            if (current.matches(tuple, hashCode)) {
                return true;
            }
            current = (LeftTupleList)current.next;
        }
        return false;
    }

    public LeftTupleList get(RightTuple rightTuple) {
        LeftTupleList entry;
        Object object = rightTuple.getFactHandle().getObject();
        int hashCode = this.index.hashCodeOf(object);
        int index = this.indexOf(hashCode, this.table.length);
        for (entry = (LeftTupleList)this.table[index]; entry != null; entry = (LeftTupleList)entry.getNext()) {
            if (!entry.matches(object, hashCode)) continue;
            return entry;
        }
        return entry;
    }

    private LeftTupleList getOrCreate(LeftTuple tuple) {
        int hashCode = this.index.hashCodeOf(tuple);
        int index = this.indexOf(hashCode, this.table.length);
        LeftTupleList entry = (LeftTupleList)this.table[index];
        while (entry != null) {
            if (entry.matches(tuple, hashCode)) {
                return entry;
            }
            entry = (LeftTupleList)entry.next;
        }
        if (entry == null) {
            entry = new LeftTupleList(this.index, hashCode);
            entry.next = this.table[index];
            this.table[index] = entry;
            if (this.size++ >= this.threshold) {
                this.resize(2 * this.table.length);
            }
        }
        return entry;
    }

    private LeftTupleList get(LeftTuple tuple) {
        int hashCode = this.index.hashCodeOf(tuple);
        int index = this.indexOf(hashCode, this.table.length);
        LeftTupleList entry = (LeftTupleList)this.table[index];
        while (entry != null) {
            if (entry.matches(tuple, hashCode)) {
                return entry;
            }
            entry = (LeftTupleList)entry.next;
        }
        return entry;
    }

    public int size() {
        return this.factSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Iterator it = this.iterator();
        LeftTuple leftTuple = (LeftTuple)it.next();
        while (leftTuple != null) {
            builder.append(leftTuple + "\n");
            leftTuple = (LeftTuple)it.next();
        }
        return builder.toString();
    }

    public static class FieldIndexHashTableFullIterator
    implements Iterator {
        private AbstractHashTable hashTable;
        private Entry[] table;
        private int row;
        private int length;
        private LeftTupleList list;
        private LeftTuple leftTuple;

        public FieldIndexHashTableFullIterator(AbstractHashTable hashTable) {
            this.hashTable = hashTable;
            this.reset();
        }

        public Object next() {
            while (this.row < this.length) {
                while (this.list == null) {
                    this.list = (LeftTupleList)this.table[this.row];
                    ++this.row;
                    if (this.list != null) {
                        this.leftTuple = this.list.getFirst((LeftTuple)null);
                        return this.leftTuple;
                    }
                    if (this.row < this.length) continue;
                    return null;
                }
                this.leftTuple = (LeftTuple)this.leftTuple.getNext();
                if (this.leftTuple != null) {
                    return this.leftTuple;
                }
                this.list = (LeftTupleList)this.list.getNext();
                if (this.list == null) continue;
                this.leftTuple = this.list.getFirst((LeftTuple)null);
                return this.leftTuple;
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException("FieldIndexHashTableFullIterator does not support remove().");
        }

        public void reset() {
            this.table = this.hashTable.getTable();
            this.length = this.table.length;
            this.row = 0;
            this.list = null;
            this.leftTuple = null;
        }
    }
}

