/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.PackageRegistry;
import org.drools.compiler.ParserError;
import org.drools.compiler.RuleFlowLoadError;
import org.drools.compiler.xml.XmlProcessReader;
import org.drools.compiler.xml.processes.RuleFlowMigrator;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.definition.process.NodeContainer;
import org.drools.definition.process.Process;
import org.drools.definition.process.WorkflowProcess;
import org.drools.io.Resource;
import org.drools.io.internal.InternalResource;
import org.drools.lang.descr.ActionDescr;
import org.drools.lang.descr.ProcessDescr;
import org.drools.process.builder.ProcessNodeBuilder;
import org.drools.process.builder.ProcessNodeBuilderRegistry;
import org.drools.process.core.Context;
import org.drools.process.core.ContextContainer;
import org.drools.process.core.context.exception.ActionExceptionHandler;
import org.drools.process.core.context.exception.ExceptionHandler;
import org.drools.process.core.context.exception.ExceptionScope;
import org.drools.process.core.impl.ProcessImpl;
import org.drools.process.core.validation.ProcessValidationError;
import org.drools.process.core.validation.ProcessValidator;
import org.drools.rule.Package;
import org.drools.rule.builder.ProcessBuildContext;
import org.drools.ruleflow.core.validation.RuleFlowProcessValidator;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.impl.ConnectionRef;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.drools.workflow.core.impl.WorkflowProcessImpl;
import org.drools.workflow.core.node.ConstraintTrigger;
import org.drools.workflow.core.node.MilestoneNode;
import org.drools.workflow.core.node.Split;
import org.drools.workflow.core.node.StartNode;
import org.drools.workflow.core.node.StateNode;
import org.drools.workflow.core.node.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessBuilder {
    private PackageBuilder packageBuilder;
    private final List<DroolsError> errors = new ArrayList<DroolsError>();
    private Map<String, ProcessValidator> processValidators = new HashMap<String, ProcessValidator>();

    public ProcessBuilder(PackageBuilder packageBuilder) {
        this.packageBuilder = packageBuilder;
        this.processValidators.put("RuleFlow", RuleFlowProcessValidator.getInstance());
    }

    public List<DroolsError> getErrors() {
        return this.errors;
    }

    public void buildProcess(Process process, Resource resource) {
        if (resource != null && ((InternalResource)resource).hasURL()) {
            ((org.drools.process.core.Process)process).setResource(resource);
        }
        boolean hasErrors = false;
        ProcessValidator validator = this.processValidators.get(process.getType());
        if (validator == null) {
            System.out.println("Could not find validator for process " + process.getType() + ".");
            System.out.println("Continuing without validation of the process " + process.getName() + "[" + process.getId() + "]");
        } else {
            ProcessValidationError[] errors = validator.validateProcess((WorkflowProcess)process);
            if (errors.length != 0) {
                hasErrors = true;
                for (int i = 0; i < errors.length; ++i) {
                    this.errors.add(new ParserError(errors[i].toString(), -1, -1));
                }
            }
        }
        if (!hasErrors) {
            String rules = this.generateRules(process);
            try {
                this.packageBuilder.addPackageFromDrl(new StringReader(rules));
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
            catch (DroolsParserException e) {
                e.printStackTrace(System.err);
            }
            PackageRegistry pkgRegistry = this.packageBuilder.getPackageRegistry(process.getPackageName());
            Package p = pkgRegistry.getPackage();
            if (p != null) {
                ProcessDescr processDescr = new ProcessDescr();
                processDescr.setName(process.getPackageName());
                processDescr.setResource(resource);
                DialectCompiletimeRegistry dialectRegistry = pkgRegistry.getDialectCompiletimeRegistry();
                Dialect dialect = dialectRegistry.getDialect("java");
                dialect.init(processDescr);
                ProcessBuildContext buildContext = new ProcessBuildContext(this.packageBuilder, p, process, processDescr, dialectRegistry, dialect);
                this.buildContexts((ContextContainer)((Object)process), buildContext);
                if (process instanceof WorkflowProcess) {
                    this.buildNodes((WorkflowProcess)process, buildContext);
                }
                p.addProcess(process);
                pkgRegistry.compileAll();
                pkgRegistry.getDialectRuntimeRegistry().onBeforeExecute();
            }
        }
    }

    public void buildContexts(ContextContainer contextContainer, ProcessBuildContext buildContext) {
        List<Context> exceptionScopes = contextContainer.getContexts("ExceptionScope");
        if (exceptionScopes != null) {
            for (Context context : exceptionScopes) {
                ExceptionScope exceptionScope = (ExceptionScope)context;
                for (ExceptionHandler exceptionHandler : exceptionScope.getExceptionHandlers().values()) {
                    if (!(exceptionHandler instanceof ActionExceptionHandler)) continue;
                    DroolsConsequenceAction action = (DroolsConsequenceAction)((ActionExceptionHandler)exceptionHandler).getAction();
                    ActionDescr actionDescr = new ActionDescr();
                    actionDescr.setText(action.getConsequence());
                    Dialect dialect = buildContext.getDialectRegistry().getDialect(action.getDialect());
                    dialect.getActionBuilder().build(buildContext, action, actionDescr, (ProcessImpl)buildContext.getProcess());
                }
            }
        }
    }

    public void buildNodes(WorkflowProcess process, ProcessBuildContext context) {
        ProcessNodeBuilderRegistry nodeBuilderRegistry = this.packageBuilder.getPackageBuilderConfiguration().getProcessNodeBuilderRegistry();
        this.processNodes(process.getNodes(), process, context.getProcessDescr(), context, nodeBuilderRegistry);
        if (!context.getErrors().isEmpty()) {
            this.errors.addAll(context.getErrors());
        }
        context.getDialectRegistry().addProcess(context);
    }

    private void processNodes(Node[] nodes, Process process, ProcessDescr processDescr, ProcessBuildContext context, ProcessNodeBuilderRegistry nodeBuilderRegistry) {
        for (Node node : nodes) {
            ProcessNodeBuilder builder = nodeBuilderRegistry.getNodeBuilder(node);
            if (builder != null) {
                builder.build(process, processDescr, context, node);
            }
            if (node instanceof NodeContainer) {
                this.processNodes(((NodeContainer)((Object)node)).getNodes(), process, processDescr, context, nodeBuilderRegistry);
            }
            if (!(node instanceof ContextContainer)) continue;
            this.buildContexts((ContextContainer)((Object)node), context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessFromFile(Reader reader, Resource resource) throws Exception {
        PackageBuilderConfiguration configuration = this.packageBuilder.getPackageBuilderConfiguration();
        XmlProcessReader xmlReader = new XmlProcessReader(configuration.getSemanticModules());
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader newLoader = this.getClass().getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(newLoader);
            String portRuleFlow = System.getProperty("drools.ruleflow.port", "false");
            Reader portedReader = null;
            portedReader = portRuleFlow.equalsIgnoreCase("true") ? this.portToCurrentVersion(reader) : reader;
            Process process = xmlReader.read(portedReader);
            if (process != null) {
                this.buildProcess(process, resource);
            } else {
                this.errors.add(new RuleFlowLoadError("unable to parse xml", null));
            }
        }
        catch (FactoryConfigurationError e1) {
            this.errors.add(new RuleFlowLoadError("FactoryConfigurationError ", e1.getException()));
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.errors.add(new RuleFlowLoadError("unable to parse xml", e2));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        reader.close();
    }

    private Reader portToCurrentVersion(Reader reader) throws Exception {
        String xml = RuleFlowMigrator.convertReaderToString(reader);
        if (RuleFlowMigrator.needToMigrateRFM(xml)) {
            xml = RuleFlowMigrator.portRFMToCurrentVersion(xml);
        } else if (RuleFlowMigrator.needToMigrateRF(xml)) {
            xml = RuleFlowMigrator.portRFMToCurrentVersion(xml);
        }
        return new StringReader(xml);
    }

    private String generateRules(Process process) {
        StringBuffer builder = new StringBuffer();
        if (process instanceof WorkflowProcessImpl) {
            Map<String, String> globals;
            List<String> functionImports;
            WorkflowProcessImpl ruleFlow = (WorkflowProcessImpl)process;
            builder.append("package " + ruleFlow.getPackageName() + "\n");
            List<String> imports = ruleFlow.getImports();
            if (imports != null) {
                for (String importString : imports) {
                    builder.append("import " + importString + ";\n");
                }
            }
            if ((functionImports = ruleFlow.getFunctionImports()) != null) {
                for (String importString : functionImports) {
                    builder.append("import function " + importString + ";\n");
                }
            }
            if ((globals = ruleFlow.getGlobals()) != null) {
                for (Map.Entry<String, String> entry : globals.entrySet()) {
                    builder.append("global " + entry.getValue() + " " + entry.getKey() + ";\n");
                }
            }
            Node[] nodes = ruleFlow.getNodes();
            this.generateRules(nodes, process, builder);
        }
        return builder.toString();
    }

    private void generateRules(Node[] nodes, Process process, StringBuffer builder) {
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] instanceof Split) {
                Split split = (Split)nodes[i];
                if (split.getType() != 2 && split.getType() != 3) continue;
                for (Connection connection : split.getDefaultOutgoingConnections()) {
                    Constraint constraint = split.getConstraint(connection);
                    if (!"rule".equals(constraint.getType())) continue;
                    builder.append(this.createSplitRule(process, connection, split.getConstraint(connection).getConstraint()));
                }
                continue;
            }
            if (nodes[i] instanceof MilestoneNode) {
                MilestoneNode milestone = (MilestoneNode)nodes[i];
                builder.append(this.createMilestoneRule(process, milestone));
                continue;
            }
            if (nodes[i] instanceof StateNode) {
                StateNode state = (StateNode)nodes[i];
                builder.append(this.createStateRules(process, state));
                continue;
            }
            if (nodes[i] instanceof StartNode) {
                StartNode startNode = (StartNode)nodes[i];
                List<Trigger> triggers = startNode.getTriggers();
                if (triggers == null) continue;
                for (Trigger trigger : triggers) {
                    if (!(trigger instanceof ConstraintTrigger)) continue;
                    builder.append(this.createStartConstraintRule(process, (ConstraintTrigger)trigger));
                }
                continue;
            }
            if (!(nodes[i] instanceof NodeContainer)) continue;
            this.generateRules(((NodeContainer)((Object)nodes[i])).getNodes(), process, builder);
        }
    }

    private String createSplitRule(Process process, Connection connection, String constraint) {
        return "rule \"RuleFlow-Split-" + process.getId() + "-" + ((org.drools.workflow.core.Node)connection.getFrom()).getUniqueId() + "-" + ((org.drools.workflow.core.Node)connection.getTo()).getUniqueId() + "-" + connection.getToType() + "\" \n" + "      ruleflow-group \"DROOLS_SYSTEM\" \n" + "    when \n" + "      " + constraint + "\n" + "    then \n" + "end \n\n";
    }

    private String createMilestoneRule(Process process, MilestoneNode milestone) {
        return "rule \"RuleFlow-Milestone-" + process.getId() + "-" + milestone.getUniqueId() + "\" \n" + "      ruleflow-group \"DROOLS_SYSTEM\" \n" + "    when \n" + "      " + milestone.getConstraint() + "\n" + "    then \n" + "end \n\n";
    }

    private String createStateRule(Process process, StateNode state, ConnectionRef key, Constraint constraint) {
        if (constraint.getConstraint() == null || constraint.getConstraint().trim().length() == 0) {
            return "";
        }
        return "rule \"RuleFlowStateNode-" + process.getId() + "-" + state.getUniqueId() + "-" + key.getNodeId() + "-" + key.getToType() + "\" \n" + "      ruleflow-group \"DROOLS_SYSTEM\" \n" + "    when \n" + "      " + state.getConstraints().get(key).getConstraint() + "\n" + "    then \n" + "end \n\n";
    }

    private String createStateRules(Process process, StateNode state) {
        String result = "";
        for (Map.Entry<ConnectionRef, Constraint> entry : state.getConstraints().entrySet()) {
            result = result + this.createStateRule(process, state, entry.getKey(), entry.getValue());
        }
        return result;
    }

    private String createStartConstraintRule(Process process, ConstraintTrigger trigger) {
        String result = "rule \"RuleFlow-Start-" + process.getId() + "\" \n" + (trigger.getHeader() == null ? "" : "        " + trigger.getHeader() + " \n") + "    when\n" + "        " + trigger.getConstraint() + "\n" + "    then\n";
        Map<String, String> inMappings = trigger.getInMappings();
        if (inMappings != null && !inMappings.isEmpty()) {
            result = result + "        java.util.Map params = new java.util.HashMap();\n";
            for (Map.Entry<String, String> entry : inMappings.entrySet()) {
                result = result + "        params.put(\"" + entry.getKey() + "\", " + entry.getValue() + ");\n";
            }
            result = result + "        kcontext.getKnowledgeRuntime().startProcess(\"" + process.getId() + "\", params);\n" + "end\n\n";
        } else {
            result = result + "        kcontext.getKnowledgeRuntime().startProcess(\"" + process.getId() + "\");\n" + "end\n\n";
        }
        return result;
    }
}

