/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.ws.receiver;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.receivers.AbstractInOutMessageReceiver;
import org.wso2.carbon.rule.common.Input;
import org.wso2.carbon.rule.common.Output;
import org.wso2.carbon.rule.common.exception.RuleRuntimeException;
import org.wso2.carbon.rule.kernel.engine.RuleEngine;
import org.wso2.carbon.rule.kernel.engine.RuleSession;

public class RuleMessageReceiver
extends AbstractInOutMessageReceiver {
    private RuleEngine ruleEngine;
    private Input input;
    private Output output;

    public RuleMessageReceiver(RuleEngine ruleEngine, Input input, Output output) {
        this.ruleEngine = ruleEngine;
        this.input = input;
        this.output = output;
    }

    public void invokeBusinessLogic(MessageContext inMessageContext, MessageContext outMessageContext) throws AxisFault {
        OMElement inputOMElement = inMessageContext.getEnvelope().getBody().getFirstElement();
        SOAPFactory soapFactory = this.getSOAPFactory(inMessageContext);
        SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
        try {
            RuleSession ruleSession = this.getRuleSession(inMessageContext);
            soapEnvelope.getBody().addChild((OMNode)ruleSession.execute(inputOMElement, this.input, this.output));
            outMessageContext.setEnvelope(soapEnvelope);
        }
        catch (RuleRuntimeException e) {
            log.error((Object)"Can not create the rule session", (Throwable)e);
            throw new AxisFault("Can not create the rule session", (Throwable)e);
        }
    }

    private RuleSession getRuleSession(MessageContext inMessageContext) throws RuleRuntimeException {
        ServiceContext serviceContext = inMessageContext.getServiceContext();
        RuleSession ruleSession = (RuleSession)serviceContext.getProperty("ruleSession");
        if (ruleSession == null) {
            ruleSession = this.ruleEngine.createSession(2);
            serviceContext.setProperty("ruleSession", (Object)ruleSession);
        }
        return ruleSession;
    }
}

