/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.ws.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.ServiceBuilder;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.engine.ServiceLifeCycle;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.rule.common.Input;
import org.wso2.carbon.rule.common.Operation;
import org.wso2.carbon.rule.common.Output;
import org.wso2.carbon.rule.common.RuleService;
import org.wso2.carbon.rule.common.config.HelperUtil;
import org.wso2.carbon.rule.common.config.RuleServiceHelper;
import org.wso2.carbon.rule.common.exception.RuleConfigurationException;
import org.wso2.carbon.rule.kernel.engine.RuleEngine;
import org.wso2.carbon.rule.ws.internal.schema.SchemaBuilder;
import org.wso2.carbon.rule.ws.receiver.RuleMessageReceiver;

public class RuleServiceDeployer
extends AbstractDeployer {
    private static Log log = LogFactory.getLog(RuleServiceDeployer.class);
    private ConfigurationContext configurationContext;
    private Map<String, String> fileNameToServiceNameMap;

    public void init(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
        this.fileNameToServiceNameMap = new HashMap<String, String>();
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        AxisConfiguration axisConfiguration = this.configurationContext.getAxisConfiguration();
        File file = deploymentFileData.getFile();
        InputStream rslFileInputStream = null;
        try {
            ClassLoader serviceClassLoader = axisConfiguration.getServiceClassLoader();
            if (deploymentFileData.getName().endsWith("aar")) {
                deploymentFileData.setClassLoader(file.isDirectory(), axisConfiguration.getServiceClassLoader(), (File)axisConfiguration.getParameterValue("artifactsDIR"), true);
                serviceClassLoader = deploymentFileData.getClassLoader();
                rslFileInputStream = serviceClassLoader.getResourceAsStream("META-INF/service.rsl");
                if (rslFileInputStream == null) {
                    throw new DeploymentException(" service.rsl file can not be found in the META-INF folder of " + file.getAbsoluteFile());
                }
            } else if (deploymentFileData.getName().endsWith("rsl")) {
                rslFileInputStream = new FileInputStream(file);
            } else {
                throw new DeploymentException("File with unknown extension type " + deploymentFileData.getFile().getName());
            }
            AxisService axisService = this.createService(rslFileInputStream, serviceClassLoader, deploymentFileData);
            AxisServiceGroup axisServiceGroup = new AxisServiceGroup(axisConfiguration);
            axisServiceGroup.setServiceGroupName(axisService.getName());
            axisServiceGroup.setServiceGroupClassLoader(serviceClassLoader);
            axisServiceGroup.addParameter("forceExistingServiceInit", (Object)true);
            axisService.addParameter(new Parameter("serviceType", (Object)"rule_service"));
            axisService.addParameter(new Parameter("rule_service_path", (Object)deploymentFileData.getFile().getAbsolutePath()));
            axisService.setParent(axisServiceGroup);
            Iterator iter = axisService.getOperations();
            while (iter.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)iter.next();
                axisConfiguration.getPhasesInfo().setOperationPhases(axisOperation);
            }
            ArrayList<AxisService> axisServices = new ArrayList<AxisService>();
            axisServices.add(axisService);
            DeploymentEngine.addServiceGroup((AxisServiceGroup)axisServiceGroup, axisServices, (URL)deploymentFileData.getFile().toURI().toURL(), (DeploymentFileData)deploymentFileData, (AxisConfiguration)axisConfiguration);
            this.fileNameToServiceNameMap.put(file.getAbsolutePath(), axisServiceGroup.getServiceGroupName());
        }
        catch (FileNotFoundException e) {
            throw new DeploymentException("Can not read the file ", (Throwable)e);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Can not create the rule engine ", (Throwable)axisFault);
            throw new DeploymentException("Can not add the axis2 service to configuration", (Throwable)axisFault);
        }
        catch (RuleConfigurationException e) {
            log.error((Object)"Can not create the rule engine ", (Throwable)e);
            throw new DeploymentException("Can not create the rule engine ", (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new DeploymentException("Invalid deployment file data location", (Throwable)e);
        }
        finally {
            if (rslFileInputStream != null) {
                try {
                    rslFileInputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Can not close the rule service file input stream ");
                }
            }
        }
    }

    private AxisService createService(InputStream rslFileInputStream, ClassLoader serviceClassLoader, DeploymentFileData deploymentFileData) throws RuleConfigurationException, AxisFault {
        OMElement ruleServiceElement = this.getRuleServiceConfiguration(rslFileInputStream);
        RuleService ruleService = RuleServiceHelper.getRuleService((OMElement)ruleServiceElement);
        this.processDefaultValues(ruleService, serviceClassLoader);
        AxisService axisService = new AxisService(ruleService.getName());
        axisService.setTargetNamespace(ruleService.getTargetNamespace());
        axisService.setClassLoader(serviceClassLoader);
        axisService.setScope(ruleService.getScope());
        if (deploymentFileData.getName().endsWith("aar")) {
            this.populateServiceXMLData(deploymentFileData.getFile().getAbsolutePath(), axisService);
        }
        SchemaBuilder schemaBuilder = new SchemaBuilder(axisService.getClassLoader(), axisService);
        for (Operation operation : ruleService.getOperations()) {
            Input input = operation.getInput();
            Output output = operation.getOutput();
            output.populateClassTypes();
            schemaBuilder.addOperation(operation);
            AxisOperation axisOperation = axisService.getOperation(new QName(ruleService.getTargetNamespace(), operation.getName()));
            if (axisOperation == null) {
                axisOperation = new InOutAxisOperation(new QName(ruleService.getTargetNamespace(), operation.getName()));
                axisService.addOperation(axisOperation);
            }
            RuleEngine ruleEngine = new RuleEngine(ruleService.getRuleSet(), serviceClassLoader);
            RuleMessageReceiver ruleMessageReceiver = new RuleMessageReceiver(ruleEngine, input, output);
            axisOperation.setMessageReceiver((MessageReceiver)ruleMessageReceiver);
            AxisMessage intAxisMessage = axisOperation.getMessage("In");
            intAxisMessage.setName(operation.getName() + "RequestMessage");
            intAxisMessage.setElementQName(input.getQName());
            AxisMessage outAxisMessage = axisOperation.getMessage("Out");
            outAxisMessage.setName(operation.getName() + "ResponseMessage");
            outAxisMessage.setElementQName(output.getQName());
        }
        axisService.addSchema(schemaBuilder.getSchemaList());
        return axisService;
    }

    private void processDefaultValues(RuleService ruleService, ClassLoader classLoader) throws RuleConfigurationException {
        if (ruleService.getTargetNamespace() == null) {
            ruleService.setTargetNamespace("http://wso2.org/carbon/rules");
        }
        for (Operation operation : ruleService.getOperations()) {
            Output output;
            HelperUtil.processFactDefaultValues((List)operation.getInput().getFacts(), (ClassLoader)classLoader);
            HelperUtil.processFactDefaultValues((List)operation.getOutput().getFacts(), (ClassLoader)classLoader);
            Input input = operation.getInput();
            if (input.getWrapperElementName() == null || input.getWrapperElementName().trim().equals("")) {
                input.setWrapperElementName(operation.getName());
            }
            if (input.getNameSpace() == null || input.getNameSpace().trim().equals("")) {
                input.setNameSpace(ruleService.getTargetNamespace());
            }
            if ((output = operation.getOutput()).getWrapperElementName() == null || output.getWrapperElementName().trim().equals("")) {
                output.setWrapperElementName(operation.getName() + "Response");
            }
            if (output.getNameSpace() != null && !output.getNameSpace().trim().equals("")) continue;
            output.setNameSpace(ruleService.getTargetNamespace());
        }
    }

    public void setDirectory(String s) {
    }

    public void setExtension(String s) {
    }

    private OMElement getRuleServiceConfiguration(InputStream inputStream) throws AxisFault {
        try {
            StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(inputStream);
            return stAXOMBuilder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            throw new AxisFault("can not read the input stream");
        }
    }

    public void undeploy(String s) throws DeploymentException {
        File file = new File(s);
        AxisConfiguration axisConfiguration = this.configurationContext.getAxisConfiguration();
        try {
            AxisServiceGroup serviceGroup = axisConfiguration.removeServiceGroup(this.fileNameToServiceNameMap.get(file.getAbsolutePath()));
            if (serviceGroup != null) {
                Iterator services = serviceGroup.getServices();
                while (services.hasNext()) {
                    AxisService axisService = (AxisService)services.next();
                    ServiceLifeCycle serviceLifeCycle = axisService.getServiceLifeCycle();
                    if (serviceLifeCycle == null) continue;
                    serviceLifeCycle.shutDown(this.configurationContext, axisService);
                }
                this.configurationContext.removeServiceGroupContext(serviceGroup);
            } else {
                axisConfiguration.removeFaultyService(this.fileNameToServiceNameMap.get(file.getAbsolutePath()));
            }
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException("Can not undeploy the file " + s);
        }
        super.undeploy(s);
    }

    private void populateServiceXMLData(String zipFileName, AxisService axisService) throws RuleConfigurationException {
        ZipInputStream zin = null;
        FileInputStream fin = null;
        try {
            ZipEntry entry;
            fin = new FileInputStream(zipFileName);
            zin = new ZipInputStream(fin);
            while ((entry = zin.getNextEntry()) != null) {
                if (!entry.getName().equalsIgnoreCase("META-INF/services.xml")) continue;
                OMElement omElement = (OMElement)XMLUtils.toOM((InputStream)zin, (boolean)true);
                ServiceBuilder serviceBuilder = new ServiceBuilder(this.configurationContext, axisService);
                serviceBuilder.populateService(omElement);
                break;
            }
        }
        catch (FileNotFoundException e) {
            throw new RuleConfigurationException("Cannot find the file : " + zipFileName, (Throwable)e);
        }
        catch (IOException e) {
            throw new RuleConfigurationException("IO error reading the file : " + zipFileName, (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new RuleConfigurationException("Can not read the xml stream ", (Throwable)e);
        }
        finally {
            if (zin != null) {
                try {
                    zin.close();
                }
                catch (IOException ignored) {}
            }
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException ignored) {}
            }
        }
    }
}

