/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.kernel.internal.ds;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.rule.common.exception.RuleConfigurationException;
import org.wso2.carbon.rule.kernel.config.RuleEngineConfigService;
import org.wso2.carbon.rule.kernel.internal.build.RuleEngineConfigBuilder;
import org.wso2.carbon.rule.kernel.internal.config.CarbonRuleEngineConfigService;
import org.wso2.carbon.rule.kernel.internal.ds.RuleValueHolder;

public class RuleEngineConfigDS {
    private static Log log = LogFactory.getLog(RuleEngineConfigDS.class);

    protected void activate(ComponentContext context) {
        RuleEngineConfigBuilder ruleEngineConfigBuilder = new RuleEngineConfigBuilder();
        try {
            RuleEngineConfigService ruleEngineConfigService = RuleValueHolder.getInstance().getRuleEngineConfigService();
            if (ruleEngineConfigService == null) {
                ruleEngineConfigService = new CarbonRuleEngineConfigService(ruleEngineConfigBuilder.getRuleConfig());
                RuleValueHolder.getInstance().registerRuleEngineConfigService(ruleEngineConfigService);
            }
            context.getBundleContext().registerService(RuleEngineConfigService.class.getName(), (Object)ruleEngineConfigService, null);
            log.info((Object)"Successfully registered the Rule Config service");
        }
        catch (RuleConfigurationException e) {
            log.error((Object)"Can not create the Rule Config service ", (Throwable)e);
        }
    }

    protected void setEventBroker(EventBroker eventBroker) {
        try {
            RuleValueHolder.getInstance().registerEventBroker(eventBroker);
        }
        catch (RuleConfigurationException e) {
            log.error((Object)"Can not configure event broker ", (Throwable)e);
        }
    }

    protected void unSetEventBroker(EventBroker eventBroker) {
    }
}

