/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.ws.admin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.wso2.carbon.rule.common.RuleService;
import org.wso2.carbon.rule.common.util.Constants;
import org.wso2.carbon.rule.ws.admin.AbstractRuleServiceAdminHandler;
import org.wso2.carbon.rule.ws.admin.Paths;
import org.wso2.carbon.rule.ws.admin.exception.RuleServiceAdminException;
import org.wso2.carbon.utils.ArchiveManipulator;
import org.wso2.carbon.utils.FileManipulator;

public class RuleServiceArchiveAdminHandler
extends AbstractRuleServiceAdminHandler {
    @Override
    public void saveRuleService(AxisConfiguration axisConfiguration, AxisService axisService, RuleService ruleService) throws RuleServiceAdminException {
        File ruleFile;
        File absoluteFile;
        File file;
        File serviceXMLFile;
        Paths paths = this.createTempRuleServiceFile(axisConfiguration, ruleService.getName());
        File metaINF = new File(paths.getWorkingDirPath() + File.separator + "META-INF");
        if (!metaINF.exists()) {
            metaINF.mkdirs();
        }
        if ((serviceXMLFile = (file = new File(paths.getWorkingDirPath() + File.separator + "META-INF" + File.separator + "services.xml")).getAbsoluteFile()).exists()) {
            serviceXMLFile.delete();
        }
        if ((absoluteFile = (ruleFile = new File(paths.getWorkingDirPath() + File.separator + "META-INF" + File.separator + "service.rsl")).getAbsoluteFile()).exists()) {
            absoluteFile.delete();
        }
        try {
            absoluteFile.createNewFile();
        }
        catch (IOException e) {
            throw new RuleServiceAdminException("Error creating a rule service file : " + absoluteFile);
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(ruleFile);
            ruleService.toOM().serialize((OutputStream)os);
            os.flush();
        }
        catch (Exception e) {
            throw new RuleServiceAdminException("Cannot write to the rule service file : " + ruleFile, e);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    this.log.error((Object)"Can not close the out put stream");
                }
            }
        }
        ArchiveManipulator archiveManipulator = new ArchiveManipulator();
        try {
            String servicePath = paths.getServicePath();
            if (!servicePath.endsWith("aar")) {
                File serviceFile = new File(servicePath);
                File absoluteServiceFile = serviceFile.getAbsoluteFile();
                if (absoluteServiceFile.exists()) {
                    absoluteServiceFile.delete();
                }
                servicePath = servicePath.substring(0, servicePath.lastIndexOf(".") + 1) + "aar";
            }
            archiveManipulator.archiveDir(servicePath, paths.getWorkingDirPath());
        }
        catch (IOException e) {
            throw new RuleServiceAdminException("Error creating a archive a rule service ", e);
        }
        this.cleanUp(paths);
    }

    @Override
    public OMElement getRuleService(AxisConfiguration axisConfiguration, String name) throws RuleServiceAdminException {
        Paths paths = this.createTempRuleServiceFile(axisConfiguration, name);
        File ruleFile = new File(paths.getWorkingDirPath() + File.separator + "META-INF" + File.separator + "service.rsl");
        OMElement result = this.createXML(name, ruleFile);
        File servicesXML = new File(paths.getWorkingDirPath() + File.separator + "META-INF" + File.separator + "services.xml");
        if (servicesXML.exists()) {
            result.addAttribute(OM_FACTORY.createOMAttribute(Constants.ATT_GENERATE_SERVICES_XML.getLocalPart(), NULL_NS, String.valueOf(true)));
        }
        return result;
    }

    @Override
    public String[] uploadFacts(AxisConfiguration axisConfiguration, String serviceName, String fileName, DataHandler dataHandler) throws RuleServiceAdminException {
        File factFile;
        File absoluteFile;
        Paths paths = this.createTempRuleServiceFile(axisConfiguration, serviceName);
        File lib = new File(paths.getWorkingDirPath() + File.separator + "lib");
        if (!lib.exists()) {
            lib.mkdirs();
        }
        if ((absoluteFile = (factFile = new File(lib, fileName)).getAbsoluteFile()).exists()) {
            absoluteFile.delete();
        }
        try {
            absoluteFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(factFile);
            dataHandler.writeTo((OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuleServiceAdminException("Cannot write facts", e);
        }
        ArchiveManipulator archiveManipulator = new ArchiveManipulator();
        try {
            String[] strings = archiveManipulator.check(factFile.getAbsolutePath());
            List<String> list = this.filterClasses(strings);
            return list.toArray(new String[list.size()]);
        }
        catch (IOException e) {
            throw new RuleServiceAdminException("Cannot extractPayload classes from the fact file", e);
        }
    }

    @Override
    public void uploadRuleFile(AxisConfiguration axisConfiguration, String serviceName, String fileName, DataHandler dataHandler) throws RuleServiceAdminException {
        File factFile;
        File absoluteFile;
        Paths paths = this.createTempRuleServiceFile(axisConfiguration, serviceName);
        File conf = new File(paths.getWorkingDirPath() + File.separator + "conf");
        if (!conf.exists()) {
            conf.mkdirs();
        }
        if ((absoluteFile = (factFile = new File(conf, fileName)).getAbsoluteFile()).exists()) {
            absoluteFile.delete();
        }
        try {
            absoluteFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(factFile);
            dataHandler.writeTo((OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            throw new RuleServiceAdminException("Cannot write Rule File", e);
        }
    }

    @Override
    public String[] getAllFacts(AxisConfiguration axisConfiguration, String serviceName) throws RuleServiceAdminException {
        ArrayList<String> facts = new ArrayList<String>();
        Paths paths = this.createTempRuleServiceFile(axisConfiguration, serviceName);
        File lib = new File(paths.getWorkingDirPath() + File.separator + "lib");
        if (lib.exists()) {
            File[] jars;
            for (File file : jars = FileManipulator.getMatchingFiles((String)lib.getAbsolutePath(), null, (String)".jar")) {
                try {
                    String[] strings = new ArchiveManipulator().check(file.getAbsolutePath());
                    facts.addAll(this.filterClasses(strings));
                }
                catch (IOException e) {
                    throw new RuleServiceAdminException("Cannot extractPayload classes from the fact file", e);
                }
            }
        }
        return facts.toArray(new String[facts.size()]);
    }

    @Override
    public String[] getFactArchiveList(AxisConfiguration axisConfiguration, String serviceName) throws RuleServiceAdminException {
        ArrayList<String> factArchives = new ArrayList<String>();
        Paths paths = this.createTempRuleServiceFile(axisConfiguration, serviceName);
        File lib = new File(paths.getWorkingDirPath() + File.separator + "lib");
        if (lib.exists()) {
            File[] jars;
            for (File file : jars = FileManipulator.getMatchingFiles((String)lib.getAbsolutePath(), null, (String)".jar")) {
                factArchives.add(file.getName());
            }
        }
        return factArchives.toArray(new String[factArchives.size()]);
    }

    @Override
    public void deleteFactArchive(AxisConfiguration axisConfiguration, String serviceName, String fileName) throws RuleServiceAdminException {
        Paths paths = this.createTempRuleServiceFile(axisConfiguration, serviceName);
        File lib = new File(paths.getWorkingDirPath() + File.separator + "lib");
        File factFile = new File(lib, fileName);
        File absoluteFile = factFile.getAbsoluteFile();
        if (absoluteFile.exists()) {
            absoluteFile.delete();
        }
    }

    @Override
    public String[] getRuleFileList(AxisConfiguration axisConfiguration, String serviceName, String fileName) throws RuleServiceAdminException {
        ArrayList<String> ruleFiles = new ArrayList<String>();
        Paths paths = this.createTempRuleServiceFile(axisConfiguration, serviceName);
        File conf = new File(paths.getWorkingDirPath() + File.separator + "conf");
        if (conf.exists()) {
            File[] drls;
            for (File file : drls = FileManipulator.getMatchingFiles((String)conf.getAbsolutePath(), null, (String)".drl")) {
                ruleFiles.add(file.getName());
            }
        }
        return ruleFiles.toArray(new String[ruleFiles.size()]);
    }

    @Override
    public void deleteRuleFile(AxisConfiguration axisConfiguration, String serviceName, String fileName) throws RuleServiceAdminException {
        Paths paths = this.createTempRuleServiceFile(axisConfiguration, serviceName);
        File conf = new File(paths.getWorkingDirPath() + File.separator + "conf");
        File factFile = new File(conf, fileName);
        File absoluteFile = factFile.getAbsoluteFile();
        absoluteFile.delete();
    }

    private Paths createTempRuleServiceFile(AxisConfiguration axisConfig, String serviceName) throws RuleServiceAdminException {
        String servicesDir = this.createServiceRepository(axisConfig);
        String servicePath = this.getServicePath(axisConfig, serviceName);
        if (servicePath == null || "".equals(servicePath)) {
            servicePath = servicesDir + File.separator + serviceName + "." + "aar";
        }
        File sourceFile = new File(servicePath);
        String targetDirectory = this.getTempDir() + File.separator + serviceName + "." + "aar";
        if (sourceFile.exists() && servicePath.endsWith("aar")) {
            ArchiveManipulator manipulator = new ArchiveManipulator();
            try {
                manipulator.extractFromStream((InputStream)new FileInputStream(sourceFile), targetDirectory);
            }
            catch (IOException e) {
                throw new RuleServiceAdminException("Error extracting files from a source:  " + sourceFile + " into destination : " + targetDirectory);
            }
        } else {
            new File(targetDirectory).mkdirs();
        }
        return new Paths(servicePath, targetDirectory);
    }

    private List<String> filterClasses(String[] strings) throws RuleServiceAdminException {
        if (strings == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> classes = new ArrayList<String>();
        for (String s : strings) {
            if (s == null || !s.endsWith(".class")) continue;
            classes.add(this.getClassNameFromResourceName(s));
        }
        return classes;
    }

    private String getClassNameFromResourceName(String resourceName) throws RuleServiceAdminException {
        if (!resourceName.endsWith(".class")) {
            throw new RuleServiceAdminException("The resource name doesn't refer to a class file");
        }
        return resourceName.substring(0, resourceName.length() - 6).replace('/', '.');
    }
}

