/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.kernel.internal.build;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.rule.common.config.HelperUtil;
import org.wso2.carbon.rule.common.exception.RuleConfigurationException;
import org.wso2.carbon.rule.kernel.config.RuleEngineConfig;
import org.wso2.carbon.rule.kernel.config.RuleEngineProvider;

public class RuleEngineConfigBuilder {
    private static Log log = LogFactory.getLog(RuleEngineConfigBuilder.class);

    public RuleEngineConfig getRuleConfig() throws RuleConfigurationException {
        OMElement ruleConfigOMElement = this.getOMElement();
        return this.getRuleConfig(ruleConfigOMElement);
    }

    private OMElement getOMElement() throws RuleConfigurationException {
        String carbonHome = System.getProperty("carbon.config.dir.path");
        String path = carbonHome + File.separator + "rule-engine-config.xml";
        File ruleConfigFile = new File(path);
        if (!ruleConfigFile.exists()) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(path));
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement omElement = builder.getDocumentElement();
            omElement.build();
            OMElement oMElement = omElement;
            return oMElement;
        }
        catch (FileNotFoundException e) {
            String errorMessage = "rule-engine-config.xmlcannot be found in the path : " + path;
            throw new RuleConfigurationException(errorMessage, (Throwable)e);
        }
        catch (XMLStreamException e) {
            String errorMessage = "Invalid XML for rule-engine-config.xml located in the path : " + path;
            throw new RuleConfigurationException(errorMessage, (Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Can not close the input stream ", (Throwable)e);
            }
        }
    }

    private RuleEngineConfig getRuleConfig(OMElement ruleConfigOMElement) throws RuleConfigurationException {
        if (!ruleConfigOMElement.getQName().equals(new QName("http://wso2.org/carbon/rules/conf", "ruleEngineConfig"))) {
            throw new RuleConfigurationException("Invalid Rule Engine provider config file start element " + ruleConfigOMElement.getQName());
        }
        RuleEngineConfig ruleEngineConfig = new RuleEngineConfig();
        OMElement ruleEngineProvierElement = ruleConfigOMElement.getFirstChildWithName(new QName("http://wso2.org/carbon/rules/conf", "ruleEngineProvider"));
        ruleEngineConfig.setRuleEngineProvider(this.getRuleEngineProvider(ruleEngineProvierElement));
        return ruleEngineConfig;
    }

    private RuleEngineProvider getRuleEngineProvider(OMElement ruleEngineProviderElement) {
        RuleEngineProvider ruleEngineProvider = new RuleEngineProvider();
        ruleEngineProvider.setClassName(HelperUtil.getAttributeValue((OMElement)ruleEngineProviderElement, (String)"className"));
        Iterator propertyElementIter = ruleEngineProviderElement.getChildrenWithName(new QName("http://wso2.org/carbon/rules/conf", "property"));
        while (propertyElementIter.hasNext()) {
            OMElement propertElement = (OMElement)propertyElementIter.next();
            String name = HelperUtil.getAttributeValue((OMElement)propertElement, (String)"name");
            String value = HelperUtil.getAttributeValue((OMElement)propertElement, (String)"value");
            ruleEngineProvider.addProperty(name, value);
        }
        return ruleEngineProvider;
    }
}

