/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.kernel.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.rule.common.Fact;
import org.wso2.carbon.rule.common.Input;
import org.wso2.carbon.rule.common.Output;
import org.wso2.carbon.rule.common.exception.RuleRuntimeException;
import org.wso2.carbon.rule.kernel.backend.Session;
import org.wso2.carbon.rule.kernel.internal.util.DataBindUtil;

public class RuleSession {
    private Session session;

    public RuleSession(Session session) {
        this.session = session;
    }

    public OMElement execute(OMElement inputElement, Input input, Output output) throws RuleRuntimeException {
        ArrayList<Object> inputFactObjects = new ArrayList<Object>();
        for (Fact fact : input.getFacts()) {
            inputFactObjects.addAll(this.getFacts(inputElement, fact, input.getNameSpace()));
        }
        List resultObjects = this.session.execute(inputFactObjects);
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement outWrapperElement = omFactory.createOMElement(new QName(output.getNameSpace(), output.getWrapperElementName()));
        for (Object object : resultObjects) {
            if (!output.isFactTypeExists(object.getClass().getName())) continue;
            outWrapperElement.addChild((OMNode)DataBindUtil.toOM(object, output.getFactTypeQName(object.getClass().getName())));
        }
        return outWrapperElement;
    }

    private List<Object> getFacts(OMElement inputElement, Fact fact, String factElementNamespace) throws RuleRuntimeException {
        ArrayList<Object> results = new ArrayList<Object>();
        if (fact.getXpath() != null && !fact.getXpath().equals("")) {
            try {
                AXIOMXPath axiomxPath = new AXIOMXPath(fact.getXpath());
                for (String prefix : fact.getPrefixToNamespaceMap().keySet()) {
                    axiomxPath.addNamespace(prefix, (String)fact.getPrefixToNamespaceMap().get(prefix));
                }
                List selectedNodes = axiomxPath.selectNodes((Object)inputElement);
                for (Object selectedNode : selectedNodes) {
                    if (selectedNode instanceof OMText) {
                        OMText selectedOMTextNode = (OMText)selectedNode;
                        results.add(selectedOMTextNode.getText());
                        continue;
                    }
                    if (!(selectedNode instanceof OMElement)) continue;
                    OMElement selectedNodeOMElement = (OMElement)selectedNode;
                    results.add(DataBindUtil.getValue(selectedNodeOMElement, fact.getTypeClass()));
                }
            }
            catch (JaxenException e) {
                throw new RuleRuntimeException("Can not create xpath from the xpath " + fact.getXpath());
            }
        } else {
            Iterator factsIterator = inputElement.getChildElements();
            while (factsIterator.hasNext()) {
                OMElement factElement = (OMElement)factsIterator.next();
                if (!factElement.getQName().equals(new QName(factElementNamespace, fact.getElementName()))) continue;
                results.add(DataBindUtil.getValue(factElement, fact.getTypeClass()));
            }
        }
        return results;
    }
}

