/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.backend.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.rule.backend.util.ds.RuleServiceValueHolder;
import org.wso2.carbon.rule.common.Rule;
import org.wso2.carbon.rule.common.exception.RuleConfigurationException;

public class RuleSetLoader {
    public static InputStream getRuleSetAsStream(Rule rule, ClassLoader classLoader) throws RuleConfigurationException {
        InputStream ruleInputStream = null;
        if (rule.getSourceType().equals("inline")) {
            ruleInputStream = new ByteArrayInputStream(rule.getValue().getBytes());
        } else {
            if (rule.getSourceType().equals("registry")) {
                String[] vale = rule.getValue().split(":");
                String type = vale[0];
                String key = vale[1];
                try {
                    ruleInputStream = RuleSetLoader.getRegistryAsStream(type, key);
                }
                catch (RegistryException e) {
                    throw new RuleConfigurationException("Can not access the registry : ", (Throwable)e);
                }
            }
            if (rule.getSourceType().equals("file")) {
                ruleInputStream = classLoader.getResourceAsStream("conf" + File.separator + rule.getValue());
            } else if (rule.getSourceType().equals("url")) {
                String url = rule.getValue();
                try {
                    URL ruleURL = new URL(url);
                    ruleInputStream = ruleURL.openStream();
                }
                catch (MalformedURLException e) {
                    throw new RuleConfigurationException("Unknown protocol is specified : ", (Throwable)e);
                }
                catch (IOException e) {
                    throw new RuleConfigurationException("Can not access the URL : ", (Throwable)e);
                }
            }
        }
        return ruleInputStream;
    }

    private static InputStream getRegistryAsStream(String type, String key) throws RegistryException {
        RuleServiceValueHolder ruleServiceValueHolder = RuleServiceValueHolder.getInstance();
        InputStream inputStream = null;
        if (type.equals("conf")) {
            inputStream = ruleServiceValueHolder.getRegistryService().getConfigSystemRegistry().get(key).getContentStream();
        } else if (type.equals("gov")) {
            inputStream = ruleServiceValueHolder.getRegistryService().getGovernanceSystemRegistry().get(key).getContentStream();
        }
        return inputStream;
    }
}

