/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.backend.jsr94;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.rules.ConfigurationException;
import javax.rules.RuleRuntime;
import javax.rules.RuleServiceProvider;
import javax.rules.RuleServiceProviderManager;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import javax.rules.admin.RuleAdministrator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.rule.backend.jsr94.JSR94BackendRuntime;
import org.wso2.carbon.rule.common.exception.RuleConfigurationException;
import org.wso2.carbon.rule.kernel.backend.DefaultPropertiesProvider;
import org.wso2.carbon.rule.kernel.backend.RuleBackendRuntime;
import org.wso2.carbon.rule.kernel.backend.RuleBackendRuntimeFactory;

public class JSR94BackendRuntimeFactory
implements RuleBackendRuntimeFactory {
    public static final String PROVIDER_PRO_CLASS = "class";
    public static final String PROVIDER_PRO_URI = "uri";
    public static final String PROVIDER_PRO_PROPERTY_PROVIDER = "propertyProvider";
    private static Log log = LogFactory.getLog(JSR94BackendRuntimeFactory.class);

    public RuleBackendRuntime getRuleBackendRuntime(Map<String, String> properties, ClassLoader classLoader) throws RuleConfigurationException {
        Class<?> providerClass;
        String providerClassName = properties.get(PROVIDER_PRO_CLASS);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trying to initialize the RuleServiceProvider with class name :" + providerClassName));
            }
            providerClass = Class.forName(providerClassName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("RuleServiceProvider has been initialized. provider class : " + providerClassName));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuleConfigurationException("Error when loading RuleServiceProvider from class with the name " + providerClassName, (Throwable)e);
        }
        String providerUri = properties.get(PROVIDER_PRO_URI);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting RuleServiceProvider using provider Url : " + providerUri));
            }
            RuleServiceProviderManager.registerRuleServiceProvider((String)providerUri, providerClass, (ClassLoader)classLoader);
            RuleServiceProvider ruleServiceProvider = RuleServiceProviderManager.getRuleServiceProvider((String)providerUri);
            if (ruleServiceProvider == null) {
                throw new RuleConfigurationException("There is no RuleServiceProvider registered for Uri :" + providerUri);
            }
            RuleAdministrator ruleAdministrator = this.createRuleAdministrator(ruleServiceProvider);
            LocalRuleExecutionSetProvider localProvider = this.createLocalRuleExecutionSetProvider(ruleAdministrator);
            RuleRuntime ruleRuntime = this.createRuleRuntime(ruleServiceProvider);
            JSR94BackendRuntime jsr94BackendRuntime = new JSR94BackendRuntime(ruleAdministrator, ruleRuntime, localProvider, classLoader);
            String defaultPropertyProviderClassName = properties.get(PROVIDER_PRO_PROPERTY_PROVIDER);
            try {
                if (defaultPropertyProviderClassName != null) {
                    Class<?> defaultPropertyProviderClass = Class.forName(defaultPropertyProviderClassName);
                    Object defaultPropertyProvider = defaultPropertyProviderClass.newInstance();
                    jsr94BackendRuntime.setDefaultPropertiesProvider((DefaultPropertiesProvider)defaultPropertyProvider);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuleConfigurationException("Can not load the class " + defaultPropertyProviderClassName);
            }
            catch (IllegalAccessException e) {
                throw new RuleConfigurationException("Can not accesss the class " + defaultPropertyProviderClassName);
            }
            catch (InstantiationException e) {
                throw new RuleConfigurationException("Can not instantiate the class " + defaultPropertyProviderClassName);
            }
            return jsr94BackendRuntime;
        }
        catch (ConfigurationException e) {
            throw new RuleConfigurationException("Error was occurred when getting RuleServiceProvider which has been registered to the Url " + providerUri, (Throwable)e);
        }
    }

    private RuleAdministrator createRuleAdministrator(RuleServiceProvider ruleServiceProvider) throws RuleConfigurationException {
        try {
            RuleAdministrator ruleAdministrator;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Getting Rule Administrator from Rule Service Provider");
            }
            if ((ruleAdministrator = ruleServiceProvider.getRuleAdministrator()) == null) {
                throw new RuleConfigurationException("The loaded Rule Administrator is null");
            }
            return ruleAdministrator;
        }
        catch (ConfigurationException e) {
            throw new RuleConfigurationException("Error was occurred when creating the Rule Administrator from the RuleServiceProvider", (Throwable)e);
        }
    }

    private RuleRuntime createRuleRuntime(RuleServiceProvider ruleServiceProvider) throws RuleConfigurationException {
        try {
            RuleRuntime ruleRuntime = ruleServiceProvider.getRuleRuntime();
            if (ruleRuntime == null) {
                throw new RuleConfigurationException("The created rule runtime is null");
            }
            return ruleRuntime;
        }
        catch (ConfigurationException e) {
            throw new RuleConfigurationException("Error was occurred when getting RuleRuntime", (Throwable)e);
        }
    }

    private LocalRuleExecutionSetProvider createLocalRuleExecutionSetProvider(RuleAdministrator ruleAdministrator) throws RuleConfigurationException {
        try {
            LocalRuleExecutionSetProvider localRuleExecutionSetProvider;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Getting LocalRuleExecutionSetProvider ");
            }
            if ((localRuleExecutionSetProvider = ruleAdministrator.getLocalRuleExecutionSetProvider(new HashMap())) == null) {
                throw new RuleConfigurationException("The loaded LocalRuleExecutionSetProvider is null");
            }
            return localRuleExecutionSetProvider;
        }
        catch (RemoteException e) {
            throw new RuleConfigurationException("Error was occurred when getting the LocalRuleExecutionSetProvider ", (Throwable)e);
        }
    }
}

