/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.common;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.rule.common.Fact;

public class Input {
    private String wrapperElementName;
    private String nameSpace;
    private List<Fact> facts = new ArrayList<Fact>();

    public OMElement toOM() {
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement ruleInputOMElement = omFactory.createOMElement("input", "http://wso2.org/carbon/rules", "brs");
        if (this.nameSpace != null && !this.nameSpace.trim().equals("")) {
            ruleInputOMElement.addAttribute("namespace", this.nameSpace, null);
        }
        if (this.wrapperElementName != null && !this.wrapperElementName.trim().equals("")) {
            ruleInputOMElement.addAttribute("wrapperElementName", this.wrapperElementName, null);
        }
        for (Fact fact : this.facts) {
            ruleInputOMElement.addChild((OMNode)fact.toOM());
        }
        return ruleInputOMElement;
    }

    public void addFact(Fact fact) {
        this.facts.add(fact);
    }

    public QName getQName() {
        return new QName(this.nameSpace, this.wrapperElementName);
    }

    public String getWrapperElementName() {
        return this.wrapperElementName;
    }

    public void setWrapperElementName(String wrapperElementName) {
        this.wrapperElementName = wrapperElementName;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public List<Fact> getFacts() {
        return this.facts;
    }

    public void setFacts(List<Fact> facts) {
        this.facts = facts;
    }
}

