/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELReturnValueEvaluator;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.compiler.ReturnValueDescr;
import org.drools.process.core.ContextResolver;
import org.drools.process.core.context.variable.VariableScope;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.ReturnValueEvaluatorBuilder;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ProcessContext;
import org.drools.workflow.instance.impl.ReturnValueConstraintEvaluator;

public class MVELReturnValueEvaluatorBuilder
implements ReturnValueEvaluatorBuilder {
    public void build(PackageBuildContext context, ReturnValueConstraintEvaluator constraintNode, ReturnValueDescr descr, ContextResolver contextResolver) {
        String text = descr.getText();
        try {
            MVELDialect dialect = (MVELDialect)context.getDialect("mvel");
            HashMap variables = new HashMap();
            variables.put("context", ProcessContext.class);
            variables.put("kcontext", org.drools.runtime.process.ProcessContext.class);
            variables.put("drools", KnowledgeHelper.class);
            Dialect.AnalysisResult analysis = dialect.analyzeBlock(context, descr, dialect.getInterceptors(), text, new Map[]{variables, context.getPackageBuilder().getGlobals()}, null);
            List<String> variableNames = analysis.getNotBoundedIdentifiers();
            if (contextResolver != null) {
                for (String variableName : variableNames) {
                    VariableScope variableScope = (VariableScope)contextResolver.resolveContext("VariableScope", variableName);
                    if (variableScope == null) {
                        context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Could not find variable '" + variableName + "' for constraint '" + descr.getText() + "'"));
                        continue;
                    }
                    variables.put(variableName, context.getDialect().getTypeResolver().resolveType(variableScope.findVariable(variableName).getType().getStringType()));
                }
            }
            MVELCompilationUnit unit = dialect.getMVELCompilationUnit(text, analysis, null, null, variables, context);
            MVELReturnValueEvaluator expr = new MVELReturnValueEvaluator(unit, dialect.getId());
            expr.setVariableNames(variableNames);
            constraintNode.setEvaluator(expr);
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)context.getPkg().getDialectRuntimeRegistry().getDialectData(dialect.getId());
            data.addCompileable(constraintNode, expr);
            expr.compile(context.getPackageBuilder().getRootClassLoader());
        }
        catch (Exception e) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, null, "Unable to build expression for 'constraint' " + descr.getText() + "': " + e));
        }
    }

    public static String delimitExpressions(String s) {
        StringBuilder result = new StringBuilder();
        char[] cs = s.toCharArray();
        int brace = 0;
        int sqre = 0;
        int crly = 0;
        int lastNonWhite = 59;
        for (int i = 0; i < cs.length; ++i) {
            int c = cs[i];
            switch (c) {
                case 40: {
                    ++brace;
                    break;
                }
                case 123: {
                    ++crly;
                    break;
                }
                case 91: {
                    ++sqre;
                    break;
                }
                case 41: {
                    --brace;
                    break;
                }
                case 125: {
                    --crly;
                    break;
                }
                case 93: {
                    --sqre;
                    break;
                }
            }
            if (brace == 0 && sqre == 0 && crly == 0 && (c == 10 || c == 13)) {
                if (lastNonWhite != 59) {
                    result.append(';');
                    lastNonWhite = 59;
                }
            } else if (!Character.isWhitespace((char)c)) {
                lastNonWhite = c;
            }
            result.append((char)c);
        }
        return result.toString();
    }
}

