/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io.impl;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import org.drools.io.Resource;
import org.drools.io.impl.BaseResource;
import org.drools.io.internal.InternalResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayResource
extends BaseResource
implements InternalResource {
    private byte[] bytes;

    public ByteArrayResource(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null");
        }
        this.bytes = bytes;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream());
    }

    @Override
    public boolean hasURL() {
        return false;
    }

    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException("byte[] cannot be resolved to URL");
    }

    @Override
    public long getLastModified() {
        throw new IllegalStateException("reader does have a modified date");
    }

    @Override
    public long getLastRead() {
        throw new IllegalStateException("reader does have a modified date");
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public Collection<Resource> listResources() {
        throw new RuntimeException("This Resource cannot be listed, or is not a directory");
    }

    public boolean equals(Object object) {
        return object == this || object instanceof ByteArrayResource && Arrays.equals(((ByteArrayResource)object).bytes, this.bytes);
    }

    public int hashCode() {
        return byte[].class.hashCode() * 29 * this.bytes.length;
    }

    public String toString() {
        return "[ByteArrayResource resource=" + this.bytes + "]";
    }
}

