/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import org.drools.CheckedDroolsException;
import org.drools.compiler.BusinessRuleProvider;
import org.drools.util.ServiceRegistryImpl;

public class BusinessRuleProviderFactory {
    private static BusinessRuleProviderFactory instance = new BusinessRuleProviderFactory();
    private BusinessRuleProvider provider;

    private BusinessRuleProviderFactory() {
    }

    public static BusinessRuleProviderFactory getInstance() {
        return instance;
    }

    public BusinessRuleProvider getProvider() throws CheckedDroolsException {
        if (null == this.provider) {
            this.provider = this.loadProvider();
        }
        return this.provider;
    }

    private BusinessRuleProvider loadProvider() throws CheckedDroolsException {
        String interfaceName = BusinessRuleProvider.class.getName();
        try {
            String currentName;
            URL systemResource = null;
            Enumeration<URL> systemResources = ClassLoader.getSystemResources("META-INF/services/" + interfaceName);
            while (systemResources.hasMoreElements()) {
                if (null != systemResource) {
                    this.throwMultipleImplementationsDetected();
                }
                systemResource = systemResources.nextElement();
            }
            if (systemResource == null) {
                this.throwNoImplementationFound();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(systemResource.openStream()));
            String className = null;
            while ((currentName = reader.readLine()) != null) {
                if (className != null) {
                    this.throwMultipleImplementationsDetected();
                }
                className = currentName;
            }
            if (null == className) {
                this.throwNoImplementationFound();
            }
            ServiceRegistryImpl.getInstance().addDefault(BusinessRuleProvider.class, className);
            return ServiceRegistryImpl.getInstance().get(BusinessRuleProvider.class);
        }
        catch (IOException e) {
            throw new CheckedDroolsException("Error obtaining " + interfaceName, e);
        }
    }

    private void throwNoImplementationFound() throws CheckedDroolsException {
        throw new CheckedDroolsException("Unable to find implementation for BusinessRuleProvider");
    }

    private void throwMultipleImplementationsDetected() {
        throw new IllegalStateException("multiple BusinessRuleProvider implementations detected");
    }
}

