/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.kernel.engine;

import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.event.core.subscription.EventDispatcher;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.rule.common.Rule;
import org.wso2.carbon.rule.common.RuleSet;
import org.wso2.carbon.rule.common.exception.RuleConfigurationException;
import org.wso2.carbon.rule.common.exception.RuleRuntimeException;
import org.wso2.carbon.rule.kernel.backend.RuleBackendRuntime;
import org.wso2.carbon.rule.kernel.backend.RuleBackendRuntimeFactory;
import org.wso2.carbon.rule.kernel.backend.Session;
import org.wso2.carbon.rule.kernel.config.RuleEngineProvider;
import org.wso2.carbon.rule.kernel.engine.RuleSession;
import org.wso2.carbon.rule.kernel.internal.build.RuleEngineConfigBuilder;
import org.wso2.carbon.rule.kernel.internal.config.CarbonRuleEngineConfigService;
import org.wso2.carbon.rule.kernel.internal.ds.RuleValueHolder;
import org.wso2.carbon.rule.kernel.internal.event.RuleChangeEventDispacher;

public class RuleEngine {
    private RuleBackendRuntime ruleBackendRuntime;
    private RuleSet ruleSet;
    private ClassLoader factClassLoader;

    public RuleEngine(RuleSet ruleSet, ClassLoader factClassLoader) throws RuleConfigurationException {
        this.ruleSet = ruleSet;
        this.factClassLoader = factClassLoader;
        RuleChangeEventDispacher ruleChangeEventDispacher = new RuleChangeEventDispacher(this);
        for (Rule rule : ruleSet.getRules()) {
            if (!rule.getSourceType().equals("registry")) continue;
            String updateTopicName = this.getUpdateTopicName(rule.getValue());
            Subscription subscription = new Subscription();
            subscription.setEventDispatcher((EventDispatcher)ruleChangeEventDispacher);
            subscription.setTopicName(updateTopicName);
            subscription.setTenantId(CarbonContext.getCurrentContext().getTenantId());
            subscription.setOwner("wso2.system.user");
            RuleValueHolder.getInstance().addSubscription(subscription);
        }
        this.loadRuleBackendRuntime();
    }

    private String getUpdateTopicName(String registryKey) throws RuleConfigurationException {
        String updateTopicName = "/registry/notifications/ResourceUpdated/_system/";
        if (registryKey.startsWith("conf")) {
            updateTopicName = updateTopicName + registryKey.replace("conf:", "config/");
        } else if (registryKey.startsWith("gov")) {
            updateTopicName = updateTopicName + registryKey.replace("gov:", "governance/");
        } else {
            throw new RuleConfigurationException("In valide registry with registry key " + registryKey);
        }
        return updateTopicName;
    }

    public synchronized void loadRuleBackendRuntime() throws RuleConfigurationException {
        RuleEngineProvider ruleEngineProvider = null;
        try {
            ruleEngineProvider = RuleValueHolder.getInstance().getRuleEngineProvider();
            if (ruleEngineProvider == null) {
                RuleEngineConfigBuilder ruleEngineConfigBuilder = new RuleEngineConfigBuilder();
                CarbonRuleEngineConfigService ruleEngineConfigService = new CarbonRuleEngineConfigService(ruleEngineConfigBuilder.getRuleConfig());
                RuleValueHolder.getInstance().registerRuleEngineConfigService(ruleEngineConfigService);
                ruleEngineProvider = RuleValueHolder.getInstance().getRuleEngineProvider();
            }
            Class<?> ruleBackendRuntimeFactoryClass = Class.forName(ruleEngineProvider.getClassName());
            RuleBackendRuntimeFactory ruleBackendRuntimeFactory = (RuleBackendRuntimeFactory)ruleBackendRuntimeFactoryClass.newInstance();
            this.ruleBackendRuntime = ruleBackendRuntimeFactory.getRuleBackendRuntime(ruleEngineProvider.getProperties(), this.factClassLoader);
            this.ruleBackendRuntime.addRuleSet(this.ruleSet);
        }
        catch (ClassNotFoundException e) {
            throw new RuleConfigurationException("Class " + ruleEngineProvider.getClassName() + " can not be found ");
        }
        catch (IllegalAccessException e) {
            throw new RuleConfigurationException("Can not instantiate the " + ruleEngineProvider.getClassName() + " class");
        }
        catch (InstantiationException e) {
            throw new RuleConfigurationException("Can not instantiate the " + ruleEngineProvider.getClassName() + " class");
        }
    }

    public RuleSession createSession(int type) throws RuleRuntimeException {
        Session session = this.ruleBackendRuntime.createSession(type);
        return new RuleSession(session);
    }
}

