/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.backend.jsr94;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import javax.rules.RuleExecutionSetNotFoundException;
import javax.rules.RuleRuntime;
import javax.rules.RuleSessionCreateException;
import javax.rules.RuleSessionTypeUnsupportedException;
import javax.rules.StatefulRuleSession;
import javax.rules.StatelessRuleSession;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import javax.rules.admin.RuleAdministrator;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetCreateException;
import javax.rules.admin.RuleExecutionSetDeregistrationException;
import javax.rules.admin.RuleExecutionSetRegisterException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.rule.backend.jsr94.JSR94StatefulSession;
import org.wso2.carbon.rule.backend.jsr94.JSR94StatelessSession;
import org.wso2.carbon.rule.backend.util.RuleSetLoader;
import org.wso2.carbon.rule.common.Rule;
import org.wso2.carbon.rule.common.RuleSet;
import org.wso2.carbon.rule.common.exception.RuleConfigurationException;
import org.wso2.carbon.rule.common.exception.RuleRuntimeException;
import org.wso2.carbon.rule.kernel.backend.DefaultPropertiesProvider;
import org.wso2.carbon.rule.kernel.backend.RuleBackendRuntime;
import org.wso2.carbon.rule.kernel.backend.Session;

public class JSR94BackendRuntime
implements RuleBackendRuntime {
    private static Log log = LogFactory.getLog(JSR94BackendRuntime.class);
    private RuleAdministrator ruleAdministrator;
    private RuleRuntime ruleRuntime;
    private LocalRuleExecutionSetProvider localRuleExecutionSetProvider;
    private DefaultPropertiesProvider defaultPropertiesProvider;
    private ClassLoader classLoader;
    private String ruleExecutionSetURI;

    public JSR94BackendRuntime(RuleAdministrator ruleAdministrator, RuleRuntime ruleRuntime, LocalRuleExecutionSetProvider localRuleExecutionSetProvider, ClassLoader classLoader) {
        this.ruleAdministrator = ruleAdministrator;
        this.ruleRuntime = ruleRuntime;
        this.localRuleExecutionSetProvider = localRuleExecutionSetProvider;
        this.classLoader = classLoader;
    }

    public void addRuleSet(RuleSet ruleSet) throws RuleConfigurationException {
        HashMap properties = new HashMap();
        properties.putAll(ruleSet.getProperties());
        if (this.defaultPropertiesProvider != null) {
            Map map = this.defaultPropertiesProvider.getRuleExecutionSetCreationDefaultProperties(this.classLoader);
            properties.putAll(map);
        }
        for (Rule rule : ruleSet.getRules()) {
            HashMap<String, Object> ruleProperties = new HashMap<String, Object>();
            ruleProperties.putAll(properties);
            if (rule.getResourceType().equals("regular")) {
                ruleProperties.put("source", "drl");
            } else if (rule.getResourceType().equals("dtable")) {
                ruleProperties.put("source", "javax.rules.admin.RuleExecutionSet.source.decisiontable");
            }
            InputStream ruleInputStream = RuleSetLoader.getRuleSetAsStream(rule, this.classLoader);
            if (ruleInputStream == null) {
                throw new RuleConfigurationException(" The input stream form rule script is null.");
            }
            String bindURI = this.registerRuleExecutionSet(ruleInputStream, ruleProperties, ruleSet.getBindURI(), ruleSet.getProperties());
            if (ruleSet.getBindURI() != null) continue;
            ruleSet.setBindURI(bindURI);
        }
    }

    public Session createSession(int type) throws RuleRuntimeException {
        boolean stateful = type == 2;
        try {
            StatelessRuleSession ruleSession;
            HashMap properties = new HashMap();
            if (stateful) {
                StatefulRuleSession ruleSession2;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Using stateful rule session ");
                }
                if ((ruleSession2 = (StatefulRuleSession)this.ruleRuntime.createRuleSession(this.ruleExecutionSetURI, properties, 0)) == null) {
                    throw new RuleRuntimeException("The created stateful rule session is null");
                }
                return new JSR94StatefulSession(ruleSession2);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using stateless rule session");
            }
            if ((ruleSession = (StatelessRuleSession)this.ruleRuntime.createRuleSession(this.ruleExecutionSetURI, properties, 1)) == null) {
                throw new RuleRuntimeException("The created stateless rule session is null");
            }
            return new JSR94StatelessSession(ruleSession);
        }
        catch (RuleSessionTypeUnsupportedException e) {
            throw new RuleRuntimeException("Error was occurred when creating " + (stateful ? " StateFul" : "StateLess") + " Session", (Throwable)e);
        }
        catch (RuleSessionCreateException e) {
            throw new RuleRuntimeException("Error was occurred when creating " + (stateful ? " StateFul" : "StateLess") + " Session", (Throwable)e);
        }
        catch (RemoteException e) {
            throw new RuleRuntimeException("Error was occurred when creating " + (stateful ? " StateFul" : "StateLess") + " Session", (Throwable)e);
        }
        catch (RuleExecutionSetNotFoundException e) {
            throw new RuleRuntimeException("Error was occurred when creating " + (stateful ? " StateFul" : "StateLess") + " Session", (Throwable)e);
        }
        catch (Exception e) {
            throw new RuleRuntimeException("Unknown Error was when executing rules using " + (stateful ? " StateFul" : "StateLess") + " Session", (Throwable)e);
        }
    }

    public void removeRuleSet(RuleSet ruleSet) throws RuleConfigurationException {
        String bindUri = ruleSet.getBindURI();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing the rule execution set that has been bind to Uri " + bindUri));
            }
            this.ruleAdministrator.deregisterRuleExecutionSet(bindUri, ruleSet.getDeregistrationProperties());
        }
        catch (RuleExecutionSetDeregistrationException e) {
            throw new RuleConfigurationException("Error was occurred when tying to unregistered the RuleExecutionSet which has Uri " + bindUri, (Throwable)e);
        }
        catch (RemoteException e) {
            throw new RuleConfigurationException("Error was occurred when trying to unregistered the RuleExecutionSet which has Uri " + bindUri, (Throwable)e);
        }
    }

    public void destroy() {
    }

    private String registerRuleExecutionSet(InputStream in, Map<String, Object> properties, String bindUri, Map<String, String> registrationProperties) throws RuleConfigurationException {
        try {
            RuleExecutionSet ruleExecutionSet = this.localRuleExecutionSetProvider.createRuleExecutionSet(in, properties);
            if (ruleExecutionSet == null) {
                throw new RuleConfigurationException("The newly created rule execution set is null ");
            }
            bindUri = ruleExecutionSet.getName();
            this.ruleAdministrator.registerRuleExecutionSet(bindUri, ruleExecutionSet, registrationProperties);
            this.ruleExecutionSetURI = ruleExecutionSet.getName();
            return bindUri;
        }
        catch (RuleExecutionSetCreateException e) {
            throw new RuleConfigurationException("Error was occurred when creating the RuleExecutionSet", (Throwable)e);
        }
        catch (IOException e) {
            throw new RuleConfigurationException("Error was occurred when getting an input stream from provided rule script", (Throwable)e);
        }
        catch (RuleExecutionSetRegisterException e) {
            throw new RuleConfigurationException("Error was occurred when trying to registering the RuleExecutionSet with Uri " + bindUri, (Throwable)e);
        }
        catch (Exception e) {
            throw new RuleConfigurationException("Unknown Error was occurred when trying to registering the RuleExecutionSet with Uri " + bindUri, (Throwable)e);
        }
    }

    public void setDefaultPropertiesProvider(DefaultPropertiesProvider defaultPropertiesProvider) {
        this.defaultPropertiesProvider = defaultPropertiesProvider;
    }
}

