/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.mediator;

import java.util.ArrayList;
import java.util.Map;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.jaxen.JaxenException;
import org.wso2.carbon.rule.common.Input;
import org.wso2.carbon.rule.common.Output;
import org.wso2.carbon.rule.common.exception.RuleRuntimeException;
import org.wso2.carbon.rule.kernel.engine.RuleEngine;
import org.wso2.carbon.rule.kernel.engine.RuleSession;
import org.wso2.carbon.rule.mediator.config.Source;
import org.wso2.carbon.rule.mediator.config.Target;

public class RuleMediator
extends AbstractMediator {
    private RuleEngine ruleEngine;
    private OMElement ruleOMElement;
    private Source source;
    private Target target;
    private Input input;
    private Output output;

    public RuleMediator(RuleEngine ruleEngine, OMElement ruleOMElement, Source source, Target target, Input input, Output output) {
        this.ruleEngine = ruleEngine;
        this.ruleOMElement = ruleOMElement;
        this.source = source;
        this.target = target;
        this.input = input;
        this.output = output;
    }

    public boolean mediate(MessageContext messageContext) {
        OMElement inputOMElement = this.getOMElement(messageContext, this.source.getValue());
        if (this.source.getXpath() != null) {
            inputOMElement = this.executeXpath((OMNode)inputOMElement, this.source.getXpath(), this.source.getPrefixToNamespaceMap(), messageContext);
        }
        try {
            RuleSession ruleSession = this.ruleEngine.createSession(2);
            OMElement resultOMNode = ruleSession.execute(inputOMElement, this.input, this.output);
            if (this.target.getResultXpath() != null) {
                try {
                    AXIOMXPath axiomXPath = new AXIOMXPath(this.target.getResultXpath());
                    for (String prefix : this.target.getPrefixToNamespaceMap().keySet()) {
                        axiomXPath.addNamespace(prefix, this.target.getPrefixToNamespaceMap().get(prefix));
                    }
                    OMFactory omFactory = resultOMNode.getOMFactory();
                    OMDocument omDocument = omFactory.createOMDocument();
                    omDocument.addChild((OMNode)resultOMNode);
                    resultOMNode = (OMNode)axiomXPath.selectSingleNode((Object)resultOMNode);
                }
                catch (JaxenException e) {
                    this.handleException("Invalid xpath " + this.target.getResultXpath(), messageContext);
                }
            }
            OMElement targetOMElement = this.getOMElement(messageContext, this.target.getValue());
            if (this.target.getXpath() != null) {
                if (targetOMElement == null) {
                    this.handleException("Target element is null for the target" + this.target.getValue() + ". Can not apply xpaths.", messageContext);
                } else {
                    targetOMElement = this.executeXpath((OMNode)targetOMElement, this.target.getXpath(), this.target.getPrefixToNamespaceMap(), messageContext);
                }
            }
            if (this.target.getAction().equals("replace")) {
                if (this.target.getValue().startsWith("$")) {
                    String propertyName = this.target.getValue().substring(1);
                    if (resultOMNode instanceof OMText) {
                        messageContext.setProperty(propertyName, (Object)((OMText)resultOMNode).getText());
                    } else {
                        messageContext.setProperty(propertyName, (Object)resultOMNode);
                    }
                } else if (targetOMElement.getPreviousOMSibling() != null) {
                    OMNode previousSibling = targetOMElement.getPreviousOMSibling();
                    targetOMElement.detach();
                    previousSibling.insertSiblingAfter((OMNode)resultOMNode);
                } else if (targetOMElement.getParent() != null) {
                    OMElement parentOMElement = (OMElement)targetOMElement.getParent();
                    targetOMElement.detach();
                    parentOMElement.addChild((OMNode)resultOMNode);
                } else {
                    this.handleException("OMElement without parent but it is not a property as well " + this.source.getValue(), messageContext);
                }
            } else if (this.target.getAction().equals("sibling")) {
                targetOMElement.insertSiblingAfter((OMNode)resultOMNode);
            } else if (this.target.getAction().equals("child")) {
                targetOMElement.addChild((OMNode)resultOMNode);
            } else {
                this.handleException("Invalid action " + this.target.getAction(), messageContext);
            }
        }
        catch (RuleRuntimeException e) {
            this.handleException("Can not create the rule session ", (Exception)((Object)e), messageContext);
        }
        return true;
    }

    public OMElement getRuleOMElement() {
        return this.ruleOMElement;
    }

    public void setRuleOMElement(OMElement ruleOMElement) {
        this.ruleOMElement = ruleOMElement;
    }

    private OMElement getOMElement(MessageContext messageContext, String location) {
        OMElement omElement = null;
        if (location.equals("soapBody")) {
            omElement = messageContext.getEnvelope().getBody().getFirstElement();
        } else if (location.equals("soapHeader")) {
            omElement = messageContext.getEnvelope().getHeader();
        } else if (location.startsWith("$")) {
            String propertyName = location.substring(1);
            if (messageContext.getProperty(propertyName) instanceof OMElement) {
                omElement = (OMElement)messageContext.getProperty(propertyName);
            } else if (messageContext.getProperty(propertyName) instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)messageContext.getProperty(propertyName);
                omElement = (OMElement)arrayList.get(0);
            }
        } else {
            this.handleException("invalde source value " + location, messageContext);
        }
        return omElement;
    }

    private OMElement executeXpath(OMNode inputOMElement, String xpath, Map<String, String> prefixToNamespaceMap, MessageContext messageContext) {
        OMElement omElement = null;
        try {
            AXIOMXPath axiomXPath = new AXIOMXPath(xpath);
            for (Map.Entry<String, String> entry : prefixToNamespaceMap.entrySet()) {
                axiomXPath.addNamespace(entry.getKey(), entry.getValue());
            }
            omElement = (OMElement)axiomXPath.selectSingleNode((Object)inputOMElement);
        }
        catch (JaxenException e) {
            this.handleException("Invalid xpath " + xpath, messageContext);
        }
        return omElement;
    }
}

