/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.rule.common.Operation;
import org.wso2.carbon.rule.common.RuleSet;

public class RuleService {
    private String name;
    private String targetNamespace;
    private RuleSet ruleSet;
    private List<Operation> operations = new ArrayList<Operation>();
    private String scope;
    private String extension;
    private boolean editable = true;
    private String description;
    private boolean containsServicesXML = false;

    public OMElement toOM() {
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement ruleServiceOMElement = omFactory.createOMElement("ruleService", "http://wso2.org/carbon/rules", "brs");
        ruleServiceOMElement.addAttribute("name", this.name, null);
        if (this.targetNamespace != null) {
            ruleServiceOMElement.addAttribute("targetNamespace", this.targetNamespace, null);
        }
        if (this.scope != null) {
            ruleServiceOMElement.addAttribute("scope", this.scope, null);
        }
        if (this.description != null) {
            ruleServiceOMElement.addAttribute("description", this.description, null);
        }
        ruleServiceOMElement.addChild((OMNode)this.ruleSet.toOM());
        for (Operation operation : this.operations) {
            ruleServiceOMElement.addChild((OMNode)operation.toOM());
        }
        return ruleServiceOMElement;
    }

    public Operation getOperation(String name) {
        Operation resultOperation = null;
        for (Operation operation : this.operations) {
            if (!operation.getName().equals(name)) continue;
            resultOperation = operation;
            break;
        }
        return resultOperation;
    }

    public void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    public void removeOperation(String name) {
        ArrayList<Operation> tempOperations = new ArrayList<Operation>();
        for (Operation operation : this.operations) {
            if (!operation.getName().equalsIgnoreCase(name)) {
                tempOperations.add(operation);
            }
            this.operations = tempOperations;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<Operation> operations) {
        this.operations = operations;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isContainsServicesXML() {
        return this.containsServicesXML;
    }

    public void setContainsServicesXML(boolean containsServicesXML) {
        this.containsServicesXML = containsServicesXML;
    }
}

