/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.rule.common.Fact;

public class Output {
    private String wrapperElementName;
    private String nameSpace;
    private List<Fact> facts = new ArrayList<Fact>();
    private Map<String, QName> classTypeQNameMap = new HashMap<String, QName>();

    public OMElement toOM() {
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement ruleOutputOMElement = omFactory.createOMElement("output", "http://wso2.org/carbon/rules", "brs");
        if (this.nameSpace != null && !this.nameSpace.trim().equals("")) {
            ruleOutputOMElement.addAttribute("namespace", this.nameSpace, null);
        }
        if (this.wrapperElementName != null && !this.wrapperElementName.trim().equals("")) {
            ruleOutputOMElement.addAttribute("wrapperElementName", this.wrapperElementName, null);
        }
        for (Fact fact : this.facts) {
            ruleOutputOMElement.addChild((OMNode)fact.toOM());
        }
        return ruleOutputOMElement;
    }

    public void populateClassTypes() {
        for (Fact fact : this.facts) {
            this.classTypeQNameMap.put(fact.getType(), new QName(fact.getNamespace(), fact.getElementName()));
        }
    }

    public boolean isFactTypeExists(String type) {
        return this.classTypeQNameMap.containsKey(type);
    }

    public QName getFactTypeQName(String type) {
        return this.classTypeQNameMap.get(type);
    }

    public void addFact(Fact fact) {
        this.facts.add(fact);
    }

    public QName getQName() {
        return new QName(this.nameSpace, this.wrapperElementName);
    }

    public String getWrapperElementName() {
        return this.wrapperElementName;
    }

    public void setWrapperElementName(String wrapperElementName) {
        this.wrapperElementName = wrapperElementName;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public List<Fact> getFacts() {
        return this.facts;
    }

    public void setFacts(List<Fact> facts) {
        this.facts = facts;
    }
}

