/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.backend.drools;

import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.drools.KnowledgeBase;
import org.drools.builder.DecisionTableConfiguration;
import org.drools.builder.DecisionTableInputType;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceConfiguration;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.StatelessKnowledgeSession;
import org.wso2.carbon.rule.backend.drools.DroolsStatefulSession;
import org.wso2.carbon.rule.backend.drools.DroolsStatelessSession;
import org.wso2.carbon.rule.backend.util.RuleSetLoader;
import org.wso2.carbon.rule.common.Rule;
import org.wso2.carbon.rule.common.RuleSet;
import org.wso2.carbon.rule.common.exception.RuleConfigurationException;
import org.wso2.carbon.rule.common.exception.RuleRuntimeException;
import org.wso2.carbon.rule.kernel.backend.RuleBackendRuntime;
import org.wso2.carbon.rule.kernel.backend.Session;

public class DroolsBackendRuntime
implements RuleBackendRuntime {
    private static Log log = LogFactory.getLog(DroolsBackendRuntime.class);
    private KnowledgeBase knowledgeBase;
    private KnowledgeBuilder knowledgeBuilder;
    private ClassLoader classLoader;

    public DroolsBackendRuntime(KnowledgeBase knowledgeBase, KnowledgeBuilder knowledgeBuilder, ClassLoader classLoader) {
        this.knowledgeBase = knowledgeBase;
        this.knowledgeBuilder = knowledgeBuilder;
        this.classLoader = classLoader;
    }

    public void addRuleSet(RuleSet ruleSet) throws RuleConfigurationException {
        for (Rule rule : ruleSet.getRules()) {
            InputStream ruleInputStream = RuleSetLoader.getRuleSetAsStream(rule, this.classLoader);
            if (rule.getResourceType().equals("regular")) {
                this.knowledgeBuilder.add(ResourceFactory.newInputStreamResource((InputStream)ruleInputStream), ResourceType.DRL);
            } else if (rule.getResourceType().equals("dtable")) {
                DecisionTableConfiguration dtconf = KnowledgeBuilderFactory.newDecisionTableConfiguration();
                dtconf.setInputType(DecisionTableInputType.XLS);
                this.knowledgeBuilder.add(ResourceFactory.newInputStreamResource((InputStream)ruleInputStream), ResourceType.DTABLE, (ResourceConfiguration)dtconf);
            }
            if (this.knowledgeBuilder.hasErrors()) {
                throw new RuleConfigurationException("Error during creating rule set: " + this.knowledgeBuilder.getErrors());
            }
            Collection pkgs = this.knowledgeBuilder.getKnowledgePackages();
            this.knowledgeBase.addKnowledgePackages(pkgs);
        }
    }

    public Session createSession(int type) throws RuleRuntimeException {
        Object sesson;
        if (type == 2) {
            StatefulKnowledgeSession ruleSession = this.knowledgeBase.newStatefulKnowledgeSession();
            if (ruleSession == null) {
                throw new RuleRuntimeException("The created stateful rule session is null");
            }
            sesson = new DroolsStatefulSession(ruleSession);
        } else {
            StatelessKnowledgeSession ruleSession;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Using stateless rule session");
            }
            if ((ruleSession = this.knowledgeBase.newStatelessKnowledgeSession()) == null) {
                throw new RuleRuntimeException("The created stateless rule session is null");
            }
            sesson = new DroolsStatelessSession(ruleSession);
        }
        return sesson;
    }
}

