/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rssmanager.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.wso2.carbon.rssmanager.common.RSSManagerCommonUtil;
import org.wso2.carbon.rssmanager.ui.beans.DatabaseInstance;
import org.wso2.carbon.rssmanager.ui.beans.DatabasePermissions;

public class RSSManagerClientUtil {
    private static final OMFactory omFactory = OMAbstractFactory.getOMFactory();
    private static final String NULL_NAMESPACE = "";
    private static final OMNamespace NULL_OMNS = omFactory.createOMNamespace("", "");

    public static DatabaseInstance buildDatabaseInstance(OMElement dbEl) throws Exception {
        String rssInsId;
        String dbInsId;
        DatabaseInstance db = new DatabaseInstance();
        String name = dbEl.getAttributeValue(new QName(NULL_NAMESPACE, "name"));
        if (name != null) {
            db.setName(name);
        }
        if ((dbInsId = dbEl.getAttributeValue(new QName(NULL_NAMESPACE, "dbInsId"))) != null) {
            db.setDatabaseInstanceId(Integer.parseInt(dbInsId));
        }
        if ((rssInsId = dbEl.getAttributeValue(new QName(NULL_NAMESPACE, "rssInsId"))) != null) {
            db.setRssInstanceId(Integer.parseInt(rssInsId));
        }
        return db;
    }

    public static List<DatabaseInstance> buildDatabaseInstanceList(OMElement rootEl) throws Exception {
        ArrayList<DatabaseInstance> dbs = new ArrayList<DatabaseInstance>();
        OMElement dbsEl = (OMElement)rootEl.getChildElements().next();
        Iterator itr = dbsEl.getChildElements();
        while (itr.hasNext()) {
            OMElement dbEl = (OMElement)itr.next();
            DatabaseInstance db = RSSManagerClientUtil.buildDatabaseInstance(dbEl);
            if (db == null) continue;
            dbs.add(db);
        }
        return dbs;
    }

    public static OMElement serializeDatabaseInstanceData(OMNamespace targetNamespace, DatabaseInstance db) throws Exception {
        String dbInstId;
        String dbName;
        if (db == null) {
            throw new Exception("DatabaseInfo Object Cannot Be Null");
        }
        OMElement dbEl = omFactory.createOMElement("db", targetNamespace);
        String rssInstId = String.valueOf(db.getRssInstanceId());
        if (!NULL_NAMESPACE.equals(rssInstId) && rssInstId != null) {
            dbEl.addAttribute("rssInsId", rssInstId, NULL_OMNS);
        }
        if (!NULL_NAMESPACE.equals(dbName = db.getName()) && dbName != null) {
            dbEl.addAttribute("name", dbName, NULL_OMNS);
        }
        if (!NULL_NAMESPACE.equals(dbInstId = String.valueOf(db.getDatabaseInstanceId())) && dbInstId != null) {
            dbEl.addAttribute("dbInsId", dbInstId, NULL_OMNS);
        }
        return dbEl;
    }

    public static OMElement serializePermissionObject(OMNamespace targetNamespace, DatabasePermissions permissions) throws Exception {
        if (permissions == null) {
            throw new Exception("Permissions Object Cannot Be Null");
        }
        OMElement permissionsElement = omFactory.createOMElement("permissions", targetNamespace);
        for (Map.Entry<String, Object> entry : permissions.getPrivilegeMap().entrySet()) {
            Object attributeValue = entry.getValue();
            if (attributeValue != null) {
                permissionsElement.addAttribute(entry.getKey().toString(), attributeValue.toString(), targetNamespace);
                continue;
            }
            permissionsElement.addAttribute(entry.getKey().toString(), NULL_NAMESPACE, targetNamespace);
        }
        return permissionsElement;
    }

    public static DatabasePermissions getPermissionObject(OMElement privilegesElement) {
        DatabasePermissions permissions = new DatabasePermissions();
        Iterator attributeIterator = privilegesElement.getAllAttributes();
        while (attributeIterator.hasNext()) {
            OMAttribute attribute = (OMAttribute)attributeIterator.next();
            String attributeName = attribute.getLocalName();
            String value = attribute.getAttributeValue();
            for (String priv : RSSManagerCommonUtil.getDatabasePrivilegeList()) {
                if (!priv.equals(attributeName)) continue;
                if (value != null) {
                    if (RSSManagerCommonUtil.getBooleanResponsePrivilegeList().contains(priv)) {
                        permissions.setPermission(priv, value);
                        continue;
                    }
                    if (RSSManagerCommonUtil.getBlobResponsePrivilegeList().contains(priv)) {
                        permissions.setPermission(priv, value);
                        continue;
                    }
                    if (RSSManagerCommonUtil.getIntegerResponsePrivilegeList().contains(priv)) {
                        permissions.setPermission(priv, Integer.parseInt(value));
                        continue;
                    }
                    if (!RSSManagerCommonUtil.getStringResponsePrivilegeList().contains(priv)) continue;
                    permissions.setPermission(priv, value);
                    continue;
                }
                if (RSSManagerCommonUtil.getBooleanResponsePrivilegeList().contains(priv)) {
                    permissions.setPermission(priv, "N");
                    continue;
                }
                if (RSSManagerCommonUtil.getBlobResponsePrivilegeList().contains(priv)) {
                    permissions.setPermission(priv, NULL_NAMESPACE);
                    continue;
                }
                if (RSSManagerCommonUtil.getIntegerResponsePrivilegeList().contains(priv)) {
                    permissions.setPermission(priv, 0);
                    continue;
                }
                if (!RSSManagerCommonUtil.getStringResponsePrivilegeList().contains(priv)) continue;
                permissions.setPermission(priv, NULL_NAMESPACE);
            }
        }
        return permissions;
    }
}

