/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rssmanager.common;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class RSSManagerCommonUtil {
    private static List<String> userPrivilegeList = new ArrayList<String>();
    private static List<String> databasePrivilegeList = new ArrayList<String>();
    private static List<String> boolResponsePrivilegeList = new ArrayList<String>();
    private static List<String> strResponsePrivilegeList = new ArrayList<String>();
    private static List<String> intResponsePrivilegeList = new ArrayList<String>();
    private static List<String> blobPrivilegeList = new ArrayList<String>();

    public static List<String> getUserPrivilegeList() {
        return userPrivilegeList;
    }

    public static List<String> getDatabasePrivilegeList() {
        return databasePrivilegeList;
    }

    public static List<String> getBooleanResponsePrivilegeList() {
        return boolResponsePrivilegeList;
    }

    public static List<String> getStringResponsePrivilegeList() {
        return strResponsePrivilegeList;
    }

    public static List<String> getBlobResponsePrivilegeList() {
        return blobPrivilegeList;
    }

    public static List<String> getIntegerResponsePrivilegeList() {
        return intResponsePrivilegeList;
    }

    public static String getDatabaseDriver(String url) {
        if (url != null) {
            String prefix = url.split(":")[1];
            if ("mysql".equals(prefix)) {
                return "com.mysql.jdbc.Driver";
            }
            if ("oracle".equals(prefix)) {
                return "oracle.jdbc.driver.OracleDriver";
            }
        }
        return "";
    }

    public static byte[] intToByteArray(int value) {
        byte[] b = new byte[6];
        for (int i = 0; i < 6; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFF);
        }
        return b;
    }

    public static String processDomainName(String domainName) {
        char[] chars = domainName.toCharArray();
        StringBuilder sb = new StringBuilder();
        if (domainName.contains(".")) {
            for (char aChar : chars) {
                if (".".equals(String.valueOf(aChar))) {
                    sb.append("_");
                    continue;
                }
                sb.append(aChar);
            }
        }
        return sb.toString();
    }

    public static String getDatabasePrefix(String url) {
        if (url != null && !"".equals(url)) {
            return url.split(":")[1];
        }
        return "";
    }

    public static String validateRSSInstanceHostname(String url) throws URISyntaxException {
        if (url != null && !"".equals(url)) {
            URI uri = new URI(url.split("jdbc:")[1]);
            return uri.getHost() + ":" + (uri.getPort() != -1 ? Integer.valueOf(uri.getPort()) : "");
        }
        return "";
    }

    public static String validateRSSInstanceUrl(String url) throws URISyntaxException {
        if (url != null && !"".equals(url)) {
            URI uri = new URI(url.split("jdbc:")[1]);
            return "jdbc:" + uri.getScheme() + "://" + uri.getHost() + ":" + (uri.getPort() != -1 ? Integer.valueOf(uri.getPort()) : "");
        }
        return "";
    }

    static {
        userPrivilegeList.add("Select_priv");
        userPrivilegeList.add("Insert_priv");
        userPrivilegeList.add("Update_priv");
        userPrivilegeList.add("Delete_priv");
        userPrivilegeList.add("Create_priv");
        userPrivilegeList.add("Drop_priv");
        userPrivilegeList.add("Reload_priv");
        userPrivilegeList.add("Shutdown_priv");
        userPrivilegeList.add("Process_priv");
        userPrivilegeList.add("File_priv");
        userPrivilegeList.add("Grant_priv");
        userPrivilegeList.add("References_priv");
        userPrivilegeList.add("Index_priv");
        userPrivilegeList.add("Alter_priv");
        userPrivilegeList.add("Show_db_priv");
        userPrivilegeList.add("Super_priv");
        userPrivilegeList.add("Create_tmp_table_priv");
        userPrivilegeList.add("Lock_tables_priv");
        userPrivilegeList.add("Execute_priv");
        userPrivilegeList.add("Repl_slave_priv");
        userPrivilegeList.add("Repl_client_priv");
        userPrivilegeList.add("Create_view_priv");
        userPrivilegeList.add("Show_view_priv");
        userPrivilegeList.add("Create_routine_priv");
        userPrivilegeList.add("Alter_routine_priv");
        userPrivilegeList.add("Create_user_priv");
        userPrivilegeList.add("Event_priv");
        userPrivilegeList.add("Trigger_priv");
        userPrivilegeList.add("ssl_type");
        userPrivilegeList.add("ssl_cipher");
        userPrivilegeList.add("x509_issuer");
        userPrivilegeList.add("x509_subject");
        userPrivilegeList.add("max_questions");
        userPrivilegeList.add("max_updates");
        userPrivilegeList.add("max_connections");
        userPrivilegeList.add("max_user_connections");
        databasePrivilegeList.add("Select_priv");
        databasePrivilegeList.add("Insert_priv");
        databasePrivilegeList.add("Update_priv");
        databasePrivilegeList.add("Delete_priv");
        databasePrivilegeList.add("Create_priv");
        databasePrivilegeList.add("Drop_priv");
        databasePrivilegeList.add("Grant_priv");
        databasePrivilegeList.add("References_priv");
        databasePrivilegeList.add("Index_priv");
        databasePrivilegeList.add("Alter_priv");
        databasePrivilegeList.add("Create_tmp_table_priv");
        databasePrivilegeList.add("Lock_tables_priv");
        databasePrivilegeList.add("Create_view_priv");
        databasePrivilegeList.add("Show_view_priv");
        databasePrivilegeList.add("Create_routine_priv");
        databasePrivilegeList.add("Alter_routine_priv");
        databasePrivilegeList.add("Execute_priv");
        databasePrivilegeList.add("Event_priv");
        databasePrivilegeList.add("Trigger_priv");
        boolResponsePrivilegeList.add("Select_priv");
        boolResponsePrivilegeList.add("Insert_priv");
        boolResponsePrivilegeList.add("Update_priv");
        boolResponsePrivilegeList.add("Delete_priv");
        boolResponsePrivilegeList.add("Create_priv");
        boolResponsePrivilegeList.add("Drop_priv");
        boolResponsePrivilegeList.add("Reload_priv");
        boolResponsePrivilegeList.add("Shutdown_priv");
        boolResponsePrivilegeList.add("Process_priv");
        boolResponsePrivilegeList.add("File_priv");
        boolResponsePrivilegeList.add("Grant_priv");
        boolResponsePrivilegeList.add("References_priv");
        boolResponsePrivilegeList.add("Index_priv");
        boolResponsePrivilegeList.add("Alter_priv");
        boolResponsePrivilegeList.add("Show_db_priv");
        boolResponsePrivilegeList.add("Super_priv");
        boolResponsePrivilegeList.add("Create_tmp_table_priv");
        boolResponsePrivilegeList.add("Lock_tables_priv");
        boolResponsePrivilegeList.add("Execute_priv");
        boolResponsePrivilegeList.add("Repl_slave_priv");
        boolResponsePrivilegeList.add("Repl_client_priv");
        boolResponsePrivilegeList.add("Create_view_priv");
        boolResponsePrivilegeList.add("Show_view_priv");
        boolResponsePrivilegeList.add("Create_routine_priv");
        boolResponsePrivilegeList.add("Alter_routine_priv");
        boolResponsePrivilegeList.add("Create_user_priv");
        boolResponsePrivilegeList.add("Event_priv");
        boolResponsePrivilegeList.add("Trigger_priv");
        strResponsePrivilegeList.add("ssl_type");
        intResponsePrivilegeList.add("max_questions");
        intResponsePrivilegeList.add("max_updates");
        intResponsePrivilegeList.add("max_connections");
        intResponsePrivilegeList.add("max_user_connections");
        blobPrivilegeList.add("ssl_cipher");
        blobPrivilegeList.add("x509_issuer");
        blobPrivilegeList.add("x509_subject");
    }
}

