/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.ui.jsp;

import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axis2.builder.DiskFileDataSource;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.ui.ServiceHolder;

public class SecurityUIUtil {
    private static String url = null;

    public static String getUrl() throws Exception {
        if (url == null) {
            ServiceHolder serviceHodler = ServiceHolder.getInstance();
            RegistryService regService = serviceHodler.getRegistryService();
            UserRegistry systemRegistry = regService.getConfigSystemRegistry();
            Resource resource = systemRegistry.get("/carbon/connection/props");
            String servicePath = resource.getProperty("service-path");
            String contextRoot = resource.getProperty("context-root");
            String host = resource.getProperty("host-name");
            contextRoot = contextRoot.equals("/") ? "" : contextRoot;
            host = host == null ? "localhost" : host;
            String port = System.getProperty("carbon.https.port");
            url = "https://" + host + ":" + port + "/" + contextRoot + servicePath + "/";
        }
        return url;
    }

    public static List parseRequest(ServletRequestContext requestContext) throws FileUploadException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        return upload.parseRequest((RequestContext)requestContext);
    }

    public static String getTextParameter(DiskFileItem diskFileItem, String characterEncoding) throws Exception {
        String encoding = diskFileItem.getCharSet();
        if (encoding == null) {
            encoding = characterEncoding;
        }
        String textValue = encoding == null ? new String(diskFileItem.get()) : new String(diskFileItem.get(), encoding);
        return textValue;
    }

    public static DataHandler getFileParameter(DiskFileItem diskFileItem) throws Exception {
        DiskFileDataSource dataSource = new DiskFileDataSource(diskFileItem);
        DataHandler dataHandler = new DataHandler((DataSource)dataSource);
        return dataHandler;
    }
}

