/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.service.mgt.multitenancy;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.ArtifactUnloader;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.service.mgt.internal.DataHolder;
import org.wso2.carbon.utils.deployment.GhostDeployer;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public class ServiceUnloader
implements ArtifactUnloader {
    private static final Log log = LogFactory.getLog(ServiceUnloader.class);
    private static final long DEFAULT_MAX_INACTIVE_INTERVAL = 10L;

    public void unload() {
        ConfigurationContext mainConfigCtx = DataHolder.getServerConfigContext();
        if (mainConfigCtx == null) {
            return;
        }
        try {
            Set ccEntries = TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)mainConfigCtx).entrySet();
            for (Map.Entry entry : ccEntries) {
                String tenantDomain = (String)entry.getKey();
                this.unloadInactiveServices((ConfigurationContext)entry.getValue(), tenantDomain);
            }
            this.unloadInactiveServices(mainConfigCtx, "Super Tenant");
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while unloading inactive services..", (Throwable)axisFault);
        }
    }

    private void unloadInactiveServices(ConfigurationContext configCtx, String tenantDomain) throws AxisFault {
        AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
        if (axisConfig != null) {
            Collection services = axisConfig.getServices().values();
            for (AxisService service : services) {
                GhostDeployer ghostDeployer;
                Parameter lastUsageParam;
                if (this.isSkippedServiceType(service) || (lastUsageParam = service.getParameter("lastUsedTime")) == null || !this.isInactive((Long)lastUsageParam.getValue()) || (ghostDeployer = GhostDeployerUtils.getGhostDeployer((AxisConfiguration)axisConfig)) == null || service.getFileName() == null) continue;
                AxisServiceGroup existingSG = (AxisServiceGroup)service.getParent();
                log.info((Object)("Unloading actual Service Group : " + existingSG.getServiceGroupName() + " and adding a Ghost Service Group. " + "Tenant Domain: " + tenantDomain));
                existingSG.addParameter("isBeingUnloaded", (Object)"true");
                GhostDeployerUtils.addServiceGroupToTransitMap((AxisServiceGroup)existingSG, (AxisConfiguration)axisConfig);
                existingSG.addParameter("keepServiceHistory", (Object)"true");
                axisConfig.removeServiceGroup(existingSG.getServiceGroupName());
                File ghostFile = GhostDeployerUtils.getGhostFile((String)service.getFileName().getPath(), (AxisConfiguration)axisConfig);
                AxisServiceGroup ghostServiceGroup = GhostDeployerUtils.createGhostServiceGroup((AxisConfiguration)axisConfig, (File)ghostFile, (URL)service.getFileName());
                if (ghostServiceGroup == null) continue;
                axisConfig.addServiceGroup(ghostServiceGroup);
                GhostDeployerUtils.removeServiceGroupFromTransitMap((AxisServiceGroup)ghostServiceGroup, (AxisConfiguration)axisConfig);
            }
        }
    }

    private boolean isInactive(Long lastUsedTime) {
        long inactiveInterval = System.currentTimeMillis() - lastUsedTime;
        long maxInactiveInterval = 10L;
        String property = System.getProperty("service.idle.time");
        if (property != null) {
            maxInactiveInterval = Long.parseLong(property);
        }
        return inactiveInterval > maxInactiveInterval * 60L * 1000L;
    }

    private boolean isSkippedServiceType(AxisService service) {
        String serviceType = null;
        Parameter serviceTypeParam = service.getParameter("serviceType");
        if (serviceTypeParam != null) {
            serviceType = (String)serviceTypeParam.getValue();
        }
        return serviceType != null && serviceType.equals("bpel");
    }
}

