/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttle.ui.client;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.throttle.stub.ThrottleAdminServiceStub;
import org.wso2.carbon.throttle.stub.ThrottleComponentExceptionException;
import org.wso2.carbon.throttle.stub.types.InternalData;
import org.wso2.carbon.throttle.stub.types.ThrottlePolicy;
import org.wso2.carbon.ui.CarbonUIMessage;

public class ThrottleClient {
    private ThrottleAdminServiceStub stub;
    private ResourceBundle bundle;
    private static final String BUNDLE = "org.wso2.carbon.throttle.ui.i18n.Resources";
    private static final Log log = LogFactory.getLog(ThrottleClient.class);

    public ThrottleClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "ThrottleAdminService";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new ThrottleAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public void updateBackEnd(HttpServletRequest request) throws AxisFault, NumberFormatException {
        String service = request.getParameter("serviceName");
        String operation = request.getParameter("opName");
        String policyID = request.getParameter("policyID");
        boolean global = false;
        boolean operationLevel = false;
        boolean mediator = policyID != null && !"".equals(policyID);
        boolean engagedAtHigherLevel = false;
        if (!mediator) {
            if (service == null) {
                global = true;
            } else if (service != null && operation != null) {
                operationLevel = true;
            }
        }
        try {
            String msg;
            if ("Yes".equals(request.getParameter("enable"))) {
                ArrayList<InternalData> list = new ArrayList<InternalData>();
                String value = "";
                int i = 0;
                while (value != null) {
                    InternalData temp = new InternalData();
                    if (request.getParameter("data" + ++i + "1") == null) break;
                    block12: for (int j = 1; j < 7; ++j) {
                        value = request.getParameter("data" + i + "" + j);
                        if (value == null || value.equals("")) continue;
                        switch (j) {
                            case 1: {
                                temp.setRange(value);
                                continue block12;
                            }
                            case 2: {
                                temp.setMaxRequestCount(Integer.parseInt(value));
                                continue block12;
                            }
                            case 3: {
                                temp.setUnitTime(Integer.parseInt(value));
                                continue block12;
                            }
                            case 4: {
                                temp.setProhibitTimePeriod(Integer.parseInt(value));
                                continue block12;
                            }
                            case 5: {
                                if (value.equals("Control")) {
                                    temp.setAccessLevel(0);
                                    continue block12;
                                }
                                if (value.equals("Deny")) {
                                    temp.setAccessLevel(1);
                                    continue block12;
                                }
                                temp.setAccessLevel(2);
                                continue block12;
                            }
                            case 6: {
                                temp.setRangeType(value);
                                continue block12;
                            }
                        }
                    }
                    list.add(temp);
                }
                InternalData[] data = new InternalData[list.size()];
                for (int p = 0; p < list.size(); ++p) {
                    data[p] = (InternalData)list.get(p);
                }
                ThrottlePolicy policy = new ThrottlePolicy();
                policy.setEngaged(true);
                policy.setInternalConfigs(data);
                if (request.getParameter("maxAccess") != null && !request.getParameter("maxAccess").equals("")) {
                    policy.setMaxConcurrentAccesses(Integer.parseInt(request.getParameter("maxAccess")));
                }
                if (global) {
                    this.stub.globallyEngageThrottling(policy);
                } else if (operationLevel) {
                    engagedAtHigherLevel = this.stub.engageThrottlingForOperation(policy, service, operation);
                } else if (mediator) {
                    String policyXMl = this.stub.throttlePolicyToString(policy);
                    if (policyXMl != null && !"".equals(policyXMl)) {
                        HashMap<String, String> policyXMLMap = (HashMap<String, String>)request.getSession().getAttribute("throttle_policy_map");
                        if (policyXMLMap == null) {
                            policyXMLMap = new HashMap<String, String>();
                        }
                        policyXMLMap.put(policyID, policyXMl);
                        request.getSession().setAttribute("throttle_policy_map", policyXMLMap);
                    }
                } else {
                    this.stub.enableThrottling(service, policy);
                }
            } else if (global) {
                this.stub.disengageGlobalThrottling();
            } else if (operationLevel) {
                engagedAtHigherLevel = this.stub.disengageThrottlingForOperation(service, operation);
            } else {
                this.stub.disableThrottling(service);
            }
            if (engagedAtHigherLevel) {
                msg = this.bundle.getString("throttling.applied.at.higher.level");
                CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"warning", (HttpServletRequest)request);
            } else {
                msg = this.bundle.getString("throttling.successfully.applied");
                CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"info", (HttpServletRequest)request);
            }
        }
        catch (NumberFormatException e) {
            String msg = this.bundle.getString("throttling.numbers.invalid");
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"warning", (HttpServletRequest)request);
            throw e;
        }
        catch (Exception e) {
            String msg = this.bundle.getString("throttling.error.while.communication.with.back.end");
            this.handleException(msg, e);
        }
    }

    public ThrottlePolicy getExistingConfigs(HttpServletRequest request, boolean global, boolean operationLevel) throws AxisFault {
        ThrottlePolicy policy = null;
        try {
            String service = request.getParameter("serviceName");
            String operation = request.getParameter("opName");
            String loadDef = request.getParameter("loadDefault");
            ThrottlePolicy defThrottlePolicy = this.getDefaultThrottlePolicy();
            if (loadDef != null && loadDef.equals("true")) {
                defThrottlePolicy.setEngaged(true);
                policy = defThrottlePolicy;
            } else {
                policy = global ? this.stub.getGlobalPolicyConfigs() : (operationLevel ? this.stub.getOperationPolicyConfigs(service, operation) : this.stub.getPolicyConfigs(service));
                if (!(policy.getEngaged() || policy.getMaxConcurrentAccesses() != 0 || policy.getInternalConfigs() != null && policy.getInternalConfigs()[0] != null)) {
                    policy = defThrottlePolicy;
                }
            }
        }
        catch (Exception e) {
            String msg = this.bundle.getString("throttling.cannot.get.existing.data");
            this.handleException(msg, e);
        }
        return policy;
    }

    public ThrottlePolicy toThrottlePolicy(String xml, String loadDefault) throws RemoteException, ThrottleComponentExceptionException {
        if (xml == null || "".equals(xml) || "true".equals(loadDefault)) {
            return this.getDefaultThrottlePolicy();
        }
        return this.stub.toThrottlePolicy(xml);
    }

    public String throttlePolicyToString(ThrottlePolicy throttlePolicy) throws RemoteException, ThrottleComponentExceptionException {
        return this.stub.throttlePolicyToString(throttlePolicy);
    }

    private ThrottlePolicy getDefaultThrottlePolicy() {
        ThrottlePolicy defThrottlePolicy = new ThrottlePolicy();
        InternalData[] defData = new InternalData[2];
        defThrottlePolicy.setInternalConfigs(defData);
        defData[0] = new InternalData();
        defData[0].setRange("other");
        defData[0].setRangeType("IP");
        defData[0].setAccessLevel(2);
        defData[1] = new InternalData();
        defData[1].setRange("other");
        defData[1].setRangeType("DOMAIN");
        defData[1].setAccessLevel(2);
        return defThrottlePolicy;
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

