/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.policyeditor;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;

public class PolicyEditorService {
    private static final Log log = LogFactory.getLog(PolicyEditorService.class);
    private static final String ORG_WSO2_CARBON_POLICYEDITOR_XSD = "/org/wso2/carbon/policyeditor/xsd/";

    public String getPolicyDoc(String policyURL) throws AxisFault {
        String policy = "";
        try {
            URL url = new URL(policyURL);
            InputStream in = url.openStream();
            BufferedReader dis = new BufferedReader(new InputStreamReader(in));
            StringBuilder fBuf = new StringBuilder();
            String line = "";
            while ((line = dis.readLine()) != null) {
                fBuf.append(line).append("\n");
            }
            in.close();
            policy = fBuf.toString();
        }
        catch (IOException e) {
            throw new AxisFault(e.getMessage());
        }
        return "<![CDATA[" + policy + "]]>";
    }

    public String getSchema(String fileName) throws AxisFault {
        String schema = "";
        StringBuffer fBuf = null;
        try {
            InputStream in = PolicyEditorService.class.getResourceAsStream(ORG_WSO2_CARBON_POLICYEDITOR_XSD + fileName);
            BufferedReader dis = new BufferedReader(new InputStreamReader(in));
            fBuf = new StringBuffer();
            String line = "";
            while ((line = dis.readLine()) != null) {
                fBuf.append(line).append("\n");
            }
            in.close();
            schema = fBuf.toString();
        }
        catch (IOException e) {
            throw new AxisFault(e.getMessage());
        }
        return "<![CDATA[" + schema + "]]>";
    }

    public String getAvailableSchemas() throws AxisFault {
        String fileList = "";
        StringBuffer fBuf = null;
        try {
            InputStream in = PolicyEditorService.class.getResourceAsStream("/org/wso2/carbon/policyeditor/xsd/policies.xml");
            BufferedReader dis = new BufferedReader(new InputStreamReader(in));
            fBuf = new StringBuffer();
            String line = "";
            while ((line = dis.readLine()) != null) {
                fBuf.append(line).append("\n");
            }
            in.close();
            fileList = fBuf.toString();
        }
        catch (IOException e) {
            throw new AxisFault(e.getMessage());
        }
        return "<![CDATA[" + fileList + "]]>";
    }

    public String formatXML(String xml) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document xmlDoc = docBuilder.parse(new ByteArrayInputStream(xml.getBytes()));
            OutputFormat format = new OutputFormat(xmlDoc);
            format.setLineWidth(0);
            format.setIndenting(true);
            format.setIndent(2);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLSerializer serializer = new XMLSerializer((OutputStream)baos, format);
            serializer.serialize(xmlDoc);
            xml = baos.toString();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return "<![CDATA[" + xml + "]]>";
    }
}

