/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rm.service;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.storage.jdbc.PersistentStorageManager;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.persistence.PersistenceException;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.core.persistence.file.ServiceGroupFilePersistenceManager;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.rm.service.RMParameterBean;

public class RMAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(RMAdminService.class);
    private static final String RM_POLICY_ID = "RMPolicy";
    private PersistenceFactory persistenceFactory = PersistenceFactory.getInstance((AxisConfiguration)this.getAxisConfig());
    private ServiceGroupFilePersistenceManager serviceGroupFilePM = this.persistenceFactory.getServiceGroupFilePM();
    private Registry registry = this.getConfigSystemRegistry();

    public boolean isRMEnabled(String serviceName) throws AxisFault {
        AxisConfiguration axisConfiguration = this.getAxisConfig();
        AxisService axisServce = axisConfiguration.getServiceForActivation(serviceName);
        AxisModule sandeshaModule = axisConfiguration.getModule("sandesha2");
        return axisServce.isEngaged(sandeshaModule);
    }

    public void enableRM(String serviceName) throws AxisFault {
        AxisConfiguration axisConfiguration = this.getAxisConfig();
        AxisService axisService = axisConfiguration.getServiceForActivation(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        AxisModule sandesahModule = axisConfiguration.getModule("sandesha2");
        String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
        try {
            boolean transactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId);
            if (!transactionStarted) {
                this.serviceGroupFilePM.beginTransaction(serviceGroupId);
            }
            List associations = this.serviceGroupFilePM.getAll(serviceGroupId, serviceXPath + "/" + "module" + PersistenceUtils.getXPathAttrPredicate((String)"type", (String)"engagedModules"));
            boolean associationExist = false;
            String version = sandesahModule.getVersion().toString();
            if (sandesahModule.getVersion() == null) {
                version = "undefined";
            }
            for (Object node : associations) {
                OMElement association = (OMElement)node;
                if (!association.getAttributeValue(new QName("name")).equals(sandesahModule.getName()) || !association.getAttributeValue(new QName("version")).equals(version)) continue;
                associationExist = true;
                break;
            }
            if (!associationExist) {
                this.serviceGroupFilePM.put(serviceGroupId, PersistenceUtils.createModule((String)sandesahModule.getName(), (String)version, (String)"engagedModules"), serviceXPath);
            }
            if (!transactionStarted) {
                this.serviceGroupFilePM.commitTransaction(serviceGroupId);
            }
        }
        catch (PersistenceException e) {
            log.error((Object)"Error occured persisting RM", (Throwable)e);
            throw new AxisFault("Cannot persist RM metadata");
        }
        axisService.engageModule(sandesahModule);
    }

    public void disableRM(String serviceName) throws AxisFault {
        AxisConfiguration axisConfiguration = this.getAxisConfig();
        AxisService axisService = axisConfiguration.getServiceForActivation(serviceName);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        AxisModule sandesahModule = axisConfiguration.getModule("sandesha2");
        String servicePath = "/repository/axis2/service-groups/" + axisService.getAxisServiceGroup().getServiceGroupName() + "/services/" + serviceName;
        ServiceGroupFilePersistenceManager sfpm = this.persistenceFactory.getServiceGroupFilePM();
        try {
            boolean transactionStarted = sfpm.isTransactionStarted(serviceGroupId);
            if (!transactionStarted) {
                sfpm.beginTransaction(serviceGroupId);
            }
            sfpm.delete(serviceGroupId, PersistenceUtils.getResourcePath((AxisService)axisService) + "/" + "module" + PersistenceUtils.getXPathAttrPredicate((String)"name", (String)sandesahModule.getName()) + PersistenceUtils.getXPathAttrPredicate((String)"type", (String)"engagedModules"));
            if (!transactionStarted) {
                sfpm.commitTransaction(serviceGroupId);
            }
        }
        catch (PersistenceException e) {
            log.error((Object)"Error ocurred in disengaging the module ", (Throwable)e);
            throw new AxisFault("Error ocurred in disengaging the module ");
        }
        axisService.disengageModule(sandesahModule);
    }

    public void setParameters(String serviceName, RMParameterBean parameters) throws AxisFault {
        AxisConfiguration axisConfiguration = this.getAxisConfig();
        AxisService axisService = axisConfiguration.getServiceForActivation(serviceName);
        if (parameters != null) {
            SandeshaPolicyBean sandeshaPolicyBean;
            Parameter sandeshaPolicyBeanParameter = axisService.getParameter("Sandesha2PropertyBean");
            if (sandeshaPolicyBeanParameter != null) {
                sandeshaPolicyBean = (SandeshaPolicyBean)sandeshaPolicyBeanParameter.getValue();
                if (sandeshaPolicyBean.getParent() == null) {
                    sandeshaPolicyBean = new SandeshaPolicyBean();
                    sandeshaPolicyBean.setParent((SandeshaPolicyBean)sandeshaPolicyBeanParameter.getValue());
                    axisService.addParameter("Sandesha2PropertyBean", (Object)sandeshaPolicyBean);
                }
            } else {
                sandeshaPolicyBean = new SandeshaPolicyBean();
                axisService.addParameter("Sandesha2PropertyBean", (Object)sandeshaPolicyBean);
            }
            sandeshaPolicyBean.setInactiveTimeoutInterval(parameters.getInactivityTimeoutInterval(), parameters.getInactivityTimeoutMeasure());
            sandeshaPolicyBean.setSequenceRemovalTimeoutInterval(parameters.getSequenceRemovalTimeoutInterval(), parameters.getSequenceRemovalTimeoutMeasure());
            sandeshaPolicyBean.setSequenceRemovalTimeoutMeasure(parameters.getSequenceRemovalTimeoutMeasure());
            sandeshaPolicyBean.setAcknowledgementInterval(parameters.getAcknowledgementInterval());
            sandeshaPolicyBean.setRetransmissionInterval(parameters.getRetransmissionInterval());
            sandeshaPolicyBean.setExponentialBackoff(parameters.isExponentialBackoff());
            sandeshaPolicyBean.setMaximumRetransmissionCount(parameters.getMaximumRetransmissionCount());
            this.updatePolicy(axisService, sandeshaPolicyBean);
        }
    }

    private void updatePolicy(AxisService axisService, SandeshaPolicyBean sandeshaPolicyBean) throws AxisFault {
        Policy sandeshaPolicy = new Policy();
        sandeshaPolicy.setId(RM_POLICY_ID);
        sandeshaPolicy.setName(RM_POLICY_ID);
        sandeshaPolicy.addPolicyComponent((PolicyComponent)sandeshaPolicyBean);
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        boolean isProxyService = PersistenceUtils.isProxyService((AxisService)axisService);
        try {
            boolean registryTransactionStarted = true;
            registryTransactionStarted = Transaction.isStarted();
            if (isProxyService && !registryTransactionStarted) {
                this.registry.beginTransaction();
            }
            if (isProxyService) {
                String policyType = "3";
                String servicePath = PersistenceUtils.getRegistryResourcePath((AxisService)axisService);
                this.persistenceFactory.getServicePM().persistPolicyToRegistry(sandeshaPolicy, policyType, servicePath);
            }
            OMFactory omFactory = OMAbstractFactory.getOMFactory();
            OMElement policyWrapperEle = omFactory.createOMElement("policy", null);
            policyWrapperEle.addAttribute("policyType", String.valueOf(3), null);
            OMElement idElement = omFactory.createOMElement("policyUUID", null);
            idElement.setText(sandeshaPolicy.getId());
            policyWrapperEle.addChild((OMNode)idElement);
            OMElement policyEleToPersist = PersistenceUtils.createPolicyElement((Policy)sandeshaPolicy);
            policyWrapperEle.addChild((OMNode)policyEleToPersist);
            String serviceXPath = PersistenceUtils.getResourcePath((AxisService)axisService);
            boolean transactionStarted = this.serviceGroupFilePM.isTransactionStarted(serviceGroupId);
            if (!transactionStarted) {
                this.serviceGroupFilePM.beginTransaction(serviceGroupId);
            }
            if (!this.serviceGroupFilePM.elementExists(serviceGroupId, serviceXPath + "/" + "policies")) {
                this.serviceGroupFilePM.put(serviceGroupId, omFactory.createOMElement("policies", null), serviceXPath);
            } else {
                String pathToPolicy = serviceXPath + "/" + "policies" + "/" + "policy" + PersistenceUtils.getXPathTextPredicate((String)"policyUUID", (String)sandeshaPolicy.getId());
                if (this.serviceGroupFilePM.elementExists(serviceGroupId, pathToPolicy)) {
                    this.serviceGroupFilePM.delete(serviceGroupId, pathToPolicy);
                }
            }
            this.serviceGroupFilePM.put(serviceGroupId, policyWrapperEle, serviceXPath + "/" + "policies");
            if (!this.serviceGroupFilePM.elementExists(serviceGroupId, serviceXPath + PersistenceUtils.getXPathTextPredicate((String)"policyUUID", (String)sandeshaPolicy.getId()))) {
                this.serviceGroupFilePM.put(serviceGroupId, idElement.cloneOMElement(), serviceXPath);
            }
            if (!transactionStarted) {
                this.serviceGroupFilePM.commitTransaction(serviceGroupId);
            }
            if (isProxyService && !registryTransactionStarted) {
                this.registry.commitTransaction();
            }
        }
        catch (PersistenceException e) {
            log.error((Object)"Problem when setting parameter values", (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            if (isProxyService) {
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException re) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            throw new AxisFault("Problem when setting parameter values");
        }
        catch (Exception e) {
            log.error((Object)"Problem when setting parameter values", (Throwable)e);
            this.serviceGroupFilePM.rollbackTransaction(serviceGroupId);
            if (isProxyService) {
                try {
                    this.registry.rollbackTransaction();
                }
                catch (RegistryException re) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            throw new AxisFault("Problem when setting parameter values");
        }
    }

    public RMParameterBean getParameters(String serviceName) throws AxisFault {
        AxisConfiguration axisConfiguration = this.getAxisConfig();
        AxisService axisService = axisConfiguration.getServiceForActivation(serviceName);
        RMParameterBean rmParameterBean = new RMParameterBean();
        Parameter sandeshaPolicyBeanParameter = axisService.getParameter("Sandesha2PropertyBean");
        if (sandeshaPolicyBeanParameter != null) {
            SandeshaPolicyBean sandeshaPolicyBean = (SandeshaPolicyBean)sandeshaPolicyBeanParameter.getValue();
            rmParameterBean.setInactivityTimeoutInterval(sandeshaPolicyBean.getInactivityTimeoutInterval() / 1000L);
            rmParameterBean.setInactivityTimeoutMeasure("seconds");
            rmParameterBean.setSequenceRemovalTimeoutInterval(sandeshaPolicyBean.getSequenceRemovalTimeoutInterval() / 1000L);
            rmParameterBean.setSequenceRemovalTimeoutMeasure("seconds");
            rmParameterBean.setAcknowledgementInterval(sandeshaPolicyBean.getAcknowledgementInterval());
            rmParameterBean.setRetransmissionInterval(sandeshaPolicyBean.getRetransmissionInterval());
            rmParameterBean.setExponentialBackoff(sandeshaPolicyBean.isExponentialBackoff());
            rmParameterBean.setMaximumRetransmissionCount(sandeshaPolicyBean.getMaximumRetransmissionCount());
        }
        return rmParameterBean;
    }

    public void ConfigurePermenentStorage(String connectionString, String driver, String userName, String password) throws AxisFault {
        ConfigurationContext configurationContext = this.getConfigContext();
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        ModuleConfiguration moduleConfiguration = new ModuleConfiguration("sandesha2", null);
        moduleConfiguration.addParameter(new Parameter("db.connectionstring", (Object)connectionString));
        moduleConfiguration.addParameter(new Parameter("db.driver", (Object)driver));
        moduleConfiguration.addParameter(new Parameter("db.user", (Object)userName));
        moduleConfiguration.addParameter(new Parameter("db.password", (Object)password));
        axisConfiguration.addModuleConfig(moduleConfiguration);
        AxisModule sandeshaModule = axisConfiguration.getModule("sandesha2");
        PersistentStorageManager persistentStorageManager = new PersistentStorageManager(configurationContext);
        persistentStorageManager.initStorage(sandeshaModule);
        Parameter permenentStorage = axisConfiguration.getParameter("persistent");
        if (permenentStorage != null) {
            axisConfiguration.removeParameter(permenentStorage);
        }
        axisConfiguration.addParameter("persistent", (Object)persistentStorageManager);
    }
}

