/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rm.global;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.storage.jdbc.PersistentStorageManager;
import org.jaxen.JaxenException;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.persistence.ModulePersistenceManager;
import org.wso2.carbon.core.persistence.PersistenceException;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.rm.global.RMParameterBean;

public class RMAdminGlobal
extends AbstractAdmin {
    public void setParameters(RMParameterBean parameters) throws AxisFault {
        Parameter storageManagerParameter;
        ConfigurationContext configurationContext = this.getConfigContext();
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        AxisModule sandeshaModule = axisConfiguration.getModule("sandesha2");
        String moduleVersion = sandeshaModule.getVersion().toString();
        if (moduleVersion == null) {
            moduleVersion = "undefined";
        }
        String moduleResourcePath = PersistenceUtils.getResourcePath((AxisModule)sandeshaModule);
        this.updateParameter(moduleResourcePath, "db.connectionstring", parameters.getConnectionString(), sandeshaModule);
        this.updateParameter(moduleResourcePath, "db.driver", parameters.getDriverName(), sandeshaModule);
        this.updateParameter(moduleResourcePath, "db.user", parameters.getUserName(), sandeshaModule);
        this.updateParameter(moduleResourcePath, "db.password", parameters.getPassword(), sandeshaModule);
        SandeshaPolicyBean sandeshaPolicyBean = (SandeshaPolicyBean)axisConfiguration.getParameter("Sandesha2PropertyBean").getValue();
        sandeshaPolicyBean.setInactiveTimeoutInterval(parameters.getInactivityTimeoutInterval(), parameters.getInactivityTimeoutMeasure());
        sandeshaPolicyBean.setSequenceRemovalTimeoutInterval(parameters.getSequenceRemovalTimeoutInterval(), parameters.getSequenceRemovalTimeoutMeasure());
        sandeshaPolicyBean.setSequenceRemovalTimeoutMeasure(parameters.getSequenceRemovalTimeoutMeasure());
        sandeshaPolicyBean.setAcknowledgementInterval(parameters.getAcknowledgementInterval());
        sandeshaPolicyBean.setRetransmissionInterval(parameters.getRetransmissionInterval());
        sandeshaPolicyBean.setExponentialBackoff(parameters.isExponentialBackoff());
        sandeshaPolicyBean.setMaximumRetransmissionCount(parameters.getMaximumRetransmissionCount());
        if (parameters.getStorageManager() != null && parameters.getStorageManager().equals("persistent")) {
            sandeshaPolicyBean.setPermanentStorageManagerClass(PersistentStorageManager.class.getName());
            PersistentStorageManager persistentStorageManager = new PersistentStorageManager(configurationContext);
            persistentStorageManager.initStorage(sandeshaModule);
            Parameter permenentStorage = axisConfiguration.getParameter("persistent");
            if (permenentStorage != null) {
                axisConfiguration.removeParameter(permenentStorage);
            }
            axisConfiguration.addParameter("persistent", (Object)persistentStorageManager);
        }
        if ((storageManagerParameter = axisConfiguration.getParameter("Sandesha2StorageManager")) != null) {
            axisConfiguration.removeParameter(storageManagerParameter);
        }
        axisConfiguration.addParameter("Sandesha2StorageManager", (Object)parameters.getStorageManager());
        MessageContext.getCurrentMessageContext().getConfigurationContext().setProperty("storageManagerInstance", null);
        this.updateParameter(moduleResourcePath, "Sandesha2StorageManager", parameters.getStorageManager(), sandeshaModule);
        this.updatePolicy(moduleResourcePath, sandeshaModule, sandeshaPolicyBean);
    }

    public RMParameterBean getParameters() throws AxisFault {
        AxisConfiguration axisConfiguration = this.getAxisConfig();
        AxisModule sandeshaModule = axisConfiguration.getModule("sandesha2");
        RMParameterBean rmParameterBean = new RMParameterBean();
        rmParameterBean.setConnectionString(this.getParameterValue("db.connectionstring", (ParameterInclude)sandeshaModule));
        rmParameterBean.setDriverName(this.getParameterValue("db.driver", (ParameterInclude)sandeshaModule));
        rmParameterBean.setPassword(this.getParameterValue("db.password", (ParameterInclude)sandeshaModule));
        rmParameterBean.setUserName(this.getParameterValue("db.user", (ParameterInclude)sandeshaModule));
        Parameter sandeshaPolicyBeanParameter = axisConfiguration.getParameter("Sandesha2PropertyBean");
        if (sandeshaPolicyBeanParameter != null) {
            SandeshaPolicyBean sandeshaPolicyBean = (SandeshaPolicyBean)sandeshaPolicyBeanParameter.getValue();
            rmParameterBean.setInactivityTimeoutInterval(sandeshaPolicyBean.getInactivityTimeoutInterval() / 1000L);
            rmParameterBean.setInactivityTimeoutMeasure("seconds");
            rmParameterBean.setSequenceRemovalTimeoutInterval(sandeshaPolicyBean.getSequenceRemovalTimeoutInterval() / 1000L);
            rmParameterBean.setSequenceRemovalTimeoutMeasure("seconds");
            rmParameterBean.setAcknowledgementInterval(sandeshaPolicyBean.getAcknowledgementInterval());
            rmParameterBean.setRetransmissionInterval(sandeshaPolicyBean.getRetransmissionInterval());
            rmParameterBean.setExponentialBackoff(sandeshaPolicyBean.isExponentialBackoff());
            rmParameterBean.setMaximumRetransmissionCount(sandeshaPolicyBean.getMaximumRetransmissionCount());
        }
        if (axisConfiguration.getParameter("Sandesha2StorageManager") != null) {
            rmParameterBean.setStorageManager((String)axisConfiguration.getParameter("Sandesha2StorageManager").getValue());
        }
        return rmParameterBean;
    }

    private String getParameterValue(String parameterName, ParameterInclude parameterInclude) {
        String parameterValue = null;
        if (parameterInclude.getParameter(parameterName) != null) {
            parameterValue = (String)parameterInclude.getParameter(parameterName).getValue();
        }
        return parameterValue;
    }

    private void updateParameter(String moduleResourcePath, String paramName, String paramValue, AxisModule axisModule) throws AxisFault {
        if (axisModule.getParameter(paramName) != null) {
            Parameter param = axisModule.getParameter(paramName);
            param.setValue((Object)paramValue);
        } else {
            axisModule.addParameter(new Parameter(paramName, (Object)paramValue));
        }
        PersistenceFactory persistenceFactory = PersistenceFactory.getInstance((AxisConfiguration)this.getAxisConfig());
        ModulePersistenceManager mpm = persistenceFactory.getModulePM();
        Parameter parameter = new Parameter(paramName, (Object)paramValue);
        try {
            mpm.updateParameter(axisModule.getName(), parameter, moduleResourcePath);
        }
        catch (PersistenceException e) {
            throw new AxisFault("Problem when setting parameter values", (Throwable)e);
        }
        catch (Exception e) {
            throw new AxisFault("Problem when setting parameter values", (Throwable)e);
        }
    }

    private void updatePolicy(String moduleResourcePath, AxisModule sandeshaModule, SandeshaPolicyBean sandeshaPolicyBean) throws AxisFault {
        Policy sandeshaPolicy = new Policy();
        sandeshaPolicy.setId("RMPolicy");
        sandeshaPolicy.setName("RMPolicy");
        sandeshaPolicy.addPolicyComponent((PolicyComponent)sandeshaPolicyBean);
        try {
            PersistenceFactory pf = PersistenceFactory.getInstance((AxisConfiguration)this.getAxisConfig());
            pf.getModulePM().persistModulePolicy(sandeshaModule.getName(), sandeshaModule.getVersion().toString(), sandeshaPolicy, sandeshaPolicy.getId(), String.valueOf(2), PersistenceUtils.getResourcePath((AxisModule)sandeshaModule));
        }
        catch (PersistenceException e) {
            throw new AxisFault("Problem when persisting updated policy");
        }
        catch (JaxenException e) {
            throw new AxisFault("Problem when persisting updated policy");
        }
        catch (Exception e) {
            throw new AxisFault("Problem when persisting updated policy");
        }
    }
}

