/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.storage.jdbc.PersistentBeanMgr;
import org.apache.sandesha2.storage.jdbc.PersistentStorageManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentSenderBeanMgr
extends PersistentBeanMgr
implements SenderBeanMgr {
    public PersistentSenderBeanMgr(PersistentStorageManager pmgr) {
        super(pmgr);
    }

    private String requestForModel(SenderBean bean) {
        StringBuilder sql = new StringBuilder("select * from wsrm_sender");
        if (bean == null) {
            return sql.toString();
        }
        String op = " where ";
        String clause = bean.getSequenceID();
        if (clause != null) {
            sql.append(op);
            op = " and ";
            sql.append(" sequence_id='");
            sql.append(clause);
            sql.append("'");
        }
        if ((clause = bean.getMessageID()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" message_id='");
            sql.append(clause);
            sql.append("'");
        }
        if ((clause = bean.getMessageContextRefKey()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" message_context_ref_key='");
            sql.append(clause);
            sql.append("'");
        }
        if ((clause = bean.getInternalSequenceID()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" internal_sequence_id='");
            sql.append(clause);
            sql.append("'");
        }
        if ((clause = bean.getToAddress()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" to_address='");
            sql.append(clause);
            sql.append("'");
        }
        if ((clause = bean.getInboundSequenceId()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" inbound_sequence_id='");
            sql.append(clause);
            sql.append("'");
        }
        if ((bean.getFlags() & 1) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" send=");
            sql.append(bean.isSend() ? 1 : 0);
        }
        if ((bean.getFlags() & 0x10) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" sent_count=");
            sql.append(bean.getSentCount());
        }
        if ((bean.getFlags() & 0x100) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" message_number=");
            sql.append(bean.getMessageNumber());
        }
        if ((bean.getFlags() & 0x1000) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" resend=");
            sql.append(bean.isReSend() ? 1 : 0);
        }
        if ((bean.getFlags() & 0x10000) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" time_to_send<=");
            sql.append(bean.getTimeToSend());
        }
        if ((bean.getFlags() & 0x100000) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" message_type=");
            sql.append(bean.getMessageType());
        }
        if ((bean.getFlags() & 0x1000000) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" last_message=");
            sql.append(bean.isLastMessage() ? 1 : 0);
        }
        if ((bean.getFlags() & 0x10000000) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" inbound_message_number=");
            sql.append(bean.getInboundMessageNumber());
        }
        if ((bean.getFlags() & 2) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" transport_available=");
            sql.append(bean.isTransportAvailable() ? 1 : 0);
        }
        this.log.debug((Object)("requestForModel " + sql.toString()));
        return sql.toString();
    }

    private SenderBean getBean(ResultSet rs) throws Exception {
        SenderBean bean = new SenderBean();
        bean.setMessageID(rs.getString("message_id"));
        bean.setMessageContextRefKey(rs.getString("message_context_ref_key"));
        bean.setSequenceID(rs.getString("sequence_id"));
        bean.setInternalSequenceID(rs.getString("internal_sequence_id"));
        bean.setToAddress(rs.getString("to_address"));
        bean.setInboundSequenceId(rs.getString("inbound_sequence_id"));
        bean.setMessageNumber(rs.getLong("message_number"));
        bean.setTimeToSend(rs.getLong("time_to_send"));
        bean.setInboundMessageNumber(rs.getLong("inbound_message_number"));
        bean.setSend(rs.getInt("send") != 0);
        bean.setReSend(rs.getInt("resend") != 0);
        bean.setLastMessage(rs.getInt("last_message") != 0);
        bean.setTransportAvailable(rs.getInt("transport_available") != 0);
        bean.setSentCount(rs.getInt("sent_count"));
        bean.setMessageType(rs.getInt("message_type"));
        bean.setFlags(rs.getInt("flags"));
        return bean;
    }

    @Override
    public boolean delete(String messageID) throws SandeshaStorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Delete MsgID " + messageID));
        }
        try {
            Statement stmt = this.getDbConnection().createStatement();
            stmt.executeUpdate("delete from wsrm_sender where message_id='" + messageID + "'");
            stmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException(ex);
        }
        return true;
    }

    @Override
    public List<SenderBean> find(SenderBean bean) throws SandeshaStorageException {
        String sql = this.requestForModel(bean);
        ArrayList<SenderBean> lst = new ArrayList<SenderBean>();
        try {
            Statement stmt = this.getDbConnection().createStatement(1003, 1008);
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                lst.add(this.getBean(rs));
            }
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException(ex);
        }
        return lst;
    }

    @Override
    public List<SenderBean> find(String internalSequenceId) throws SandeshaStorageException {
        ArrayList<SenderBean> lst = new ArrayList<SenderBean>();
        try {
            Statement stmt = this.getDbConnection().createStatement(1003, 1008);
            ResultSet rs = stmt.executeQuery("select * from wsrm_sender where internal_sequence_id='" + internalSequenceId + "'");
            while (rs.next()) {
                lst.add(this.getBean(rs));
            }
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException(ex);
        }
        return lst;
    }

    @Override
    public SenderBean getNextMsgToSend(String sequenceId) throws SandeshaStorageException {
        SenderBean result = null;
        try {
            Statement stmt = this.getDbConnection().createStatement();
            String sql = "select * from wsrm_sender where sequence_id";
            sql = sequenceId == null ? sql + " is null " : sql + "='" + sequenceId + "' ";
            sql = sql + "and transport_available=1 and send=1";
            this.log.debug((Object)("getNextMsgToSend " + sql));
            ResultSet rs = stmt.executeQuery(sql);
            long timeNow = System.currentTimeMillis();
            this.log.debug((Object)("getNextMsgToSend timeNow " + timeNow));
            while (rs.next()) {
                if (timeNow < rs.getLong("time_to_send")) continue;
                result = this.getBean(rs);
                break;
            }
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            this.log.error((Object)("getNextMsgToSend Exception" + ex));
            throw new SandeshaStorageException(ex);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Exit getNextMessageToSend " + result));
        }
        return result;
    }

    @Override
    public boolean insert(SenderBean bean) throws SandeshaStorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Insert " + bean));
        }
        try {
            PreparedStatement pstmt = this.getDbConnection().prepareStatement("insert into wsrm_sender(message_id, message_context_ref_key, internal_sequence_id, sequence_id,to_address, inbound_sequence_id, send, sent_count, message_number, resend,time_to_send, message_type, last_message, inbound_message_number, transport_available,flags)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            pstmt.setString(1, bean.getMessageID());
            pstmt.setString(2, bean.getMessageContextRefKey());
            pstmt.setString(3, bean.getInternalSequenceID());
            pstmt.setString(4, bean.getSequenceID());
            pstmt.setString(5, bean.getToAddress());
            pstmt.setString(6, bean.getInboundSequenceId());
            pstmt.setInt(7, bean.isSend() ? 1 : 0);
            pstmt.setInt(8, bean.getSentCount());
            pstmt.setLong(9, bean.getMessageNumber());
            pstmt.setInt(10, bean.isReSend() ? 1 : 0);
            pstmt.setLong(11, bean.getTimeToSend());
            pstmt.setInt(12, bean.getMessageType());
            pstmt.setInt(13, bean.isLastMessage() ? 1 : 0);
            pstmt.setLong(14, bean.getInboundMessageNumber());
            pstmt.setInt(15, bean.isTransportAvailable() ? 1 : 0);
            pstmt.setInt(16, bean.getFlags());
            pstmt.execute();
            pstmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException(ex);
        }
        return true;
    }

    @Override
    public SenderBean retrieve(String messageID) throws SandeshaStorageException {
        SenderBean bean = null;
        try {
            Statement stmt = this.getDbConnection().createStatement(1003, 1008);
            ResultSet rs = stmt.executeQuery("select * from wsrm_sender where message_id='" + messageID + "'");
            if (!rs.next()) {
                return bean;
            }
            bean = this.getBean(rs);
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException(ex);
        }
        return bean;
    }

    @Override
    public boolean update(SenderBean bean) throws SandeshaStorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Update " + bean));
        }
        try {
            PreparedStatement pstmt = this.getDbConnection().prepareStatement("update wsrm_sender set message_context_ref_key=?, internal_sequence_id=?, sequence_id=?,to_address=?, inbound_sequence_id=?, send=?, sent_count=?, message_number=?, resend=?,time_to_send=?, message_type=?, last_message=?, inbound_message_number=?, transport_available=?,flags=? where message_id='" + bean.getMessageID() + "'");
            pstmt.setString(1, bean.getMessageContextRefKey());
            pstmt.setString(2, bean.getInternalSequenceID());
            pstmt.setString(3, bean.getSequenceID());
            pstmt.setString(4, bean.getToAddress());
            pstmt.setString(5, bean.getInboundSequenceId());
            pstmt.setInt(6, bean.isSend() ? 1 : 0);
            pstmt.setInt(7, bean.getSentCount());
            pstmt.setLong(8, bean.getMessageNumber());
            pstmt.setInt(9, bean.isReSend() ? 1 : 0);
            pstmt.setLong(10, bean.getTimeToSend());
            pstmt.setInt(11, bean.getMessageType());
            pstmt.setInt(12, bean.isLastMessage() ? 1 : 0);
            pstmt.setLong(13, bean.getInboundMessageNumber());
            pstmt.setInt(14, bean.isTransportAvailable() ? 1 : 0);
            pstmt.setInt(15, bean.getFlags());
            pstmt.execute();
            pstmt.close();
        }
        catch (Exception ex) {
            this.log.error((Object)("Update Exception " + ex));
            throw new SandeshaStorageException(ex);
        }
        return true;
    }

    @Override
    public SenderBean findUnique(SenderBean bean) throws SandeshaStorageException {
        String sql = this.requestForModel(bean);
        SenderBean result = null;
        try {
            Statement stmt = this.getDbConnection().createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (result == null) {
                    result = this.getBean(rs);
                    continue;
                }
                String message = SandeshaMessageHelper.getMessage("nonUniqueResult", result.toString(), this.getBean(rs).toString());
                this.log.error((Object)message);
                throw new SandeshaException(message);
            }
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException(ex);
        }
        return result;
    }

    @Override
    public SenderBean retrieveFromMessageRefKey(String messageContextRefKey) {
        SenderBean bean = null;
        try {
            Statement stmt = this.getDbConnection().createStatement(1003, 1008);
            ResultSet rs = stmt.executeQuery("select * from wsrm_sender where message_context_ref_key='" + messageContextRefKey + "'");
            if (!rs.next()) {
                return bean;
            }
            bean = this.getBean(rs);
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            return null;
        }
        return bean;
    }

    @Override
    public SenderBean retrieve(String sequnceId, long messageNumber) throws SandeshaStorageException {
        SenderBean bean = null;
        try {
            Statement stmt = this.getDbConnection().createStatement(1003, 1008);
            ResultSet rs = stmt.executeQuery("select * from wsrm_sender where sequence_id='" + sequnceId + "' " + " and message_number=" + messageNumber);
            if (!rs.next()) {
                return bean;
            }
            bean = this.getBean(rs);
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            return null;
        }
        return bean;
    }
}

