/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.jdbc.PersistentBeanMgr;
import org.apache.sandesha2.storage.jdbc.PersistentStorageManager;
import org.apache.sandesha2.util.RangeString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentRMSBeanMgr
extends PersistentBeanMgr
implements RMSBeanMgr {
    public PersistentRMSBeanMgr(PersistentStorageManager pmgr) {
        super(pmgr);
    }

    private String requestForModel(RMSBean bean) {
        RangeString xrs;
        EndpointReference epr;
        StringBuilder sql = new StringBuilder(" select * from wsrm_rms");
        if (bean == null) {
            return sql.toString();
        }
        String op = " where ";
        String clause = bean.getSequenceID();
        if (clause != null) {
            sql.append(op);
            op = " and ";
            sql.append(" sequence_id='");
            sql.append(clause);
            sql.append("'");
        }
        if ((epr = bean.getToEndpointReference()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" to_epr_addr='");
            sql.append(epr.getAddress());
            sql.append("'");
        }
        if ((epr = bean.getReplyToEndpointReference()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" reply_to_epr_addr='");
            sql.append(epr.getAddress());
            sql.append("'");
        }
        if ((epr = bean.getAcksToEndpointReference()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" acks_to_epr_addr='");
            sql.append(epr.getAddress());
            sql.append("'");
        }
        if ((clause = bean.getRMVersion()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" rm_version='");
            sql.append(clause);
            sql.append("'");
        }
        if ((clause = bean.getSecurityTokenData()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" security_token_data='");
            sql.append(clause);
            sql.append("'");
        }
        if ((clause = bean.getCreateSeqMsgID()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" create_seq_msg_id='");
            sql.append(clause);
            sql.append("'");
        }
        if ((clause = bean.getInternalSequenceID()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" internal_sequence_id='");
            sql.append(clause);
            sql.append("'");
        }
        if ((clause = bean.getCreateSequenceMsgStoreKey()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" create_sequence_msg_store_key='");
            sql.append(clause);
            sql.append("'");
        }
        if ((clause = bean.getReferenceMessageStoreKey()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" create_sequence_msg_store_key='");
            sql.append(clause);
            sql.append("'");
        }
        if ((clause = bean.getTransportTo()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" transport_to='");
            sql.append(clause);
            sql.append("'");
        }
        if ((clause = bean.getOfferedEndPoint()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" offered_endpoint='");
            sql.append(clause);
            sql.append("'");
        }
        if ((epr = bean.getOfferedEndPointEPR()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" offered_endpoint_epr_addr='");
            sql.append(epr.getAddress());
            sql.append("'");
        }
        if ((clause = bean.getOfferedSequence()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" offered_sequence='");
            sql.append(clause);
            sql.append("'");
        }
        if ((clause = bean.getAnonymousUUID()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" anonymous_uuid='");
            sql.append(clause);
            sql.append("'");
        }
        if ((xrs = bean.getClientCompletedMessages()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" client_completed_messages='");
            sql.append(xrs.toString());
            sql.append("'");
        }
        if ((clause = bean.getInternalSeqIDOfSeqUsedForReallocation()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" internalSeqIDOfSeqUsedForReallocation='");
            sql.append(clause);
            sql.append("'");
        }
        if ((bean.getRmsFlags() & 1) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" last_send_error_timestamp=");
            sql.append(bean.getLastSendErrorTimestamp());
        }
        if ((bean.getRmsFlags() & 0x10) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" last_out_message=");
            sql.append(bean.getLastOutMessage());
        }
        if ((bean.getRmsFlags() & 0x100) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" highest_out_message_number=");
            sql.append(bean.getHighestOutMessageNumber());
        }
        if ((bean.getRmsFlags() & 0x1000) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" next_message_number=");
            sql.append(bean.getNextMessageNumber());
        }
        if ((bean.getRmsFlags() & 0x10000) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" terminate_added=");
            sql.append(bean.isTerminateAdded() ? 1 : 0);
        }
        if ((bean.getRmsFlags() & 0x100000) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" timed_out=");
            sql.append(bean.isTimedOut() ? 1 : 0);
        }
        if ((bean.getRmsFlags() & 0x1000000) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" sequence_closed_client=");
            sql.append(bean.isSequenceClosedClient() ? 1 : 0);
        }
        if ((bean.getRmsFlags() & 2) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" termination_pauser_for_cs=");
            sql.append(bean.isTerminationPauserForCS() ? 1 : 0);
        }
        if ((bean.getRmsFlags() & 0x20) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" expected_replies=");
            sql.append(bean.getExpectedReplies());
        }
        if ((bean.getRmsFlags() & 0x200) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" soap_version=");
            sql.append(bean.getSoapVersion());
        }
        if ((bean.getFlags() & 1) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" last_activated_time=");
            sql.append(bean.getLastActivatedTime());
        }
        if ((bean.getFlags() & 0x10) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" closed=");
            sql.append(bean.isClosed() ? 1 : 0);
        }
        if ((bean.getFlags() & 0x100) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" terminated_flag=");
            sql.append(bean.isTerminated() ? 1 : 0);
        }
        if ((bean.getFlags() & 0x1000) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" polling_mode=");
            sql.append(bean.isPollingMode() ? 1 : 0);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("requestForModel " + sql.toString()));
        }
        return sql.toString();
    }

    private RMSBean getBean(ResultSet rs) throws Exception {
        RMSBean bean = new RMSBean();
        bean.setSequenceID(rs.getString("sequence_id"));
        Object obj = this.getObject(rs, "to_epr");
        if (obj != null) {
            bean.setToEndpointReference((EndpointReference)obj);
        }
        if ((obj = this.getObject(rs, "reply_to_epr")) != null) {
            bean.setReplyToEndpointReference((EndpointReference)obj);
        }
        if ((obj = this.getObject(rs, "acks_to_epr")) != null) {
            bean.setAcksToEndpointReference((EndpointReference)obj);
        }
        if ((obj = this.getObject(rs, "offered_endpoint_epr")) != null) {
            bean.setOfferedEndPointEPR((EndpointReference)obj);
        }
        bean.setRMVersion(rs.getString("rm_version"));
        bean.setServiceName(rs.getString("service_name"));
        bean.setSecurityTokenData(rs.getString("security_token_data"));
        bean.setCreateSeqMsgID(rs.getString("create_seq_msg_id"));
        bean.setTransportTo(rs.getString("transport_to"));
        bean.setOfferedEndPoint(rs.getString("offered_endpoint"));
        bean.setOfferedSequence(rs.getString("offered_sequence"));
        bean.setAnonymousUUID(rs.getString("anonymous_uuid"));
        bean.setInternalSequenceID(rs.getString("internal_sequence_id"));
        bean.setReferenceMessageStoreKey(rs.getString("reference_msg_store_key"));
        bean.setCreateSequenceMsgStoreKey(rs.getString("create_sequence_msg_store_key"));
        bean.setHighestOutRelatesTo(rs.getString("highest_out_relates_to"));
        obj = this.getObject(rs, "last_send_error");
        if (obj != null) {
            bean.setLastSendError((Exception)obj);
        }
        bean.setClientCompletedMessages(new RangeString(rs.getString("client_completed_messages")));
        bean.setLastSendErrorTimestamp(rs.getLong("last_send_error_timestamp"));
        bean.setLastOutMessage(rs.getLong("last_out_message"));
        bean.setHighestOutMessageNumber(rs.getLong("highest_out_message_number"));
        bean.setNextMessageNumber(rs.getLong("next_message_number"));
        bean.setLastActivatedTime(rs.getLong("last_activated_time"));
        bean.setExpectedReplies(rs.getLong("expected_replies"));
        bean.setClosed(rs.getInt("closed") != 0);
        bean.setPollingMode(rs.getInt("polling_mode") != 0);
        bean.setTerminated(rs.getInt("terminated_flag") != 0);
        bean.setTerminateAdded(rs.getInt("terminate_added") != 0);
        bean.setTimedOut(rs.getInt("timed_out") != 0);
        bean.setSequenceClosedClient(rs.getInt("sequence_closed_client") != 0);
        bean.setTerminationPauserForCS(rs.getInt("termination_pauser_for_cs") != 0);
        bean.setAvoidAutoTermination(rs.getInt("avoid_auto_termination") != 0);
        bean.setSoapVersion(rs.getInt("soap_version"));
        bean.setFlags(rs.getInt("flags"));
        bean.setRmsFlags(rs.getInt("rms_flags"));
        bean.setReallocated(rs.getInt("reallocated"));
        bean.setInternalSeqIDOfSeqUsedForReallocation(rs.getString("internalSeqIDOfSeqUsedForReallocation"));
        return bean;
    }

    @Override
    public boolean delete(String msgId) throws SandeshaStorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("delete RMSBean msgId " + msgId));
        }
        try {
            Statement stmt = this.getDbConnection().createStatement();
            stmt.executeUpdate("delete from wsrm_rms where create_seq_msg_id='" + msgId + "'");
            stmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException("Exception in RMSBeanMgr delete", ex);
        }
        return true;
    }

    @Override
    public List<RMSBean> find(RMSBean bean) throws SandeshaStorageException {
        String sql = this.requestForModel(bean);
        ArrayList<RMSBean> lst = new ArrayList<RMSBean>();
        try {
            Statement stmt = this.getDbConnection().createStatement(1003, 1008);
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                lst.add(this.getBean(rs));
            }
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException("Exception in RMSBeanMgr find : " + sql, ex);
        }
        return lst;
    }

    @Override
    public boolean insert(RMSBean bean) throws SandeshaStorageException {
        this.log.debug((Object)("insert RMSBean " + bean));
        try {
            PreparedStatement pstmt = this.getDbConnection().prepareStatement("insert into wsrm_rms(create_seq_msg_id,sequence_id,to_epr_addr,to_epr,reply_to_epr_addr,reply_to_epr,acks_to_epr_addr,acks_to_epr,rm_version,security_token_data,last_activated_time,closed,terminated_flag,polling_mode,service_name,flags,id,internal_sequence_id,create_sequence_msg_store_key,reference_msg_store_key,last_send_error,highest_out_relates_to,client_completed_messages,transport_to,offered_endpoint,offered_sequence,anonymous_uuid,last_send_error_timestamp,last_out_message,highest_out_message_number,next_message_number,terminate_added,timed_out,sequence_closed_client,expected_replies,soap_version,termination_pauser_for_cs,avoid_auto_termination,rms_flags,offered_endpoint_epr_addr,offered_endpoint_epr,reallocated,internalSeqIDOfSeqUsedForReallocation)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            pstmt.setString(1, bean.getCreateSeqMsgID());
            pstmt.setString(2, bean.getSequenceID());
            EndpointReference epr = bean.getToEndpointReference();
            pstmt.setString(3, epr != null ? epr.getAddress() : null);
            ByteArrayInputStream bais = this.serialize(epr);
            pstmt.setBinaryStream(4, (InputStream)bais, bais.available());
            epr = bean.getReplyToEndpointReference();
            pstmt.setString(5, epr != null ? epr.getAddress() : null);
            bais = this.serialize(epr);
            pstmt.setBinaryStream(6, (InputStream)bais, bais.available());
            epr = bean.getAcksToEndpointReference();
            pstmt.setString(7, epr != null ? epr.getAddress() : null);
            bais = this.serialize(epr);
            pstmt.setBinaryStream(8, (InputStream)bais, bais.available());
            pstmt.setString(9, bean.getRMVersion());
            pstmt.setString(10, bean.getSecurityTokenData());
            pstmt.setLong(11, bean.getLastActivatedTime());
            pstmt.setInt(12, bean.isClosed() ? 1 : 0);
            pstmt.setInt(13, bean.isTerminated() ? 1 : 0);
            pstmt.setInt(14, bean.isPollingMode() ? 1 : 0);
            pstmt.setString(15, bean.getServiceName());
            pstmt.setInt(16, bean.getFlags());
            pstmt.setLong(17, bean.getId());
            pstmt.setString(18, bean.getInternalSequenceID());
            pstmt.setString(19, bean.getCreateSequenceMsgStoreKey());
            pstmt.setString(20, bean.getReferenceMessageStoreKey());
            bais = this.serialize(bean.getLastSendError());
            pstmt.setBinaryStream(21, (InputStream)bais, bais.available());
            pstmt.setString(22, bean.getHighestOutRelatesTo());
            RangeString rs = bean.getClientCompletedMessages();
            pstmt.setString(23, rs != null ? rs.toString() : null);
            pstmt.setString(24, bean.getTransportTo());
            pstmt.setString(25, bean.getOfferedEndPoint());
            pstmt.setString(26, bean.getOfferedSequence());
            pstmt.setString(27, bean.getAnonymousUUID());
            pstmt.setLong(28, bean.getLastSendErrorTimestamp());
            pstmt.setLong(29, bean.getLastOutMessage());
            pstmt.setLong(30, bean.getHighestOutMessageNumber());
            pstmt.setLong(31, bean.getNextMessageNumber());
            pstmt.setInt(32, bean.isTerminateAdded() ? 1 : 0);
            pstmt.setInt(33, bean.isTimedOut() ? 1 : 0);
            pstmt.setInt(34, bean.isSequenceClosedClient() ? 1 : 0);
            pstmt.setLong(35, bean.getExpectedReplies());
            pstmt.setInt(36, bean.getSoapVersion());
            pstmt.setInt(37, bean.isTerminationPauserForCS() ? 1 : 0);
            pstmt.setInt(38, bean.isAvoidAutoTermination() ? 1 : 0);
            pstmt.setInt(39, bean.getRmsFlags());
            epr = bean.getOfferedEndPointEPR();
            pstmt.setString(40, epr != null ? epr.getAddress() : null);
            bais = this.serialize(epr);
            pstmt.setBinaryStream(41, (InputStream)bais, bais.available());
            pstmt.setInt(42, bean.isReallocated());
            pstmt.setString(43, bean.getInternalSeqIDOfSeqUsedForReallocation());
            pstmt.execute();
            pstmt.close();
        }
        catch (Exception ex) {
            this.log.debug((Object)"Insert Exception  ", (Throwable)ex);
            throw new SandeshaStorageException("Exception in RMSBeanMgr insert", ex);
        }
        return true;
    }

    @Override
    public RMSBean retrieve(String msgId) throws SandeshaStorageException {
        this.log.debug((Object)("Retrieve  msdId " + msgId));
        RMSBean bean = null;
        try {
            Statement stmt = this.getDbConnection().createStatement(1003, 1008);
            ResultSet rs = stmt.executeQuery("select * from wsrm_rms where create_seq_msg_id='" + msgId + "'");
            if (rs.next()) {
                bean = this.getBean(rs);
            }
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            this.log.debug((Object)"Retrieve Exception  ", (Throwable)ex);
            throw new SandeshaStorageException("Exception in RMSBeanMgr retrieve", ex);
        }
        this.log.debug((Object)("Retrieve  return " + bean));
        return bean;
    }

    @Override
    public boolean update(RMSBean bean) throws SandeshaStorageException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Update bean : " + bean));
        }
        try {
            PreparedStatement pstmt = this.getDbConnection().prepareStatement("update wsrm_rms set sequence_id=?,to_epr_addr=?,to_epr=?,reply_to_epr_addr=?,reply_to_epr=?,acks_to_epr_addr=?,acks_to_epr=?,rm_version=?,security_token_data=?,last_activated_time=?,closed=?,terminated_flag=?,polling_mode=?,service_name=?,flags=?,id=?,internal_sequence_id=?,create_sequence_msg_store_key=?,reference_msg_store_key=?,last_send_error=?,highest_out_relates_to=?,client_completed_messages=?,transport_to=?,offered_endpoint=?,offered_sequence=?,anonymous_uuid=?,last_send_error_timestamp=?,last_out_message=?,highest_out_message_number=?,next_message_number=?,terminate_added=?,timed_out=?,sequence_closed_client=?,expected_replies=?,soap_version=?,termination_pauser_for_cs=?,avoid_auto_termination=?,rms_flags=? where create_seq_msg_id='" + bean.getCreateSeqMsgID() + "'");
            pstmt.setString(1, bean.getSequenceID());
            EndpointReference epr = bean.getToEndpointReference();
            pstmt.setString(2, epr != null ? epr.getAddress() : null);
            ByteArrayInputStream bais = this.serialize(epr);
            pstmt.setBinaryStream(3, (InputStream)bais, bais.available());
            epr = bean.getReplyToEndpointReference();
            pstmt.setString(4, epr != null ? epr.getAddress() : null);
            bais = this.serialize(epr);
            pstmt.setBinaryStream(5, (InputStream)bais, bais.available());
            epr = bean.getAcksToEndpointReference();
            pstmt.setString(6, epr != null ? epr.getAddress() : null);
            bais = this.serialize(epr);
            pstmt.setBinaryStream(7, (InputStream)bais, bais.available());
            pstmt.setString(8, bean.getRMVersion());
            pstmt.setString(9, bean.getSecurityTokenData());
            pstmt.setLong(10, bean.getLastActivatedTime());
            pstmt.setInt(11, bean.isClosed() ? 1 : 0);
            pstmt.setInt(12, bean.isTerminated() ? 1 : 0);
            pstmt.setInt(13, bean.isPollingMode() ? 1 : 0);
            pstmt.setString(14, bean.getServiceName());
            pstmt.setInt(15, bean.getFlags());
            pstmt.setLong(16, bean.getId());
            pstmt.setString(17, bean.getInternalSequenceID());
            pstmt.setString(18, bean.getCreateSequenceMsgStoreKey());
            pstmt.setString(19, bean.getReferenceMessageStoreKey());
            bais = this.serialize(bean.getLastSendError());
            pstmt.setBinaryStream(20, (InputStream)bais, bais.available());
            pstmt.setString(21, bean.getHighestOutRelatesTo());
            RangeString rs = bean.getClientCompletedMessages();
            pstmt.setString(22, rs != null ? rs.toString() : null);
            pstmt.setString(23, bean.getTransportTo());
            pstmt.setString(24, bean.getOfferedEndPoint());
            pstmt.setString(25, bean.getOfferedSequence());
            pstmt.setString(26, bean.getAnonymousUUID());
            pstmt.setLong(27, bean.getLastSendErrorTimestamp());
            pstmt.setLong(28, bean.getLastOutMessage());
            pstmt.setLong(29, bean.getHighestOutMessageNumber());
            pstmt.setLong(30, bean.getNextMessageNumber());
            pstmt.setInt(31, bean.isTerminateAdded() ? 1 : 0);
            pstmt.setInt(32, bean.isTimedOut() ? 1 : 0);
            pstmt.setInt(33, bean.isSequenceClosedClient() ? 1 : 0);
            pstmt.setLong(34, bean.getExpectedReplies());
            pstmt.setInt(35, bean.getSoapVersion());
            pstmt.setInt(36, bean.isTerminationPauserForCS() ? 1 : 0);
            pstmt.setInt(37, bean.isAvoidAutoTermination() ? 1 : 0);
            pstmt.setInt(38, bean.getRmsFlags());
            pstmt.execute();
            pstmt.close();
        }
        catch (Exception ex) {
            this.log.error((Object)("Update Exception " + ex));
            throw new SandeshaStorageException("Exception in RMSBeanMgr update", ex);
        }
        return true;
    }

    @Override
    public RMSBean findUnique(RMSBean bean) throws SandeshaStorageException {
        String sql = this.requestForModel(bean);
        RMSBean result = null;
        try {
            Statement stmt = this.getDbConnection().createStatement(1003, 1008);
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (result == null) {
                    result = this.getBean(rs);
                    continue;
                }
                String message = SandeshaMessageHelper.getMessage("nonUniqueResult", result.toString(), this.getBean(rs).toString());
                this.log.error((Object)message);
                throw new SandeshaException(message);
            }
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception in findUnique " + ex));
            throw new SandeshaStorageException("Exception in PersistentRMSBeanManager::findUnique", ex);
        }
        this.log.debug((Object)("FindUnique RMSBean : " + result));
        return result;
    }

    @Override
    public RMSBean retrieveBySequenceID(String seqId) throws SandeshaStorageException {
        RMSBean dummyBean = new RMSBean();
        dummyBean.setSequenceID(seqId);
        String sql = this.requestForModel(dummyBean);
        RMSBean result = null;
        try {
            Statement stmt = this.getDbConnection().createStatement(1003, 1008);
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (result == null) {
                    result = this.getBean(rs);
                    continue;
                }
                String message = SandeshaMessageHelper.getMessage("nonUniqueResult", result.toString(), this.getBean(rs).toString());
                this.log.error((Object)message);
                throw new SandeshaException(message);
            }
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception in findUnique " + ex));
            throw new SandeshaStorageException("Exception in PersistentRMSBeanManager::findUnique", ex);
        }
        this.log.debug((Object)("FindUnique RMSBean : " + result));
        return result;
    }

    @Override
    public RMSBean retrieveByInternalSequenceID(String internalSeqId) throws SandeshaStorageException {
        RMSBean dummyBean = new RMSBean();
        dummyBean.setInternalSequenceID(internalSeqId);
        String sql = this.requestForModel(dummyBean);
        RMSBean result = null;
        try {
            Statement stmt = this.getDbConnection().createStatement(1003, 1008);
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (result == null) {
                    result = this.getBean(rs);
                    continue;
                }
                String message = SandeshaMessageHelper.getMessage("nonUniqueResult", result.toString(), this.getBean(rs).toString());
                this.log.error((Object)message);
                throw new SandeshaException(message);
            }
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            this.log.error((Object)("Exception in findUnique " + ex));
            throw new SandeshaStorageException("Exception in PersistentRMSBeanManager::findUnique", ex);
        }
        this.log.debug((Object)("FindUnique RMSBean : " + result));
        return result;
    }
}

