/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rssmanager.core.service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.datasource.DataSourceInformation;
import org.apache.synapse.commons.datasource.factory.DataSourceInformationFactory;
import org.apache.synapse.commons.datasource.serializer.DataSourceInformationSerializer;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.datasource.DataSourceInformationManager;
import org.wso2.carbon.datasource.DataSourceManagementHandler;
import org.wso2.carbon.datasource.MiscellaneousHelper;
import org.wso2.carbon.rssmanager.common.RSSManagerCommonUtil;
import org.wso2.carbon.rssmanager.core.DBConnectionHandler;
import org.wso2.carbon.rssmanager.core.RSSDAOException;
import org.wso2.carbon.rssmanager.core.RSSManager;
import org.wso2.carbon.rssmanager.core.RSSManagerFactory;
import org.wso2.carbon.rssmanager.core.RSSManagerUtil;
import org.wso2.carbon.rssmanager.core.dao.RSSDAO;
import org.wso2.carbon.rssmanager.core.dao.RSSDAOFactory;
import org.wso2.carbon.rssmanager.core.description.DatabaseInstance;
import org.wso2.carbon.rssmanager.core.description.DatabaseInstanceEntry;
import org.wso2.carbon.rssmanager.core.description.DatabasePermissions;
import org.wso2.carbon.rssmanager.core.description.DatabaseUser;
import org.wso2.carbon.rssmanager.core.description.DatabaseUserEntry;
import org.wso2.carbon.rssmanager.core.description.PrivilegeGroup;
import org.wso2.carbon.rssmanager.core.description.RSSInstance;
import org.wso2.carbon.rssmanager.core.description.RSSInstanceEntry;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;
import org.wso2.securevault.secret.SecretInformation;

public class RSSAdmin
extends AbstractAdmin {
    private static final String RSS_MANAGER_EXTENSION_NS = "http://www.wso2.org/products/wso2commons/rssmanager";
    private static final OMFactory FACTORY = OMAbstractFactory.getOMFactory();
    private static final OMNamespace RSS_MANAGER_OM_NAMESPACE = FACTORY.createOMNamespace("http://www.wso2.org/products/wso2commons/rssmanager", "instance");
    private static final Log log = LogFactory.getLog(RSSAdmin.class);

    public void addRSSInstance(RSSInstance rssIns) throws RSSDAOException {
        if (RSSManagerUtil.isSuperTenant()) {
            if ("LOCAL".equals(rssIns.getServerCategory())) {
                rssIns.setInstanceType("WSO2_LOCAL_RDS");
            } else {
                rssIns.setInstanceType("WSO2_RSS");
            }
        }
        rssIns.setInstanceType("USER_DEFINED");
        RSSDAOFactory.getRSSDAO().addRSSInstance(rssIns);
    }

    public void removeRSSInstance(int rssInsId) throws RSSDAOException {
        String rmType = RSSManagerUtil.getDatabaseMgtSystemType(rssInsId);
        RSSManager rm = RSSManagerFactory.getRSSManager(rmType);
        RSSDAO dao = RSSDAOFactory.getRSSDAO();
        List<DatabaseInstance> dbs = dao.getAllDatabaseInstancesByRSSInstanceId(rssInsId);
        for (DatabaseInstance db : dbs) {
            if (db == null) continue;
            List<DatabaseUserEntry> users = dao.getUsersByDatabaseInstanceId(db.getDatabaseInstanceId());
            for (DatabaseUserEntry user : users) {
                if (user == null) continue;
                rm.dropUser(user.getUserId(), db.getDatabaseInstanceId());
            }
            rm.dropDatabase(db.getDatabaseInstanceId());
        }
        dao.deleteRSSInstance(rssInsId);
    }

    public void editRSSInstance(RSSInstance rssIns) throws RSSDAOException {
        if (RSSManagerUtil.isSuperTenant()) {
            if ("LOCAL".equals(rssIns.getServerCategory())) {
                rssIns.setInstanceType("WSO2_LOCAL_RDS");
            } else {
                rssIns.setInstanceType("WSO2_RSS");
            }
        }
        rssIns.setInstanceType("USER_DEFINED");
        RSSDAOFactory.getRSSDAO().updateRSSInstance(rssIns);
    }

    public RSSInstance getRSSInstanceDataById(int rssInsId) throws RSSDAOException {
        return RSSDAOFactory.getRSSDAO().getRSSInstanceDataById(rssInsId);
    }

    public RSSInstanceEntry[] getRSSInstanceList() throws RSSDAOException {
        RSSDAO dao = RSSDAOFactory.getRSSDAO();
        if (RSSManagerUtil.isSuperTenant()) {
            List<RSSInstanceEntry> instanceList = dao.getAllRSSInstances();
            return instanceList.toArray(new RSSInstanceEntry[instanceList.size()]);
        }
        List<RSSInstanceEntry> instanceList = dao.getAllTenantSpecificRSSInstances();
        return instanceList.toArray(new RSSInstanceEntry[instanceList.size()]);
    }

    public RSSInstanceEntry getRoundRobinAssignedRSSInstance() throws RSSDAOException {
        return RSSManagerUtil.getRoundRobinAssignedRSSInstance();
    }

    public void createDatabase(OMElement dbIns) throws RSSDAOException {
        DatabaseInstance db = RSSManagerUtil.buildDatabaseInstance(dbIns);
        String rmType = RSSManagerUtil.getDatabaseMgtSystemType(db.getRssInstanceId());
        RSSManager rm = RSSManagerFactory.getRSSManager(rmType);
        rm.createDatabase(db);
    }

    public void dropDatabase(int dbInsId) throws RSSDAOException {
        if (!RSSManagerUtil.dbBelongsToCurrentTenant(RSSDAOFactory.getRSSDAO().getDatabaseInstanceById(dbInsId))) {
            throw new RSSDAOException("Database does not belong to the current tenant");
        }
        DatabaseInstance dbIns = RSSDAOFactory.getRSSDAO().getDatabaseInstanceById(dbInsId);
        String rmType = RSSManagerUtil.getDatabaseMgtSystemType(dbIns.getRssInstanceId());
        RSSManager rm = RSSManagerFactory.getRSSManager(rmType);
        rm.dropDatabase(dbInsId);
    }

    public DatabaseInstanceEntry[] getDatabaseInstanceList() throws RSSDAOException {
        RSSDAO dao = RSSDAOFactory.getRSSDAO();
        if (RSSManagerUtil.isSuperTenant()) {
            List<DatabaseInstanceEntry> entries = dao.getAllDatabaseInstanceEntries();
            return entries.toArray(new DatabaseInstanceEntry[entries.size()]);
        }
        List<DatabaseInstanceEntry> entries = dao.getAllTenantSpecificDatabaseInstanceEntries();
        return entries.toArray(new DatabaseInstanceEntry[entries.size()]);
    }

    public DatabaseInstanceEntry getDatabaseInstanceById(int dbInsId) throws RSSDAOException {
        return RSSDAOFactory.getRSSDAO().getDatabaseInstanceEntryById(dbInsId);
    }

    public void createUser(DatabaseUser user, int privGroupId, int dbInsId) throws RSSDAOException {
        try {
            String rmType = RSSManagerUtil.getDatabaseMgtSystemType(user.getRssInstanceId());
            RSSManager rm = RSSManagerFactory.getRSSManager(rmType);
            rm.createUser(user, privGroupId, dbInsId);
        }
        catch (SQLException e) {
            this.handleException("Unable to create user " + user.getUsername(), e);
        }
    }

    public void dropUser(int userId, int dbInsId) throws RSSDAOException {
        String rmType = RSSManagerUtil.getDatabaseType(dbInsId);
        RSSManager rm = RSSManagerFactory.getRSSManager(rmType);
        rm.dropUser(userId, dbInsId);
    }

    public void editUserPrivileges(String privs, DatabaseUser user, int dbInsId) throws RSSDAOException {
        try {
            if (privs != null) {
                DatabasePermissions permissions = RSSManagerUtil.getPermissionObject(AXIOMUtil.stringToOM((String)privs));
                String rmType = RSSManagerUtil.getDatabaseMgtSystemType(user.getRssInstanceId());
                RSSManager rm = RSSManagerFactory.getRSSManager(rmType);
                rm.editUserPrivileges(permissions, user, dbInsId);
            }
        }
        catch (XMLStreamException e) {
            this.handleException("Unable to edit user " + user.getUsername(), e);
        }
    }

    public DatabaseUser getDatabaseUserById(int userId) throws RSSDAOException {
        return RSSDAOFactory.getRSSDAO().getUserById(userId);
    }

    public DatabaseUserEntry[] getUsersByDatabaseInstanceId(int dbInstId) throws RSSDAOException {
        List<DatabaseUserEntry> users = RSSDAOFactory.getRSSDAO().getUsersByDatabaseInstanceId(dbInstId);
        return users.toArray(new DatabaseUserEntry[users.size()]);
    }

    public String getUserDatabasePermissions(int userId, int dbInsId) throws RSSDAOException {
        if (!RSSManagerUtil.userBelongsToCurrentTenant(userId)) {
            throw new RSSDAOException("Database user does not belong to the current tenant");
        }
        if (!RSSManagerUtil.dbBelongsToCurrentTenant(RSSDAOFactory.getRSSDAO().getDatabaseInstanceById(dbInsId))) {
            throw new RSSDAOException("Database does not belong to the current tenant");
        }
        Map<String, Object> permissions = RSSDAOFactory.getRSSDAO().getUserDatabasePermissions(userId, dbInsId);
        return RSSManagerUtil.serializeUserPermissions(RSS_MANAGER_OM_NAMESPACE, permissions).toString();
    }

    public void createPrivilegeGroup(PrivilegeGroup privGroup) throws RSSDAOException {
        RSSDAOFactory.getRSSDAO().addUserPrivilegeGroup(privGroup);
    }

    public void removePrivilegeGroup(int privGroupId) throws RSSDAOException {
        RSSDAOFactory.getRSSDAO().removeUserPrivilegeGroup(privGroupId);
    }

    public void editPrivilegeGroup(PrivilegeGroup privGroup) throws RSSDAOException {
        if (!RSSManagerUtil.privilegeGroupBelongsToCurrentTenant(privGroup.getPrivGroupId())) {
            throw new RSSDAOException("Privilege group does not belong to the current tenant");
        }
        RSSDAOFactory.getRSSDAO().editUserPrivilegeGroup(privGroup);
    }

    public PrivilegeGroup[] getPrivilegeGroups() throws RSSDAOException {
        List<PrivilegeGroup> privGroups = RSSDAOFactory.getRSSDAO().getAllUserPrivilegeGroups();
        return privGroups.toArray(new PrivilegeGroup[privGroups.size()]);
    }

    public PrivilegeGroup getPrivilegeGroupById(int privGroupId) throws RSSDAOException {
        return RSSDAOFactory.getRSSDAO().getPrivilegeGroupById(privGroupId);
    }

    private DataSourceInformation createDSInfo(DatabaseInstanceEntry entry, DatabaseUser user) {
        DataSourceInformation dsInfo = new DataSourceInformation();
        String dsName = entry.getDbName() + "_" + user.getUserId();
        dsInfo.setAlias(dsName);
        dsInfo.setDatasourceName(dsName);
        dsInfo.setDriver(RSSManagerCommonUtil.getDatabaseDriver((String)entry.getDbUrl()));
        dsInfo.setType("BasicDataSource");
        dsInfo.setRepositoryType("memory");
        dsInfo.setUrl(entry.getDbUrl());
        SecretInformation secInfo = new SecretInformation();
        secInfo.setUser(user.getUsername());
        secInfo.setAliasSecret(user.getPassword());
        dsInfo.setSecretInformation(secInfo);
        Properties props = DataSourceInformationSerializer.serialize((DataSourceInformation)dsInfo);
        return DataSourceInformationFactory.createDataSourceInformation((String)dsName, (Properties)props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createCarbonDSFromDatabaseUserEntry(int dbInsId, int userId) throws RSSDAOException {
        RSSDAO dao = RSSDAOFactory.getRSSDAO();
        try {
            int tenantId = CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId();
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(tenantId);
            DatabaseInstanceEntry entry = dao.getDatabaseInstanceEntryById(dbInsId);
            if (entry == null) {
                throw new RSSDAOException("Database instance does not exist");
            }
            DatabaseUser user = dao.getUserById(userId);
            DataSourceInformation dsInfo = this.createDSInfo(entry, user);
            Properties dsProps = DataSourceInformationSerializer.serialize((DataSourceInformation)dsInfo);
            OMElement dsEl = MiscellaneousHelper.createOMElement((Properties)dsProps);
            DataSourceInformationManager dsInfoManager = DataSourceManagementHandler.getInstance().getTenantDataSourceInformationManager();
            dsInfoManager.addDataSourceInformation(dsInfo);
            String dsName = entry.getDbName() + "_" + user.getUserId();
            dsInfoManager.persistDataSourceInformation(dsName, dsEl);
            String string = "Carbon data source with the name '" + dsName + "' has been successfully created";
            return string;
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String testConnection(String driverClass, String jdbcURL, String username, String password) throws RSSDAOException {
        int tenantId = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)this.getConfigContext()).getTenantId();
        if (driverClass == null || driverClass.length() == 0) {
            String message = "Driver class is missing";
            log.debug((Object)message);
            return message;
        }
        if (jdbcURL == null || jdbcURL.length() == 0) {
            String message = "Driver connection URL is missing";
            log.debug((Object)message);
            return message;
        }
        try {
            SuperTenantCarbonContext.startTenantFlow();
            CarbonContextHolder.getCurrentCarbonContextHolder().setTenantId(tenantId);
            RSSInstance rssIns = new RSSInstance();
            rssIns.setServerURL(jdbcURL);
            rssIns.setAdminUsername(username);
            rssIns.setAdminPassword(password);
            DBConnectionHandler.getConnection(rssIns);
            String message = "Database connection is successful with driver class " + driverClass + " , JDBC url " + jdbcURL + " and username " + username;
            log.debug((Object)message);
            String string = message;
            return string;
        }
        finally {
            DBConnectionHandler.closeConnection();
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    private void handleException(String msg, Exception e) throws RSSDAOException {
        log.error((Object)msg, (Throwable)e);
        throw new RSSDAOException(msg, e);
    }
}

