/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rssmanager.core.internal;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.datasource.DataSourceInformationRepositoryService;
import org.wso2.carbon.rssmanager.core.RSSDAOException;
import org.wso2.carbon.rssmanager.core.RSSManagerUtil;
import org.wso2.carbon.rssmanager.core.dao.RSSConfig;
import org.wso2.carbon.rssmanager.core.dao.RSSDAO;
import org.wso2.carbon.rssmanager.core.dao.RSSDAOFactory;
import org.wso2.carbon.rssmanager.core.description.RSSInstance;
import org.wso2.carbon.rssmanager.core.multitenancy.RSSManagerAxis2ConfigObserver;
import org.wso2.carbon.rssmanager.core.service.RSSManagerService;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;

public class RSSManagerServiceComponent {
    private static Log log = LogFactory.getLog(RSSManagerServiceComponent.class);
    private static DataSourceInformationRepositoryService dataSourceService;
    private static RealmService realmService;

    protected void activate(ComponentContext componentContext) {
        BundleContext bundleContext = componentContext.getBundleContext();
        try {
            try {
                this.initRSSDatabase();
            }
            catch (Exception e) {
                log.error((Object)"Error in initialising RSS database", (Throwable)e);
            }
            bundleContext.registerService(AbstractAxis2ConfigurationContextObserver.class.getName(), (Object)new RSSManagerAxis2ConfigObserver(), null);
            bundleContext.registerService(RSSManagerService.class.getName(), (Object)new RSSManagerService(), null);
        }
        catch (Throwable e) {
            String msg = "Failed To Register Admin Console Bundle As An OSGi Service";
            log.error((Object)msg, e);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
    }

    protected void setCarbonDataSourceService(DataSourceInformationRepositoryService dataSourceService) {
        RSSManagerServiceComponent.dataSourceService = dataSourceService;
    }

    protected void unsetCarbonDataSourceService(DataSourceInformationRepositoryService dataSourceService) {
        RSSManagerServiceComponent.dataSourceService = null;
    }

    public static DataSourceInformationRepositoryService getCarbonDataSourceService() {
        return dataSourceService;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    protected void setRealmService(RealmService realmService) {
        RSSManagerServiceComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        this.setRealmService(null);
    }

    public static TenantManager getTenantManager() {
        return realmService.getTenantManager();
    }

    public static RealmConfiguration getBootstrapRealmConfiguration() {
        return realmService.getBootstrapRealmConfiguration();
    }

    private void initRSSDatabase() throws RSSDAOException {
        RSSConfig rssConfig = RSSManagerUtil.getRSSConfig();
        HashMap<String, RSSInstance> rssInstances = new HashMap<String, RSSInstance>();
        for (RSSInstance tmpInst : rssConfig.getRssInstances()) {
            rssInstances.put(tmpInst.getName(), tmpInst);
        }
        RSSDAO rssDAO = RSSDAOFactory.getRSSDAO();
        for (RSSInstance tmpInst : rssDAO.getAllServiceProviderHostedRSSInstances()) {
            rssInstances.remove(tmpInst.getName());
        }
        for (RSSInstance inst : rssInstances.values()) {
            rssDAO.addRSSInstance(inst);
        }
    }
}

