/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rssmanager.core.dao;

import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.rssmanager.common.RSSManagerCommonUtil;
import org.wso2.carbon.rssmanager.core.RSSDAOException;
import org.wso2.carbon.rssmanager.core.description.RSSInstance;

public class RSSConfig {
    private String rssDatabaseDriver;
    private String rssDatabaseURL;
    private String rssUsername;
    private String rssPassword;
    private List<RSSInstance> rssInstances;

    public RSSConfig(OMElement configDocument) throws RSSDAOException {
        Iterator tmpItr = configDocument.getChildrenWithLocalName("rss-database");
        if (!tmpItr.hasNext()) {
            throw new RSSDAOException("The RSS database definition is missing");
        }
        OMElement rssDBEl = (OMElement)tmpItr.next();
        if (!(tmpItr = rssDBEl.getChildrenWithLocalName("driver")).hasNext()) {
            throw new RSSDAOException("Database driver is missing in RSS database definition");
        }
        OMElement tmpEl = (OMElement)tmpItr.next();
        this.rssDatabaseDriver = tmpEl.getText().trim();
        tmpItr = rssDBEl.getChildrenWithLocalName("url");
        if (!tmpItr.hasNext()) {
            throw new RSSDAOException("Database URL is missing in RSS database definition");
        }
        tmpEl = (OMElement)tmpItr.next();
        this.rssDatabaseURL = tmpEl.getText().trim();
        tmpItr = rssDBEl.getChildrenWithLocalName("username");
        if (!tmpItr.hasNext()) {
            throw new RSSDAOException("Database username is missing in RSS database definition");
        }
        tmpEl = (OMElement)tmpItr.next();
        this.rssUsername = tmpEl.getText().trim();
        tmpItr = rssDBEl.getChildrenWithLocalName("password");
        if (!tmpItr.hasNext()) {
            throw new RSSDAOException("Database password is missing in RSS database definition");
        }
        tmpEl = (OMElement)tmpItr.next();
        this.rssPassword = tmpEl.getText().trim();
        this.rssInstances = new ArrayList<RSSInstance>();
        OMElement wso2InstancesEl = (OMElement)configDocument.getChildrenWithLocalName("wso2-rss-instances").next();
        if (wso2InstancesEl != null) {
            Iterator instances = wso2InstancesEl.getChildrenWithLocalName("wso2-rss-instance");
            while (instances.hasNext()) {
                this.rssInstances.add(this.createRSSInstanceFromXMLConfig((OMElement)instances.next()));
            }
        }
        try {
            Class.forName(this.getRssDatabaseDriver());
        }
        catch (ClassNotFoundException e) {
            throw new RSSDAOException("Cannot load JDBC driver", e);
        }
    }

    public Connection getRSSDBConnection() throws RSSDAOException {
        try {
            return DriverManager.getConnection(this.getRssDatabaseURL(), this.getRssUsername(), this.getRssPassword());
        }
        catch (SQLException e) {
            throw new RSSDAOException("Error in creating new RSS database connection", e);
        }
    }

    private RSSInstance createRSSInstanceFromXMLConfig(OMElement rssInstEl) throws RSSDAOException {
        String serverURL;
        Iterator tmpItr = rssInstEl.getChildrenWithLocalName("name");
        if (!tmpItr.hasNext()) {
            throw new RSSDAOException("Server instance name is missing in RSS database definition");
        }
        OMElement tmpEl = (OMElement)tmpItr.next();
        String name = tmpEl.getText().trim();
        tmpItr = rssInstEl.getChildrenWithLocalName("server-url");
        if (!tmpItr.hasNext()) {
            throw new RSSDAOException("Server instance URL is missing in RSS database definition");
        }
        tmpEl = (OMElement)tmpItr.next();
        try {
            serverURL = RSSManagerCommonUtil.validateRSSInstanceUrl((String)tmpEl.getText().trim());
        }
        catch (URISyntaxException e) {
            throw new RSSDAOException("Malfored RSS instance URL");
        }
        tmpItr = rssInstEl.getChildrenWithLocalName("dbms-type");
        if (!tmpItr.hasNext()) {
            throw new RSSDAOException("Server instance DBMS type is missing in RSS database definition");
        }
        tmpEl = (OMElement)tmpItr.next();
        String dbmsType = tmpEl.getText().trim();
        tmpItr = rssInstEl.getChildrenWithLocalName("server-category");
        if (!tmpItr.hasNext()) {
            throw new RSSDAOException("Server category is missing in RSS database definition");
        }
        tmpEl = (OMElement)tmpItr.next();
        String serverCategory = tmpEl.getText().trim();
        tmpItr = rssInstEl.getChildrenWithLocalName("admin-username");
        if (!tmpItr.hasNext()) {
            throw new RSSDAOException("Server instance admin username is missing in RSS database definition");
        }
        tmpEl = (OMElement)tmpItr.next();
        String adminUsername = tmpEl.getText().trim();
        tmpItr = rssInstEl.getChildrenWithLocalName("admin-password");
        if (!tmpItr.hasNext()) {
            throw new RSSDAOException("Server instance service admin password is missing in RSS database definition");
        }
        tmpEl = (OMElement)tmpItr.next();
        String adminPassword = tmpEl.getText().trim();
        return new RSSInstance(0, name, serverURL, dbmsType, "WSO2_RSS", serverCategory, adminUsername, adminPassword, 0);
    }

    public String getRssDatabaseDriver() {
        return this.rssDatabaseDriver;
    }

    public String getRssDatabaseURL() {
        return this.rssDatabaseURL;
    }

    public String getRssUsername() {
        return this.rssUsername;
    }

    public String getRssPassword() {
        return this.rssPassword;
    }

    public List<RSSInstance> getRssInstances() {
        return this.rssInstances;
    }
}

