/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rssmanager.core;

import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.util.Base64;
import org.wso2.carbon.rssmanager.common.RSSManagerCommonUtil;
import org.wso2.carbon.rssmanager.core.DBConnectionHandler;
import org.wso2.carbon.rssmanager.core.RSSDAOException;
import org.wso2.carbon.rssmanager.core.dao.RSSConfig;
import org.wso2.carbon.rssmanager.core.dao.RSSDAO;
import org.wso2.carbon.rssmanager.core.dao.RSSDAOFactory;
import org.wso2.carbon.rssmanager.core.description.DatabaseInstance;
import org.wso2.carbon.rssmanager.core.description.DatabaseInstanceEntry;
import org.wso2.carbon.rssmanager.core.description.DatabasePermissions;
import org.wso2.carbon.rssmanager.core.description.DatabasePrivilege;
import org.wso2.carbon.rssmanager.core.description.RSSInstance;
import org.wso2.carbon.rssmanager.core.description.RSSInstanceEntry;
import org.wso2.carbon.rssmanager.core.internal.RSSManagerServiceComponent;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public class RSSManagerUtil {
    private static RSSConfig currentRSSConfig;
    private static final OMFactory omFactory;
    private static final String NULL_NAMESPACE = "";
    private static final OMNamespace NULL_OMNS;

    public static RSSConfig getRSSConfig() throws RSSDAOException {
        if (currentRSSConfig == null) {
            String rssConfigXMLPath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "advanced" + File.separator + "wso2-rss-config.xml";
            try {
                currentRSSConfig = new RSSConfig(AXIOMUtil.stringToOM((String)new String(CarbonUtils.getBytesFromFile((File)new File(rssConfigXMLPath)))));
            }
            catch (Exception e) {
                throw new RSSDAOException("Error in creating RSS config", e);
            }
        }
        return currentRSSConfig;
    }

    public static DatabaseInstance buildDatabaseInstance(OMElement dbEl) throws RSSDAOException {
        String properties;
        String dbInsId;
        String rssInsId;
        OMElement el;
        try {
            el = AXIOMUtil.stringToOM((String)((OMTextImpl)dbEl.getChildren().next()).getText());
        }
        catch (XMLStreamException e) {
            throw new RSSDAOException("Unable to retrieve database instance data", e);
        }
        DatabaseInstance db = new DatabaseInstance();
        String name = el.getAttributeValue(new QName(NULL_NAMESPACE, "name"));
        if (name != null) {
            db.setName(name);
        }
        if ((rssInsId = el.getAttributeValue(new QName(NULL_NAMESPACE, "rssInsId"))) != null) {
            db.setRssInstanceId(Integer.parseInt(rssInsId));
        }
        if ((dbInsId = el.getAttributeValue(new QName(NULL_NAMESPACE, "dbInsId"))) != null) {
            db.setDatabaseInstanceId(Integer.parseInt(dbInsId));
        }
        if ((properties = el.getAttributeValue(new QName(NULL_NAMESPACE, "properties"))) != null) {
            db.setProperties(null);
        }
        return db;
    }

    public static DatabasePermissions getPermissionObject(OMElement privilegesElement) {
        DatabasePermissions permissions = new DatabasePermissions();
        Iterator attributeIterator = privilegesElement.getAllAttributes();
        while (attributeIterator.hasNext()) {
            OMAttribute attribute = (OMAttribute)attributeIterator.next();
            String attributeName = attribute.getLocalName();
            String value = attribute.getAttributeValue();
            for (String priv : RSSManagerCommonUtil.getDatabasePrivilegeList()) {
                if (!priv.equals(attributeName)) continue;
                if (value != null) {
                    if (RSSManagerCommonUtil.getBooleanResponsePrivilegeList().contains(priv)) {
                        permissions.setPermission(priv, value);
                        continue;
                    }
                    if (RSSManagerCommonUtil.getBlobResponsePrivilegeList().contains(priv)) {
                        permissions.setPermission(priv, value);
                        continue;
                    }
                    if (RSSManagerCommonUtil.getIntegerResponsePrivilegeList().contains(priv)) {
                        permissions.setPermission(priv, Integer.parseInt(value));
                        continue;
                    }
                    if (!RSSManagerCommonUtil.getStringResponsePrivilegeList().contains(priv)) continue;
                    permissions.setPermission(priv, value);
                    continue;
                }
                if (RSSManagerCommonUtil.getBooleanResponsePrivilegeList().contains(priv)) {
                    permissions.setPermission(priv, "N");
                    continue;
                }
                if (RSSManagerCommonUtil.getBlobResponsePrivilegeList().contains(priv)) {
                    permissions.setPermission(priv, NULL_NAMESPACE);
                    continue;
                }
                if (RSSManagerCommonUtil.getIntegerResponsePrivilegeList().contains(priv)) {
                    permissions.setPermission(priv, 0);
                    continue;
                }
                if (!RSSManagerCommonUtil.getStringResponsePrivilegeList().contains(priv)) continue;
                permissions.setPermission(priv, NULL_NAMESPACE);
            }
        }
        return permissions;
    }

    public static OMElement serializeDatabaseInstanceEntry(OMNamespace targetNamespace, DatabaseInstanceEntry dbe) throws RSSDAOException {
        String rssTenantDomain;
        String rssName;
        String dbUrl;
        String dbInstId;
        if (dbe == null) {
            throw new RSSDAOException("Database instance entry cannot be null");
        }
        OMElement dbEl = omFactory.createOMElement("db", targetNamespace);
        String dbName = dbe.getDbName();
        if (!NULL_NAMESPACE.equals(dbName) && dbName != null) {
            dbEl.addAttribute("dbName", dbName, NULL_OMNS);
        }
        if (!NULL_NAMESPACE.equals(dbInstId = String.valueOf(dbe.getDbInstanceId())) && dbInstId != null) {
            dbEl.addAttribute("dbInstanceId", dbInstId, NULL_OMNS);
        }
        if (!NULL_NAMESPACE.equals(dbUrl = dbe.getDbUrl()) && dbUrl != null) {
            dbEl.addAttribute("dbUrl", dbUrl, NULL_OMNS);
        }
        if ((rssName = dbe.getRssName()) != null && !NULL_NAMESPACE.equals(rssName)) {
            dbEl.addAttribute("rssName", rssName, NULL_OMNS);
        }
        if ((rssTenantDomain = dbe.getRssTenantDomain()) != null && !NULL_NAMESPACE.equals(rssTenantDomain)) {
            dbEl.addAttribute("rssTenantDomain", rssTenantDomain, NULL_OMNS);
        }
        return dbEl;
    }

    public static OMElement serializeDatabaseInstance(OMNamespace targetNamespace, DatabaseInstance db) throws RSSDAOException {
        String rssInstId;
        String dbInstId;
        if (db == null) {
            throw new RSSDAOException("Database instance cannot be null");
        }
        OMElement dbEl = omFactory.createOMElement("db", targetNamespace);
        String name = db.getName();
        if (!NULL_NAMESPACE.equals(name) && name != null) {
            dbEl.addAttribute("name", name, NULL_OMNS);
        }
        if (!NULL_NAMESPACE.equals(dbInstId = String.valueOf(db.getDatabaseInstanceId())) && dbInstId != null) {
            dbEl.addAttribute("dbInsId", dbInstId, NULL_OMNS);
        }
        if (!NULL_NAMESPACE.equals(rssInstId = String.valueOf(db.getRssInstanceId())) && rssInstId != null) {
            dbEl.addAttribute("rssInsId", rssInstId, NULL_OMNS);
        }
        return dbEl;
    }

    public static OMElement serializeUserPermissions(OMNamespace targetNamespace, Map<String, Object> permissions) {
        OMElement permissionsElement = omFactory.createOMElement("permissions", targetNamespace);
        if (permissions != null) {
            for (Map.Entry<String, Object> entry : permissions.entrySet()) {
                Object attributeValue = entry.getValue();
                if (attributeValue != null) {
                    permissionsElement.addAttribute(entry.getKey().toString(), attributeValue.toString(), targetNamespace);
                    continue;
                }
                permissionsElement.addAttribute(entry.getKey().toString(), NULL_NAMESPACE, targetNamespace);
            }
        }
        return permissionsElement;
    }

    public static String processJdbcUrl(String url, String dbName) {
        if (url != null && !NULL_NAMESPACE.equals(url)) {
            return url.endsWith("/") ? url + dbName : url + "/" + dbName;
        }
        return NULL_NAMESPACE;
    }

    public static String prepareUpdateSQLString(String queryPrefix, String querySuffix, List<String> privileges) {
        StringBuilder sql = new StringBuilder(queryPrefix);
        for (int i = 0; i < privileges.size(); ++i) {
            if (i != privileges.size() - 1) {
                sql.append(privileges.get(i)).append("=?,");
                continue;
            }
            sql.append(privileges.get(i)).append("=?");
        }
        sql.append(querySuffix);
        return sql.toString();
    }

    public static String getFullyQualifiedDatabaseName(String dbName) {
        String tenantDomain = CarbonContextHolder.getCurrentCarbonContextHolder().getTenantDomain();
        if (tenantDomain != null) {
            return dbName + "_" + RSSManagerCommonUtil.processDomainName((String)tenantDomain);
        }
        return dbName;
    }

    public static Map<String, Object> convertPrivListToMap(List<DatabasePrivilege> privs) {
        HashMap<String, Object> privMap = new HashMap<String, Object>();
        for (DatabasePrivilege priv : privs) {
            privMap.put(priv.getPrivName(), priv.getPrivValue());
        }
        return privMap;
    }

    public static String getFullyQualifiedUsername(String username) {
        String tenantDomain = CarbonContextHolder.getCurrentCarbonContextHolder().getTenantDomain();
        if (tenantDomain != null) {
            byte[] bytes = RSSManagerCommonUtil.intToByteArray((int)tenantDomain.hashCode());
            return username + "_" + Base64.encode((byte[])bytes);
        }
        return username;
    }

    public static boolean validateUser(RSSInstance rssIns, String username) throws RSSDAOException {
        try {
            PreparedStatement stmt = DBConnectionHandler.getConnection(rssIns).prepareStatement("SELECT 1 FROM mysql.user WHERE user=? AND host=?");
            stmt.setString(1, username);
            stmt.setString(2, "%");
            ResultSet rs = stmt.executeQuery();
            if (rs.next() && rs.getInt(1) == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new RSSDAOException("Unable to validate the user " + username, e);
        }
        return false;
    }

    public static boolean privilegeGroupBelongsToCurrentTenant(int privGroupId) throws RSSDAOException {
        Connection conn = RSSManagerUtil.getRSSConfig().getRSSDBConnection();
        int privGroupTenantId = -1;
        int currentTenantId = CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT tenant_id FROM USER_PRIVILEGE_GROUP WHERE priv_group_id = ?");
            stmt.setInt(1, privGroupId);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                privGroupTenantId = rs.getInt(1);
            }
            return currentTenantId == privGroupTenantId;
        }
        catch (SQLException e) {
            throw new RSSDAOException("Unable to retrieve tenant id of the privilege group");
        }
    }

    public static boolean userBelongsToCurrentTenant(int userId) throws RSSDAOException {
        Connection conn = RSSManagerUtil.getRSSConfig().getRSSDBConnection();
        int userTenantId = -1;
        int currentTenantId = CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT user_tenant_id FROM DATABASE_USER WHERE user_id = ?");
            stmt.setInt(1, userId);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                userTenantId = rs.getInt(1);
            }
            return currentTenantId == userTenantId;
        }
        catch (SQLException e) {
            throw new RSSDAOException("Unable to retrieve tenant id of the database user");
        }
    }

    public static boolean dbBelongsToCurrentTenant(DatabaseInstance ins) throws RSSDAOException {
        int currentTenantId = CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId();
        return ins != null && currentTenantId == ins.getTenantId();
    }

    public static boolean rssInstanceBelongsToTenant(int rssInsId) throws RSSDAOException {
        int currentTenantId = CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId();
        RSSInstance rssIns = RSSDAOFactory.getRSSDAO().getRSSInstanceById(rssInsId);
        return rssIns != null && currentTenantId == rssIns.getTenantId();
    }

    public static boolean isSuperTenant() {
        int currentTenantId = CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId();
        return currentTenantId == -1234;
    }

    public static RSSInstanceEntry createRSSInstanceEntryFromRSSInstanceData(RSSInstance rssIns) throws RSSDAOException {
        return new RSSInstanceEntry(rssIns.getRssInstanceId(), rssIns.getName(), rssIns.getServerURL(), rssIns.getInstanceType(), rssIns.getServerCategory(), RSSManagerUtil.getTenantDomain(rssIns.getTenantId()));
    }

    public static DatabaseInstanceEntry createDbInstanceEntryFromDbInstanceData(DatabaseInstance dbIns) throws RSSDAOException {
        RSSInstance rssIns = RSSDAOFactory.getRSSDAO().getRSSInstanceById(dbIns.getRssInstanceId());
        if (rssIns.getTenantId() == -1234) {
            rssIns.setName("WSO2_RSS");
        }
        return new DatabaseInstanceEntry(dbIns.getDatabaseInstanceId(), dbIns.getName(), rssIns.getServerURL() + "/" + dbIns.getName(), rssIns.getRssInstanceId(), rssIns.getName(), RSSManagerUtil.getTenantDomain(dbIns.getTenantId()));
    }

    public static String getTenantDomain(int tenantId) throws RSSDAOException {
        if (tenantId == -1234) {
            return "STRATOS_RSS";
        }
        try {
            return RSSManagerServiceComponent.getTenantManager().getDomain(tenantId);
        }
        catch (UserStoreException e) {
            throw new RSSDAOException("Unable to retrieve domain name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean databaseExists(String dbName) throws RSSDAOException, SQLException {
        Connection conn = null;
        int tid = CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId();
        try {
            int existCode;
            conn = RSSManagerUtil.getRSSConfig().getRSSDBConnection();
            String sql = "SELECT 1 FROM DATABASE_INSTANCE WHERE name = ? AND tenant_id = ?";
            CallableStatement stmt = conn.prepareCall(sql);
            stmt.setString(1, dbName);
            stmt.setInt(2, tid);
            ResultSet rs = stmt.executeQuery();
            if (rs.next() && (existCode = rs.getInt(1)) == 1) {
                rs.close();
                stmt.close();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return false;
    }

    public static String getDatabaseMgtSystemType(int rssInsId) throws RSSDAOException {
        RSSInstance rssIns = RSSDAOFactory.getRSSDAO().getRSSInstanceById(rssInsId);
        return rssIns.getDbmsType();
    }

    public static String getDatabaseType(int dbInsId) throws RSSDAOException {
        DatabaseInstance db = RSSDAOFactory.getRSSDAO().getDatabaseInstanceById(dbInsId);
        return RSSManagerUtil.getDatabaseMgtSystemType(db.getRssInstanceId());
    }

    public static int getRSSInstanceId(int dbInsId) throws RSSDAOException {
        DatabaseInstance dbIns = RSSDAOFactory.getRSSDAO().getDatabaseInstanceById(dbInsId);
        return dbIns.getRssInstanceId();
    }

    public static RSSInstanceEntry getRoundRobinAssignedRSSInstance() throws RSSDAOException {
        RSSDAO dao = RSSDAOFactory.getRSSDAO();
        List<RSSInstance> rdsInstances = dao.getAllServiceProviderHostedRSSInstances();
        int insCount = dao.getServiceProviderHostedRSSDatabaseInstanceCount();
        for (int i = 0; i < rdsInstances.size(); ++i) {
            RSSInstance rssIns;
            if (i != insCount % rdsInstances.size() || (rssIns = rdsInstances.get(i)) == null) continue;
            RSSInstanceEntry rssEntry = RSSManagerUtil.createRSSInstanceEntryFromRSSInstanceData(rssIns);
            rssEntry.setName("WSO2_RSS");
            return rssEntry;
        }
        return null;
    }

    static {
        omFactory = OMAbstractFactory.getOMFactory();
        NULL_OMNS = omFactory.createOMNamespace(NULL_NAMESPACE, NULL_NAMESPACE);
    }
}

