/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rssmanager.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.rssmanager.common.RSSManagerCommonUtil;
import org.wso2.carbon.rssmanager.core.DBConnectionHandler;
import org.wso2.carbon.rssmanager.core.RSSDAOException;
import org.wso2.carbon.rssmanager.core.RSSManager;
import org.wso2.carbon.rssmanager.core.RSSManagerUtil;
import org.wso2.carbon.rssmanager.core.dao.RSSDAO;
import org.wso2.carbon.rssmanager.core.dao.RSSDAOFactory;
import org.wso2.carbon.rssmanager.core.description.DatabaseInstance;
import org.wso2.carbon.rssmanager.core.description.DatabaseInstanceEntry;
import org.wso2.carbon.rssmanager.core.description.DatabasePermissions;
import org.wso2.carbon.rssmanager.core.description.DatabasePrivilege;
import org.wso2.carbon.rssmanager.core.description.DatabaseUser;
import org.wso2.carbon.rssmanager.core.description.RSSInstance;
import org.wso2.carbon.rssmanager.core.description.UserDatabaseEntry;

public class MySQLRSSManager
implements RSSManager {
    @Override
    public void createDatabase(DatabaseInstance db) throws RSSDAOException {
        RSSDAO dao = RSSDAOFactory.getRSSDAO();
        String fullyQualifiedDbName = RSSManagerUtil.getFullyQualifiedDatabaseName(db.getName());
        try {
            if (RSSManagerUtil.databaseExists(fullyQualifiedDbName)) {
                throw new RSSDAOException("Database " + fullyQualifiedDbName + " already exists");
            }
        }
        catch (SQLException e) {
            throw new RSSDAOException("Unable to check for the existence of the database " + fullyQualifiedDbName);
        }
        this.createDatabaseEntryInSystemTables(db.getRssInstanceId(), fullyQualifiedDbName);
        db.setName(fullyQualifiedDbName);
        dao.addDatabaseInstance(db);
        dao.incrementServiceProviderHostedRSSDatabaseInstanceCount();
    }

    private void createDatabaseEntryInSystemTables(int rssInsId, String dbName) throws RSSDAOException {
        RSSInstance rssIns = RSSDAOFactory.getRSSDAO().getRSSInstanceById(rssInsId);
        if (rssIns == null) {
            throw new RSSDAOException("RSS instance does not exist");
        }
        String sqlQuery = "CREATE DATABASE " + dbName;
        try {
            PreparedStatement stmt = DBConnectionHandler.getConnection(rssIns).prepareStatement(sqlQuery);
            stmt.execute();
        }
        catch (SQLException e) {
            throw new RSSDAOException("Unable to create database " + dbName, e);
        }
        finally {
            DBConnectionHandler.closeConnection();
        }
    }

    @Override
    public void dropDatabase(int dbInsId) throws RSSDAOException {
        RSSDAO dao = RSSDAOFactory.getRSSDAO();
        List<UserDatabaseEntry> entries = dao.getUserDatabaseEntriesByDatabaseInstanceId(dbInsId);
        try {
            this.dropDatabaseFromSystemTables(dbInsId);
        }
        catch (SQLException e) {
            throw new RSSDAOException("Error while dropping the database", e);
        }
        if (entries != null && entries.size() > 0) {
            for (UserDatabaseEntry entry : entries) {
                dao.deleteUserDatabaseEntry(entry.getUserId(), entry.getDatabaseInstanceId());
            }
        }
        dao.deleteDatabaseInstance(dbInsId);
    }

    private void dropDatabaseFromSystemTables(int dbInsId) throws RSSDAOException, SQLException {
        PreparedStatement stmt = null;
        RSSDAO dao = RSSDAOFactory.getRSSDAO();
        DatabaseInstance db = dao.getDatabaseInstanceById(dbInsId);
        if (db == null) {
            throw new RSSDAOException("Database instance does not exist");
        }
        RSSInstance rssIns = dao.getRSSInstanceById(db.getRssInstanceId());
        if (rssIns == null) {
            throw new RSSDAOException("Database server does not exist");
        }
        String dropDatabaseQuery = "DROP DATABASE " + db.getName();
        try {
            stmt = DBConnectionHandler.getConnection(rssIns).prepareStatement(dropDatabaseQuery);
            stmt.execute();
        }
        catch (SQLException e) {
            throw new RSSDAOException("Error while dropping the database " + db.getName(), e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            DBConnectionHandler.closeConnection();
        }
    }

    @Override
    public void createUser(DatabaseUser user, int privGroupId, int dbInsId) throws RSSDAOException, SQLException {
        RSSDAO dao = RSSDAOFactory.getRSSDAO();
        Connection conn = null;
        try {
            List<DatabasePrivilege> privs = Arrays.asList(dao.getPrivilegeGroupById(privGroupId).getPrivs());
            DatabaseInstanceEntry db = dao.getDatabaseInstanceEntryById(dbInsId);
            if (db == null) {
                throw new RSSDAOException("Unable to create user " + user.getUsername() + ". " + "The referred database instance does not exist");
            }
            user.setUsername(RSSManagerUtil.getFullyQualifiedUsername(user.getUsername()));
            user.setRssInstanceId(db.getRssInstanceId());
            RSSInstance rssIns = dao.getRSSInstanceById(db.getRssInstanceId());
            if (RSSManagerUtil.validateUser(rssIns, user.getUsername())) {
                throw new RSSDAOException("A user with the name " + user.getUsername() + " already exists");
            }
            String systemDbUrl = RSSManagerUtil.processJdbcUrl(rssIns.getServerURL(), "mysql");
            rssIns.setServerURL(systemDbUrl);
            conn = DBConnectionHandler.getConnection(rssIns);
            conn.setAutoCommit(false);
            this.insertIntoUserTable(conn, user);
            this.insertIntoDbTable(conn, db.getDbName(), user.getUsername(), privs);
            this.flushPrivileges(conn);
            conn.commit();
            int addedRecordNum = RSSDAOFactory.getRSSDAO().addUser(user);
            UserDatabaseEntry ude = new UserDatabaseEntry(addedRecordNum, dbInsId);
            ude.setPermissions(RSSManagerUtil.convertPrivListToMap(privs));
            dao.addUserDatabaseEntry(ude);
        }
        catch (SQLException e) {
            if (conn != null) {
                conn.rollback();
            }
            throw new RSSDAOException("Unable to create the database user", e);
        }
        finally {
            DBConnectionHandler.closeConnection();
        }
    }

    private void insertIntoUserTable(Connection conn, DatabaseUser user) throws RSSDAOException, SQLException {
        String sql = "CREATE USER '" + user.getUsername() + "'@'%' IDENTIFIED BY '" + user.getPassword() + "'";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.execute();
    }

    private void insertIntoDbTable(Connection conn, String dbName, String username, List<DatabasePrivilege> privs) throws SQLException {
        String sql = "INSERT INTO mysql.db VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setString(1, "%");
        stmt.setString(2, dbName);
        stmt.setString(3, username);
        List dbPrivs = RSSManagerCommonUtil.getDatabasePrivilegeList();
        Map<String, Object> privMap = RSSManagerUtil.convertPrivListToMap(privs);
        for (int i = 4; i < dbPrivs.size() + 4; ++i) {
            if (!privMap.containsKey(dbPrivs.get(i - 4))) continue;
            stmt.setString(i, privMap.get(dbPrivs.get(i - 4)).toString());
        }
        stmt.execute();
    }

    private void flushPrivileges(Connection conn) throws SQLException {
        String sql = "FLUSH PRIVILEGES";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.execute();
    }

    @Override
    public void dropUser(int userId, int dbInsId) throws RSSDAOException {
        RSSDAO dao = RSSDAOFactory.getRSSDAO();
        try {
            this.dropUserFromSystemTables(userId);
        }
        catch (SQLException e) {
            throw new RSSDAOException("Unable to drop user", e);
        }
        dao.deleteUserDatabaseEntry(userId, dbInsId);
        dao.deleteUser(userId);
    }

    private void dropUserFromSystemTables(int userId) throws RSSDAOException, SQLException {
        PreparedStatement stmt = null;
        RSSDAO dao = RSSDAOFactory.getRSSDAO();
        DatabaseUser user = dao.getUserById(userId);
        if (user == null) {
            throw new RSSDAOException("Database user does not exist");
        }
        RSSInstance rssIns = dao.getRSSInstanceById(user.getRssInstanceId());
        if (rssIns == null) {
            throw new RSSDAOException("RSS instance does not exist");
        }
        String dropUserQuery = "DROP USER '" + user.getUsername() + "'@'%'";
        try {
            stmt = DBConnectionHandler.getConnection(rssIns).prepareStatement(dropUserQuery);
            stmt.execute();
        }
        catch (SQLException e) {
            throw new RSSDAOException("Unable to delete user " + user.getUsername(), e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            DBConnectionHandler.closeConnection();
        }
    }

    @Override
    public void editUserPrivileges(DatabasePermissions permissions, DatabaseUser user, int dbInsId) throws RSSDAOException {
        RSSDAO dao = RSSDAOFactory.getRSSDAO();
        if (!RSSManagerUtil.userBelongsToCurrentTenant(user.getUserId())) {
            throw new RSSDAOException("User " + user.getUsername() + " does not belong to the current tenant.");
        }
        try {
            DatabaseInstanceEntry db = dao.getDatabaseInstanceEntryById(dbInsId);
            if (db == null) {
                throw new RSSDAOException("Database instance does not exist");
            }
            RSSInstance rssIns = dao.getRSSInstanceById(db.getRssInstanceId());
            if (rssIns == null) {
                throw new RSSDAOException("RSS instance does not exist");
            }
            String systemDbUrl = RSSManagerUtil.processJdbcUrl(rssIns.getServerURL(), "mysql");
            rssIns.setServerURL(systemDbUrl);
            Connection conn = DBConnectionHandler.getConnection(rssIns);
            conn.setAutoCommit(false);
            this.updatePrivilegesInSystemTables(conn, permissions, user, dbInsId);
            this.updatePasswordInSystemTable(conn, user, dbInsId);
            this.flushPrivileges(conn);
            conn.commit();
            dao.updateUser(permissions, user.getUserId(), dbInsId);
        }
        catch (SQLException e) {
            throw new RSSDAOException("Unable to edit user privileges", e);
        }
        finally {
            DBConnectionHandler.closeConnection();
        }
    }

    private void updatePrivilegesInSystemTables(Connection conn, DatabasePermissions permissions, DatabaseUser user, int dbInsId) throws SQLException, RSSDAOException {
        RSSDAO dao = RSSDAOFactory.getRSSDAO();
        String prefixDbUpdateQuery = "UPDATE mysql.db SET ";
        String suffixDbUpdateQuery = " WHERE host=? AND db=? AND user=?";
        String sql = RSSManagerUtil.prepareUpdateSQLString(prefixDbUpdateQuery, suffixDbUpdateQuery, RSSManagerCommonUtil.getDatabasePrivilegeList());
        PreparedStatement stmt = conn.prepareStatement(sql);
        int dbPrivCount = 0;
        for (String priv : RSSManagerCommonUtil.getDatabasePrivilegeList()) {
            stmt.setString(++dbPrivCount, permissions.getPermission(priv).toString());
        }
        stmt.setObject(dbPrivCount + 1, "%");
        stmt.setObject(dbPrivCount + 2, dao.getDatabaseInstanceById(dbInsId).getName());
        stmt.setObject(dbPrivCount + 3, user.getUsername());
        stmt.execute();
    }

    private void updatePasswordInSystemTable(Connection conn, DatabaseUser user, int dbInsId) throws RSSDAOException, SQLException {
        RSSDAO dao = RSSDAOFactory.getRSSDAO();
        String query = "UPDATE mysql.user SET Password = Password('" + user.getPassword() + "') WHERE user = ?";
        PreparedStatement stmt = conn.prepareStatement(query);
        stmt.setString(1, user.getUsername());
        stmt.executeUpdate();
    }
}

