/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rssmanager.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.rssmanager.common.RSSManagerCommonUtil;
import org.wso2.carbon.rssmanager.core.RSSDAOException;
import org.wso2.carbon.rssmanager.core.description.RSSInstance;

public class DBConnectionHandler {
    private static Connection connection;
    private static PreparedStatement preparedStatement;
    private static final Log log;

    public static Connection getConnection(RSSInstance rssIns) throws RSSDAOException {
        try {
            if (connection == null || connection.isClosed()) {
                Class.forName(RSSManagerCommonUtil.getDatabaseDriver((String)rssIns.getServerURL()));
                connection = DriverManager.getConnection(rssIns.getServerURL(), rssIns.getAdminUsername(), rssIns.getAdminPassword());
                return connection;
            }
            return connection;
        }
        catch (SQLException e) {
            String msg = "Unable To Establish The Connection";
            log.error((Object)msg, (Throwable)e);
            throw new RSSDAOException(msg, e);
        }
        catch (ClassNotFoundException e) {
            String msg = "Driver Class Not Found";
            log.error((Object)msg, (Throwable)e);
            throw new RSSDAOException(msg, e);
        }
    }

    public static void closeConnection() {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.error((Object)"Connection Cannot Be Closed", (Throwable)e);
            }
        }
    }

    public static DatabaseMetaData getDatabaseMetadata() throws SQLException {
        if (connection != null) {
            try {
                return connection.getMetaData();
            }
            catch (SQLException e) {
                String msg = "Unable to Retrieve Database Metadata";
                throw new SQLException(msg, e);
            }
        }
        return null;
    }

    static {
        log = LogFactory.getLog(DBConnectionHandler.class);
    }
}

