/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.service.mgt.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.service.mgt.stub.ServiceGroupAdminStub;
import org.wso2.carbon.service.mgt.stub.types.carbon.ServiceGroupMetaData;
import org.wso2.carbon.service.mgt.stub.types.carbon.ServiceGroupMetaDataWrapper;
import org.wso2.carbon.service.mgt.ui.Parameter;
import org.wso2.carbon.utils.xml.XMLPrettyPrinter;

public class ServiceGroupAdminClient {
    private static final Log log = LogFactory.getLog(ServiceGroupAdminClient.class);
    private ServiceGroupAdminStub stub;
    private static final String BUNDLE = "org.wso2.carbon.service.mgt.ui.i18n.Resources";
    private ResourceBundle bundle;

    public ServiceGroupAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "ServiceGroupAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new ServiceGroupAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public ServiceGroupMetaDataWrapper getAllServiceGroups(String serviceTypeFilter, String serviceGroupSearchString, int pageNumber) throws RemoteException {
        try {
            return this.stub.listServiceGroups(serviceTypeFilter, serviceGroupSearchString, pageNumber);
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.all.services"), e);
            return null;
        }
    }

    public List<Parameter> getServiceGroupParameters(String serviceGroupName) throws AxisFault {
        try {
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            try {
                String[] groupParameters = this.stub.getServiceGroupParameters(serviceGroupName);
                if (groupParameters != null && groupParameters.length != 0) {
                    for (String groupParameter : groupParameters) {
                        if (groupParameter == null) continue;
                        XMLStreamReader xmlSR = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(groupParameter.getBytes()));
                        OMElement paramEle = new StAXOMBuilder(xmlSR).getDocumentElement();
                        String paramName = paramEle.getAttribute(new QName("name")).getAttributeValue();
                        ByteArrayInputStream xmlIn = new ByteArrayInputStream(groupParameter.getBytes());
                        XMLPrettyPrinter xmlPrettyPrinter = new XMLPrettyPrinter((InputStream)xmlIn, null);
                        Parameter parameter = new Parameter(paramName, xmlPrettyPrinter.xmlFormat());
                        boolean isLocked = false;
                        OMAttribute lockedAttrib = paramEle.getAttribute(new QName("locked"));
                        if (lockedAttrib != null) {
                            isLocked = "true".equals(lockedAttrib.getAttributeValue());
                        }
                        parameter.setLocked(isLocked);
                        parameters.add(parameter);
                    }
                }
            }
            catch (Exception e) {
                this.handleException("Could not get parameters for service group: " + serviceGroupName, e);
            }
            return parameters;
        }
        catch (Exception e) {
            String msg = "Cannot get service group parameters.  Error is " + e.getMessage();
            this.handleException(msg, e);
            return null;
        }
    }

    public ServiceGroupMetaData configureServiceGroupMTOM(String mtomState, String serviceGroupName) throws AxisFault {
        try {
            return this.stub.configureServiceGroupMTOM(mtomState, serviceGroupName);
        }
        catch (Exception e) {
            String msg = "Cannot change MOM state of Axis service group" + serviceGroupName + " .  Error is " + e.getMessage();
            this.handleException(msg, e);
            return null;
        }
    }

    public ServiceGroupMetaData listServiceGroup(String serviceGroupName) throws AxisFault {
        try {
            return this.stub.listServiceGroup(serviceGroupName);
        }
        catch (Exception e) {
            String msg = "Cannot get service group data. Error is " + e.getMessage();
            this.handleException(msg, e);
            return null;
        }
    }

    public void setServiceGroupParamters(String serviceGroupName, List<String> params) throws AxisFault {
        try {
            this.stub.setServiceGroupParameters(serviceGroupName, params.toArray(new String[params.size()]));
        }
        catch (Exception e) {
            String msg = "Cannot get service group data.  Error is " + e.getMessage();
            this.handleException(msg, e);
        }
    }

    public void removeServiceGroupParameter(String serviceGroupName, String parameterName) throws AxisFault {
        try {
            this.stub.removeServiceGroupParameter(serviceGroupName, parameterName);
        }
        catch (Exception e) {
            this.handleException("Could not remove service group parameter. Service group: " + serviceGroupName + ", parameterName=" + parameterName, e);
        }
    }

    public String dumpAAR(String serviceGroupName) throws AxisFault {
        try {
            String dumpValue = this.stub.dumpAAR(serviceGroupName);
            if (dumpValue != null) {
                return dumpValue;
            }
            this.handleException("Service archive creation is not supported by this service type");
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
        return null;
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    private void handleException(String msg) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg);
    }
}

