/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rssmanager.ui;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.rssmanager.ui.RSSManagerClientUtil;
import org.wso2.carbon.rssmanager.ui.beans.DatabaseInstance;
import org.wso2.carbon.rssmanager.ui.beans.DatabasePermissions;
import org.wso2.carbon.rssmanager.ui.stub.RSSAdminStub;
import org.wso2.carbon.rssmanager.ui.stub.types.DatabaseInstanceEntry;
import org.wso2.carbon.rssmanager.ui.stub.types.DatabaseUser;
import org.wso2.carbon.rssmanager.ui.stub.types.DatabaseUserEntry;
import org.wso2.carbon.rssmanager.ui.stub.types.PrivilegeGroup;
import org.wso2.carbon.rssmanager.ui.stub.types.RSSInstance;
import org.wso2.carbon.rssmanager.ui.stub.types.RSSInstanceEntry;

public class RSSManagerClient {
    private RSSAdminStub stub;
    private ResourceBundle bundle;
    private static final String RSS_MANAGER_EXTENSION_NS = "http://www.wso2.org/products/wso2commons/rssmanager";
    private static final OMNamespace RSS_MANAGER_OM_NAMESPACE = OMAbstractFactory.getOMFactory().createOMNamespace("http://www.wso2.org/products/wso2commons/rssmanager", "instance");
    private static final String BUNDLE = "org.wso2.carbon.rssmanager.ui.i18n.Resources";
    private static final Log log = LogFactory.getLog(RSSManagerClient.class);

    public RSSManagerClient(String cookie, String backendServerUrl, ConfigurationContext configurationContext, Locale locale) {
        String serviceEndpoint = backendServerUrl + "RSSManagerAdminService";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        try {
            this.stub = new RSSAdminStub(configurationContext, serviceEndpoint);
            ServiceClient serviceClient = this.stub._getServiceClient();
            Options options = serviceClient.getOptions();
            options.setManageSession(true);
            options.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            log.error((Object)axisFault);
        }
    }

    public String removeUserPrivilegeGroup(int privGroupId) throws RemoteException {
        try {
            this.stub.removePrivilegeGroup(privGroupId);
            return this.bundle.getString("rss.manager.priv.group.successfully.removed");
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.remove.privilege.group"), e);
            return this.bundle.getString("rss.manager.failed.to.remove.privilege.group");
        }
    }

    public String editUserPrivilegeGroup(PrivilegeGroup priGroup) throws RemoteException {
        try {
            this.stub.editPrivilegeGroup(priGroup);
            return this.bundle.getString("rss.manager.privilege.group.successfully.edited");
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.create.privilege.group"), e);
            return this.bundle.getString("failed.to.create.privilege.group");
        }
    }

    public String createUserPrivilegeGroup(PrivilegeGroup privGroup) throws RemoteException {
        try {
            this.stub.createPrivilegeGroup(privGroup);
            return this.bundle.getString("rss.manager.privilege.group.successfully.created");
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.create.privilege.group") + ": " + privGroup.getPrivGroupName(), e);
            return this.bundle.getString("rss.manager.failed.to.create.privilege.group") + ": " + privGroup.getPrivGroupName();
        }
    }

    public List<PrivilegeGroup> getAllPrivilegeGroups() throws RemoteException {
        try {
            PrivilegeGroup[] privGroup = this.stub.getPrivilegeGroups();
            if (privGroup != null) {
                return Arrays.asList(this.stub.getPrivilegeGroups());
            }
            return new ArrayList<PrivilegeGroup>();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.retrieve.privilege.group.list"), e);
            return new ArrayList<PrivilegeGroup>();
        }
    }

    public String editUserPrivileges(DatabasePermissions permissions, DatabaseUser user, int dbInsId) throws RemoteException {
        try {
            this.stub.editUserPrivileges(RSSManagerClientUtil.serializePermissionObject(RSS_MANAGER_OM_NAMESPACE, permissions).toString(), user, dbInsId);
            return this.bundle.getString("rss.manager.user.successfully.edited");
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.edit.user") + ": " + user.getUsername(), e);
            return this.bundle.getString("rss.manager.failed.to.edit.user") + ": " + user.getUsername();
        }
    }

    public DatabasePermissions getUserDatabasePermissions(int userId, int dbInsId) throws RemoteException {
        OMElement permissionEl = null;
        try {
            permissionEl = AXIOMUtil.stringToOM((String)this.stub.getUserDatabasePermissions(userId, dbInsId));
        }
        catch (Exception e) {
            this.handleException("Unable to retrieve user database permissions", e);
        }
        return RSSManagerClientUtil.getPermissionObject(permissionEl);
    }

    public String createDatabase(DatabaseInstance db) throws RemoteException {
        try {
            this.stub.createDatabase(RSSManagerClientUtil.serializeDatabaseInstanceData(RSS_MANAGER_OM_NAMESPACE, db).toString());
            return "Database has been successfully created";
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.create.database") + ": " + db.getName(), e);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.create.database") + ": " + db.getName(), e);
        }
        return this.bundle.getString("failed.to.create.database") + db.getName();
    }

    public DatabaseUserEntry[] getUsersByDatabase(int dbInstId) throws RemoteException {
        DatabaseUserEntry[] users = new DatabaseUserEntry[]{};
        try {
            users = this.stub.getUsersByDatabaseInstanceId(dbInstId);
            if (users != null) {
                return users;
            }
            return users;
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.retrieve.database.users"), e);
            return users;
        }
    }

    public List<DatabaseInstanceEntry> getDatabaseInstanceList() throws RemoteException {
        try {
            DatabaseInstanceEntry[] entries = this.stub.getDatabaseInstanceList();
            if (entries != null) {
                return Arrays.asList(entries);
            }
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.retrieve.database.instance.list"), e);
        }
        return new ArrayList<DatabaseInstanceEntry>();
    }

    public DatabaseInstanceEntry getDatabaseInstance(int dbInsId) throws RemoteException {
        try {
            return this.stub.getDatabaseInstanceById(dbInsId);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.retrieve.database.instance.data"), e);
            return null;
        }
    }

    public void dropDatabase(int dbInsId) throws RemoteException {
        try {
            this.stub.dropDatabase(dbInsId);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.drop.database"), e);
        }
    }

    public List<RSSInstanceEntry> getRSSInstanceList(String tenantDomain) throws RemoteException {
        try {
            RSSInstanceEntry[] instances = this.stub.getRSSInstanceList();
            if (tenantDomain != null && instances != null) {
                return Arrays.asList(instances);
            }
            ArrayList<RSSInstanceEntry> localInstances = new ArrayList<RSSInstanceEntry>();
            if (instances != null) {
                for (RSSInstanceEntry rssIns : instances) {
                    if ("WSO2_RSS".equals(rssIns.getInstanceType())) continue;
                    localInstances.add(rssIns);
                }
            }
            return localInstances;
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.retrieve.RSS.instance.list"), e);
            return new ArrayList<RSSInstanceEntry>();
        }
    }

    public List<RSSInstanceEntry> getRSSInstanceList() throws RemoteException {
        try {
            RSSInstanceEntry[] instances = this.stub.getRSSInstanceList();
            if (instances != null) {
                return Arrays.asList(instances);
            }
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.retrieve.RSS.instance.list"), e);
        }
        return new ArrayList<RSSInstanceEntry>();
    }

    public String addRSSInstance(RSSInstance rssIns) throws RemoteException {
        try {
            this.stub.addRSSInstance(rssIns);
            return this.bundle.getString("rss.manager.database.server.instance.successfully.added");
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.add.database.server.instance") + ": " + rssIns.getName(), e);
            return this.bundle.getString("rss.manager.failed.to.add.database.server.instance") + ": " + rssIns.getName();
        }
    }

    public String testJDBCConnection(String driverClass, String jdbcUrl, String username, String password) throws RemoteException {
        try {
            String response = this.stub.testConnection(driverClass, jdbcUrl, username, password);
            return response;
        }
        catch (Exception e) {
            this.handleException("Error connecting to " + jdbcUrl, e);
            return "Error connecting to " + jdbcUrl;
        }
    }

    public String removeDatabaseInstance(int rssInsId) throws RemoteException {
        try {
            this.stub.removeRSSInstance(rssInsId);
            return this.bundle.getString("rss.manager.database.server.instance.successfully.removed");
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.remove.database.server.instance"), e);
            return null;
        }
    }

    public String editRSSInstanceInfo(RSSInstance rssIns) throws RemoteException {
        try {
            this.stub.editRSSInstance(rssIns);
            return this.bundle.getString("rss.manager.database.server.instance.successfully.edited");
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.edit.database.server.instance") + ": " + rssIns.getName(), e);
            return this.bundle.getString("rss.manager.failed.to.edit.database.server.instance") + ": " + rssIns.getName();
        }
    }

    public DatabaseUser getDatabaseUserById(int userId) throws RemoteException {
        try {
            return this.stub.getDatabaseUserById(userId);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.retrieve.database.user.data"), e);
            return null;
        }
    }

    public String deleteUser(int userId, int dbInsId) throws RemoteException {
        try {
            this.stub.dropUser(userId, dbInsId);
            return this.bundle.getString("rss.manager.database.user.successfully.dropped");
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.drop.database.user"), e);
            return null;
        }
    }

    public String createCarbonDataSource(int dbInsId, int userId) throws RemoteException {
        try {
            this.stub.createCarbonDSFromDatabaseUserEntry(dbInsId, userId);
            return this.bundle.getString("rss.manager.carbon.datasource.successfully.created");
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.create.carbon.datasource"), e);
            return this.bundle.getString("rss.manager.failed.to.create.carbon.datasource");
        }
    }

    public RSSInstanceEntry getRoundRobinAssignedInstance() throws RemoteException {
        try {
            return this.stub.getRoundRobinAssignedRSSInstance();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.retrieve.round.robin.assigned.instance"), e);
            return null;
        }
    }

    public String createUser(DatabaseUser user, int privGroupId, int dbInsId) throws RemoteException {
        try {
            this.stub.createUser(user, privGroupId, dbInsId);
            return this.bundle.getString("rss.manager.database.user.successfully.created");
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.create.database.user"), e);
            return this.bundle.getString("rss.manager.failed.to.create.database.user");
        }
    }

    public PrivilegeGroup getPrivilegeGroupById(int privGroupId) throws RemoteException {
        try {
            return this.stub.getPrivilegeGroupById(privGroupId);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.retrieve.database.privilege.group.data"), e);
            return null;
        }
    }

    private void handleException(String msg, Exception e) throws RemoteException {
        log.error((Object)msg, (Throwable)e);
        throw new RemoteException(msg, e);
    }

    public RSSInstance getRSSInstanceById(int rssInsId) throws RemoteException {
        try {
            return this.stub.getRSSInstanceDataById(rssInsId);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("rss.manager.failed.to.retrieve.database.server.instance.properties"), e);
            return null;
        }
    }
}

