/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle.module;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.modules.Module;
import org.apache.axis2.util.PolicyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.wso2.throttle.ConcurrentAccessController;
import org.wso2.throttle.Throttle;
import org.wso2.throttle.ThrottleException;
import org.wso2.throttle.ThrottleFactory;
import org.wso2.throttle.module.ThrottleEnguageUtils;
import org.wso2.throttle.module.ThrottleObserver;

public class ThrottleModule
implements Module {
    private static Log log = LogFactory.getLog((String)ThrottleModule.class.getName());
    private Policy defaultPolicy = null;
    private Throttle defaultThrottle = null;
    private ConfigurationContext configctx;

    public void init(ConfigurationContext configContext, AxisModule module) throws AxisFault {
        ArrayList list;
        Policy policy;
        this.configctx = configContext;
        this.initDefaultPolicy();
        this.initDefaultThrottle();
        ThrottleObserver observer = new ThrottleObserver(this.configctx, this.defaultThrottle);
        AxisConfiguration axisConfiguration = this.configctx.getAxisConfiguration();
        axisConfiguration.addObservers((AxisObserver)observer);
        PolicySubject policySubject = ThrottleEnguageUtils.readExternalGlobalPolicy(axisConfiguration);
        if (policySubject == null) {
            policySubject = module.getPolicySubject();
        }
        if (policySubject != null && (policy = PolicyUtil.getMergedPolicy(list = new ArrayList(policySubject.getAttachedPolicyComponents()), null)) != null) {
            Throttle throttle;
            try {
                throttle = ThrottleFactory.createModuleThrottle(policy);
            }
            catch (ThrottleException e) {
                log.error((Object)("Error was occurred when initiating throttle module " + e.getMessage()));
                log.info((Object)"Throttling will occur using default module policy");
                String id = policy.getId();
                policySubject.detachPolicyComponent(id);
                this.defaultPolicy.setId(id);
                policySubject.attachPolicy(this.defaultPolicy);
                throttle = this.defaultThrottle;
            }
            if (throttle != null) {
                HashMap<String, Throttle> throttles = (HashMap<String, Throttle>)this.configctx.getPropertyNonReplicable("local_throttle_map");
                if (throttles == null) {
                    throttles = new HashMap<String, Throttle>();
                    this.configctx.setNonReplicableProperty("local_throttle_map", throttles);
                }
                throttle.setId("id_of_global_throttle_");
                throttles.put("key_of_global_throttle", throttle);
                ConcurrentAccessController cac = throttle.getConcurrentAccessController();
                if (cac != null) {
                    String cacKey = "throttle_id_of_global_throttle__cac_key";
                    this.configctx.setProperty(cacKey, (Object)cac);
                }
            }
        }
    }

    public void engageNotify(AxisDescription axisDescription) throws AxisFault {
        ThrottleEnguageUtils.enguage(axisDescription, this.configctx, this.defaultThrottle);
    }

    public void shutdown(ConfigurationContext configurationContext) throws AxisFault {
    }

    public void applyPolicy(Policy policy, AxisDescription axisDescription) throws AxisFault {
    }

    public boolean canSupportAssertion(Assertion assertion) {
        return true;
    }

    private void initDefaultPolicy() throws AxisFault {
        InputStream inputStream = this.getClass().getResourceAsStream("/resources/policy/default_module_policy.xml");
        if (inputStream == null) {
            throw new AxisFault("Couldn't load the default throttle policy.The module is invalid ");
        }
        this.defaultPolicy = PolicyEngine.getPolicy((InputStream)inputStream);
    }

    private void initDefaultThrottle() throws AxisFault {
        block4: {
            try {
                if (this.defaultPolicy != null) {
                    this.defaultThrottle = ThrottleFactory.createModuleThrottle(this.defaultPolicy);
                    if (this.defaultThrottle == null) {
                        throw new AxisFault("Couldn't create the default throttle.The module is invalid ");
                    }
                    break block4;
                }
                throw new AxisFault("Couldn't find the default throttle policy .the module is invalid ");
            }
            catch (ThrottleException e) {
                String msg = "Error during processing default throttle policy + system will not works" + e.getMessage();
                log.error((Object)msg);
                throw new AxisFault(msg);
            }
        }
    }
}

