/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.throttle.internal;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.throttle.ThrottlingAxis2ConfigurationContextObserver;
import org.wso2.carbon.throttle.ThrottlingUtils;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.CarbonUtils;

public class ThrottleServiceComponent {
    private static Log log = LogFactory.getLog(ThrottleServiceComponent.class);
    private static RegistryService registryServiceInstance;
    private static RealmService realmService;
    private static BundleContext bundleContext;
    private ServiceRegistration axisConfigContextObserverServiceReg;

    protected void activate(ComponentContext ctxt) {
        try {
            bundleContext = ctxt.getBundleContext();
            this.saveTemplatePolicies(bundleContext);
            this.axisConfigContextObserverServiceReg = bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new ThrottlingAxis2ConfigurationContextObserver(), null);
            log.debug((Object)"Throttle bundle is activated");
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Throttle bundle", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        this.axisConfigContextObserverServiceReg.unregister();
        log.debug((Object)"Throttle bundle is deactivated");
    }

    protected void setRealmService(RealmService realmService) {
        ThrottleServiceComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        ThrottleServiceComponent.realmService = null;
    }

    protected void setRegistryService(RegistryService registryService) {
        registryServiceInstance = registryService;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        registryServiceInstance = null;
    }

    public static RegistryService getRegistryService() throws Exception {
        if (registryServiceInstance == null) {
            String msg = "Before activating Throttle Admin bundle, an instance of RegistryService should be in existance";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        return registryServiceInstance;
    }

    private void saveTemplatePolicies(BundleContext bundleContext) throws RegistryException, IOException {
        if (registryServiceInstance == null) {
            log.error((Object)"Failed to save template policies in throttling component");
            return;
        }
        UserRegistry registry = registryServiceInstance.getConfigSystemRegistry();
        try {
            registry.beginTransaction();
            ThrottlingUtils.saveTemplatePoliciesToRegistry((Registry)registry);
            registry.commitTransaction();
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            String msg = "Failed to save template policies in throttling component";
            log.error((Object)msg, (Throwable)e);
        }
    }

    public static BundleContext getBundleContext() {
        CarbonUtils.checkSecurity();
        return bundleContext;
    }
}

