/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.jdbc.PersistentBeanMgr;
import org.apache.sandesha2.storage.jdbc.PersistentStorageManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentInvokerBeanMgr
extends PersistentBeanMgr
implements InvokerBeanMgr {
    public PersistentInvokerBeanMgr(PersistentStorageManager pmgr) {
        super(pmgr);
    }

    private String requestForModel(InvokerBean bean) {
        StringBuilder sql = new StringBuilder(" select * from wsrm_invoker");
        if (bean == null) {
            return sql.toString();
        }
        String op = " where";
        String clause = bean.getMessageContextRefKey();
        if (clause != null) {
            sql.append(op);
            op = " and ";
            sql.append(" message_context_ref_key='");
            sql.append(clause);
            sql.append("'");
        }
        if ((clause = bean.getSequenceID()) != null) {
            sql.append(op);
            op = " and ";
            sql.append(" sequence_id='");
            sql.append(clause);
            sql.append("'");
        }
        if ((bean.getFlags() & 1) != 0) {
            sql.append(op);
            op = " and ";
            sql.append(" msg_no=");
            sql.append(bean.getMsgNo());
        }
        return sql.toString();
    }

    private InvokerBean getInvokerBean(ResultSet rs) throws Exception {
        InvokerBean invokerBean = new InvokerBean();
        invokerBean.setMessageContextRefKey(rs.getString("message_context_ref_key"));
        invokerBean.setSequenceID(rs.getString("sequence_id"));
        invokerBean.setMsgNo(rs.getLong("msg_no"));
        invokerBean.setFlags(rs.getInt("flags"));
        invokerBean.setContext((Serializable)this.getObject(rs, "context"));
        return invokerBean;
    }

    @Override
    public boolean delete(String key) throws SandeshaStorageException {
        try {
            Statement stmt = this.getDbConnection().createStatement();
            stmt.executeUpdate("delete from wsrm_invoker where message_context_ref_key='" + key + "'");
            stmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException(ex);
        }
        return true;
    }

    @Override
    public List<InvokerBean> find(InvokerBean bean) throws SandeshaStorageException {
        String sql = this.requestForModel(bean);
        ArrayList<InvokerBean> lst = new ArrayList<InvokerBean>();
        try {
            Statement stmt = this.getDbConnection().createStatement(1003, 1008);
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                lst.add(this.getInvokerBean(rs));
            }
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException(ex);
        }
        return lst;
    }

    @Override
    public boolean insert(InvokerBean bean) throws SandeshaStorageException {
        try {
            PreparedStatement pstmt = this.getDbConnection().prepareStatement("insert into wsrm_invoker(message_context_ref_key,sequence_id,context,msg_no,flags)values(?,?,?,?,?)");
            pstmt.setString(1, bean.getMessageContextRefKey());
            pstmt.setString(2, bean.getSequenceID());
            pstmt.setLong(4, bean.getMsgNo());
            pstmt.setInt(5, bean.getFlags());
            ByteArrayInputStream bais = this.serialize(bean.getContext());
            pstmt.setBinaryStream(3, (InputStream)bais, bais.available());
            pstmt.execute();
            pstmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException(ex);
        }
        return true;
    }

    @Override
    public InvokerBean retrieve(String key) throws SandeshaStorageException {
        InvokerBean invokerBean = null;
        try {
            Statement stmt = this.getDbConnection().createStatement(1003, 1008);
            ResultSet rs = stmt.executeQuery("select * from wsrm_invoker where message_context_ref_key='" + key + "'");
            if (!rs.next()) {
                return invokerBean;
            }
            invokerBean = this.getInvokerBean(rs);
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException(ex);
        }
        return invokerBean;
    }

    @Override
    public boolean update(InvokerBean bean) throws SandeshaStorageException {
        try {
            PreparedStatement pstmt = this.getDbConnection().prepareStatement("update wsrm_invoker set sequence_id=?,context=?,msg_no=?,flags=? where message_context_ref_key='" + bean.getMessageContextRefKey() + "'");
            pstmt.setString(1, bean.getSequenceID());
            pstmt.setLong(3, bean.getMsgNo());
            pstmt.setInt(4, bean.getFlags());
            ByteArrayInputStream bais = this.serialize(bean.getContext());
            pstmt.setBinaryStream(2, (InputStream)bais, bais.available());
            pstmt.execute();
            pstmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException(ex);
        }
        return true;
    }

    @Override
    public InvokerBean findUnique(InvokerBean bean) throws SandeshaException {
        String sql = this.requestForModel(bean);
        InvokerBean result = null;
        try {
            Statement stmt = this.getDbConnection().createStatement(1003, 1008);
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (result == null) {
                    result = this.getInvokerBean(rs);
                    continue;
                }
                String message = SandeshaMessageHelper.getMessage("nonUniqueResult", result.toString(), this.getInvokerBean(rs).toString());
                this.log.error((Object)message);
                throw new SandeshaException(message);
            }
            rs.close();
            stmt.close();
        }
        catch (Exception ex) {
            throw new SandeshaStorageException(ex);
        }
        return result;
    }
}

