/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rest.api.ui.client;

import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.rest.api.stub.RestApiAdminStub;
import org.wso2.carbon.rest.api.stub.types.carbon.APIData;
import org.wso2.carbon.rest.api.stub.types.carbon.ResourceData;

public class RestApiAdminClient {
    private static final Log log = LogFactory.getLog(RestApiAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.rest.api.ui.i18n.Resources";
    private ResourceBundle bundle;
    private RestApiAdminStub stub;

    public RestApiAdminClient(ConfigurationContext configCtx, String backendServerURL, String cookie, Locale locale) throws AxisFault {
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        String serviceURL = backendServerURL + "RestApiAdmin";
        this.stub = new RestApiAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setTimeOutInMilliSeconds(900000L);
        options.setProperty("SO_TIMEOUT", (Object)900000);
        options.setProperty("CONNECTION_TIMEOUT", (Object)900000);
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
    }

    public String[] getApiNames() throws AxisFault {
        try {
            String[] result = this.stub.getApiNames();
            if (result == null || result.length == 0 || result[0] == null) {
                return null;
            }
            return this.stub.getApiNames();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("unable.to.get.declared.apis"), e);
            return null;
        }
    }

    public APIData getApiByNane(String apiName) throws AxisFault {
        try {
            return this.stub.getApiByName(apiName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("failed.to.find.api"), e);
            return null;
        }
    }

    public void deleteApi(String apiName) throws AxisFault {
        try {
            this.stub.deleteApi(apiName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.delete.api"), e);
        }
    }

    public void addApi(APIData apiData) throws AxisFault {
        try {
            this.stub.addApi(apiData);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.add.api"), e);
        }
    }

    public void updateApi(APIData apiData) throws AxisFault {
        try {
            this.stub.updateApi(apiData.getName(), apiData);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.update.api"), e);
        }
    }

    public String[] getDefinedSequences() throws AxisFault {
        try {
            Object[] sequences = this.stub.getSequences();
            if (sequences != null && sequences.length != 0) {
                Arrays.sort(sequences);
            }
            return sequences;
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.get.sequences"), e);
            return null;
        }
    }

    public String getApiSource(APIData apiData) throws AxisFault {
        try {
            return this.stub.getApiSource(apiData);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.get.api.source"), e);
            return null;
        }
    }

    public String getResourceSource(ResourceData resourceData) throws AxisFault {
        try {
            return this.stub.getResourceSource(resourceData);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.get.resource.source"), e);
            return null;
        }
    }

    public void addApiFromString(String apiData) throws AxisFault {
        try {
            this.stub.addApiFromString(apiData);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.add.api"), e);
        }
    }

    public void updateApiFromString(String apiName, String apiData) throws AxisFault {
        try {
            this.stub.updateApiFromString(apiName, apiData);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.update.api"), e);
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

