/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rest.api.service;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.SequenceMediatorSerializer;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.rest.APIFactory;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.rest.API;
import org.apache.synapse.rest.Resource;
import org.apache.synapse.rest.dispatch.DispatcherHelper;
import org.apache.synapse.rest.dispatch.URITemplateHelper;
import org.apache.synapse.rest.dispatch.URLMappingHelper;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.rest.api.APIData;
import org.wso2.carbon.rest.api.APIException;
import org.wso2.carbon.rest.api.ResourceData;
import org.wso2.carbon.rest.api.RestApiAdminUtils;

public class RestApiAdmin
extends AbstractServiceBusAdmin {
    private static Log log = LogFactory.getLog(RestApiAdmin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addApi(APIData apiData) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.addApi(RestApiAdminUtils.retrieveAPIOMElement(apiData), null, false);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addApiFromString(String apiData) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            OMElement apiElement = AXIOMUtil.stringToOM((String)apiData);
            this.addApi(apiElement, null, false);
            boolean bl = true;
            return bl;
        }
        catch (XMLStreamException e) {
            this.handleException(log, "Could not parse String to OMElement", e);
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateApi(String apiName, APIData apiData) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.assertNameNotEmpty(apiName);
            API oldAPI = null;
            API api = APIFactory.createAPI((OMElement)RestApiAdminUtils.retrieveAPIOMElement(apiData));
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            oldAPI = synapseConfiguration.getAPI(apiName);
            if (oldAPI != null) {
                oldAPI.destroy();
                api.setFileName(oldAPI.getFileName());
            }
            synapseConfiguration.updateAPI(apiName, api);
            api.init(this.getSynapseEnvironment());
            MediationPersistenceManager pm = this.getMediationPersistenceManager();
            String fileName = api.getFileName();
            pm.deleteItem(apiName, fileName, 13);
            pm.saveItem(apiName, 13);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateApiFromString(String apiName, String apiData) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.assertNameNotEmpty(apiName);
            OMElement apiElement = AXIOMUtil.stringToOM((String)apiData);
            OMAttribute nameAttribute = apiElement.getAttribute(new QName("name"));
            if (nameAttribute == null || "".equals(nameAttribute.getAttributeValue().trim())) {
                apiElement.addAttribute("name", apiName, null);
            }
            API oldAPI = null;
            API api = APIFactory.createAPI((OMElement)apiElement);
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            oldAPI = synapseConfiguration.getAPI(apiName);
            if (oldAPI != null) {
                oldAPI.destroy();
                api.setFileName(oldAPI.getFileName());
            }
            synapseConfiguration.updateAPI(apiName, api);
            api.init(this.getSynapseEnvironment());
            MediationPersistenceManager pm = this.getMediationPersistenceManager();
            String fileName = api.getFileName();
            pm.deleteItem(apiName, fileName, 13);
            pm.saveItem(apiName, 13);
            boolean bl = true;
            return bl;
        }
        catch (XMLStreamException e) {
            this.handleException(log, "Could not parse String to OMElement", e);
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteApi(String apiName) throws APIException {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.assertNameNotEmpty(apiName);
            apiName = apiName.trim();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting API : " + apiName + " from the configuration"));
            }
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            API api = synapseConfiguration.getAPI(apiName);
            api.destroy();
            synapseConfiguration.removeAPI(apiName);
            MediationPersistenceManager pm = this.getMediationPersistenceManager();
            String fileName = api.getFileName();
            pm.deleteItem(apiName, fileName, 13);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Api : " + apiName + " removed from the configuration"));
            }
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getApiNames() {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Collection apis = synapseConfiguration.getAPIs();
            String[] stringArray = this.listToNames(apis.toArray(new API[apis.size()]));
            return stringArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APIData getApiByName(String apiName) {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            API api = synapseConfiguration.getAPI(apiName);
            APIData aPIData = this.convertApiToAPIData(api);
            return aPIData;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSequences() {
        Lock lock = this.getLock();
        String[] sequenceNames = new String[]{};
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Map sequences = synapseConfiguration.getDefinedSequences();
            if (sequences != null && !sequences.isEmpty()) {
                sequenceNames = new String[sequences.size()];
                String[] stringArray = sequences.keySet().toArray(sequenceNames);
                return stringArray;
            }
            String[] stringArray = sequenceNames;
            return stringArray;
        }
        finally {
            lock.unlock();
        }
    }

    public String getApiSource(APIData apiData) {
        return RestApiAdminUtils.retrieveAPIOMElement(apiData).toString();
    }

    public String getResourceSource(ResourceData resourceData) {
        return RestApiAdminUtils.retrieveResourceOMElement(resourceData).toString();
    }

    private APIData convertApiToAPIData(API api) {
        if (api == null) {
            return null;
        }
        APIData apiData = new APIData();
        apiData.setName(api.getName());
        apiData.setContext(api.getContext());
        apiData.setHost(api.getHost());
        apiData.setPort(api.getPort());
        apiData.setFileName(api.getFileName());
        Resource[] resources = api.getResources();
        ResourceData[] resourceDatas = new ResourceData[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            Resource resource = resources[i];
            ResourceData data = new ResourceData();
            String[] methods = resource.getMethods();
            data.setMethods(methods);
            data.setContentType(resource.getContentType());
            data.setProtocol(resource.getProtocol());
            DispatcherHelper dispatcherHelper = resource.getDispatcherHelper();
            if (dispatcherHelper instanceof URITemplateHelper) {
                data.setUriTemplate(dispatcherHelper.getString());
            } else if (dispatcherHelper instanceof URLMappingHelper) {
                data.setUrlMapping(dispatcherHelper.getString());
            }
            if (resource.getInSequenceKey() != null) {
                data.setInSequenceKey(resource.getInSequenceKey());
            } else if (resource.getInSequence() != null) {
                data.setInSeqXml(this.createAnonymousSequenceElement(resource.getInSequence(), "inSequence").toString());
            }
            if (resource.getOutSequenceKey() != null) {
                data.setOutSequenceKey(resource.getOutSequenceKey());
            } else if (resource.getOutSequence() != null) {
                data.setOutSeqXml(this.createAnonymousSequenceElement(resource.getOutSequence(), "outSequence").toString());
            }
            if (resource.getFaultSequenceKey() != null) {
                data.setFaultSequenceKey(resource.getFaultSequenceKey());
            } else if (resource.getFaultSequence() != null) {
                data.setFaultSeqXml(this.createAnonymousSequenceElement(resource.getFaultSequence(), "faultSequence").toString());
            }
            data.setUserAgent(resource.getUserAgent());
            resourceDatas[i] = data;
        }
        apiData.setResources(resourceDatas);
        return apiData;
    }

    private OMElement createAnonymousSequenceElement(SequenceMediator sequenceMediator, String seqElemName) {
        SequenceMediatorSerializer serializer = new SequenceMediatorSerializer();
        OMElement sequenceElem = serializer.serializeAnonymousSequence(null, sequenceMediator);
        if (!("inSequence".equals(seqElemName) || "outSequence".equals(seqElemName) || "faultSequence".equals(seqElemName))) {
            return null;
        }
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace syn = SynapseConstants.SYNAPSE_OMNAMESPACE;
        OMNamespace nullNS = fac.createOMNamespace("", "");
        OMElement seq = fac.createOMElement(seqElemName, syn);
        Iterator attributes = sequenceElem.getAllAttributes();
        while (attributes.hasNext()) {
            OMAttribute attrb = (OMAttribute)attributes.next();
            seq.addAttribute(attrb.getLocalName(), attrb.getAttributeValue(), nullNS);
        }
        Iterator children = sequenceElem.getChildElements();
        while (children.hasNext()) {
            OMElement child = (OMElement)children.next();
            seq.addChild((OMNode)child);
        }
        return seq;
    }

    private String[] listToNames(API[] apis) {
        if (apis == null) {
            return null;
        }
        String[] datas = new String[apis.length];
        for (int i = 0; i < apis.length; ++i) {
            API api = apis[i];
            datas[i] = api.getName();
        }
        return datas;
    }

    private void addApi(OMElement apiElement, String fileName, boolean updateMode) throws APIException {
        block14: {
            try {
                if (apiElement.getQName().getLocalPart().equals(XMLConfigConstants.API_ELT.getLocalPart())) {
                    String apiName = apiElement.getAttributeValue(new QName("name"));
                    if (this.getSynapseConfiguration().getAxisConfiguration().getService(apiName) != null) {
                        this.handleException(log, "A service named " + apiName + " already exists", null);
                        break block14;
                    }
                    API api = APIFactory.createAPI((OMElement)apiElement);
                    try {
                        this.getSynapseConfiguration().addAPI(api.getName(), api);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Added API : " + apiName));
                        }
                        if (updateMode) {
                            api.setFileName(fileName);
                        } else if (fileName != null) {
                            api.setFileName(fileName);
                        } else {
                            api.setFileName(ServiceBusUtils.generateFileName((String)api.getName()));
                        }
                        api.init(this.getSynapseEnvironment());
                        this.persistApi(api);
                    }
                    catch (Exception e) {
                        api.destroy();
                        this.getSynapseConfiguration().removeAPI(api.getName());
                        try {
                            if (this.getAxisConfig().getService(api.getName()) != null) {
                                this.getAxisConfig().removeService(api.getName());
                            }
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                        this.handleException(log, "Error trying to add the API to the ESB configuration : " + api.getName(), e);
                    }
                    break block14;
                }
                this.handleException(log, "Invalid API definition", null);
            }
            catch (AxisFault af) {
                this.handleException(log, "Invalid API definition", (Exception)((Object)af));
            }
        }
    }

    private void handleException(Log log, String message, Exception e) throws APIException {
        if (e == null) {
            APIException apiException = new APIException(message);
            log.error((Object)message, (Throwable)apiException);
            throw apiException;
        }
        message = message + " :: " + e.getMessage();
        log.error((Object)message, (Throwable)e);
        throw new APIException(message, e);
    }

    private void persistApi(API api) throws APIException {
        MediationPersistenceManager pm = this.getMediationPersistenceManager();
        if (pm != null) {
            pm.saveItem(api.getName(), 13);
        }
    }

    private void assertNameNotEmpty(String apiName) throws APIException {
        if (apiName == null || "".equals(apiName.trim())) {
            this.handleFault("Invalid name : Name is empty.", null);
        }
    }

    private void handleFault(String message, Exception e) throws APIException {
        if (e != null) {
            log.error((Object)message, (Throwable)e);
            throw new APIException(e.getMessage(), e);
        }
        log.error((Object)message);
        throw new APIException(message);
    }
}

