/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rest.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.SynapseConfiguration;
import org.wso2.carbon.mediation.dependency.mgt.services.DependencyManagementService;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.rest.api.APIException;

public class ConfigHolder {
    private static ConfigHolder instance;
    private static final Log log;
    private SynapseConfiguration synapseConfiguration;
    private AxisConfiguration axisConfiguration;
    private UserRegistry configRegistry;
    private UserRegistry governanceRegistry;
    private DependencyManagementService dependencyManager;
    private Map<Integer, SynapseEnvironmentService> synapseEnvironmentServices = new HashMap<Integer, SynapseEnvironmentService>();

    private ConfigHolder() {
    }

    public static ConfigHolder getInstance() {
        if (instance == null) {
            instance = new ConfigHolder();
        }
        return instance;
    }

    public SynapseConfiguration getSynapseConfiguration() throws APIException {
        this.assertNull("SynapseConfiguration", this.synapseConfiguration);
        return this.synapseConfiguration;
    }

    public void setSynapseConfiguration(SynapseConfiguration synapseConfiguration) {
        this.synapseConfiguration = synapseConfiguration;
    }

    public AxisConfiguration getAxisConfiguration() throws APIException {
        this.assertNull("AxisConfiguration", this.axisConfiguration);
        return this.axisConfiguration;
    }

    public void setAxisConfiguration(AxisConfiguration axisConfiguration) {
        this.axisConfiguration = axisConfiguration;
    }

    public UserRegistry getConfigRegistry() throws APIException {
        this.assertNull("Registry", this.configRegistry);
        return this.configRegistry;
    }

    public void setConfigRegistry(UserRegistry configRegistry) {
        this.configRegistry = configRegistry;
    }

    public DependencyManagementService getDependencyManager() {
        return this.dependencyManager;
    }

    public void setDependencyManager(DependencyManagementService dependencyManager) {
        this.dependencyManager = dependencyManager;
    }

    private void assertNull(String name, Object object) throws APIException {
        if (object == null) {
            String message = name + " reference in the proxy admin config holder is null";
            log.error((Object)message);
            throw new APIException(message);
        }
    }

    public UserRegistry getGovernanceRegistry() {
        return this.governanceRegistry;
    }

    public void setGovernanceRegistry(UserRegistry governanceRegistry) {
        this.governanceRegistry = governanceRegistry;
    }

    public SynapseEnvironmentService getSynapseEnvironmentService(int id) {
        return this.synapseEnvironmentServices.get(id);
    }

    public void addSynapseEnvironmentService(int id, SynapseEnvironmentService synapseEnvironmentService) {
        this.synapseEnvironmentServices.put(id, synapseEnvironmentService);
    }

    public void removeSynapseEnvironmentService(int id) {
        this.synapseEnvironmentServices.remove(id);
    }

    public Map<Integer, SynapseEnvironmentService> getSynapseEnvironmentServices() {
        return this.synapseEnvironmentServices;
    }

    static {
        log = LogFactory.getLog(ConfigHolder.class);
    }
}

